<?php
/**
 * @package Bravisthemes-Themes
 */
$subtitle_404 = dreamslab()->get_theme_opt('subtitle_404');
$title_404 = dreamslab()->get_theme_opt('title_404');
$des_404 = dreamslab()->get_theme_opt('des_404');
$button_404 = dreamslab()->get_theme_opt('button_404');
get_header(); ?>
<div class="wrap-content-404">
    <div class="pxl-error-image" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/img/404.webp'); ?>);">
    </div>
    <div class="pxl-error-inner">
        <div class="content">
            <span class="pxl-error-subtitle">
                <?php if (!empty($subtitle_404)) {
                    echo pxl_print_html($subtitle_404);
                } else{
                    echo esc_html__('Oopsie', 'dreamslab'); 
                } ?>
            </span>
            <div class="pxl-error-number">
                <span style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/img/404-1.webp'); ?>);"></span>
            </div>
            <h3 class="pxl-error-title">
                <?php if (!empty($title_404)) {
                    echo pxl_print_html($title_404);
                } else{
                   echo esc_html__( '404 page not found', 'dreamslab' );
               } ?>
           </h3>
           <div class="pxl-error-bottom">
            <div class="pxl-error-left">
               <p class="pxl-error-description">
                <?php if (!empty($des_404)) {
                    echo pxl_print_html($des_404);
                } else{
                    echo esc_html__('The page you are looking for doesn\'t exist. It may have been moved or removed altogether. Please try
                        searching for some other page, or return to the website\'s homepage to find what you\'re looking for.', 'dreamslab');
                    } ?>
                </p>
            </div>
            <a class="btn btn-border" href="<?php echo esc_url(home_url('/')); ?>">
                <span>
                    <?php if (!empty($button_404)) {
                        echo pxl_print_html($button_404);
                    } else{
                        echo esc_html__('back to home', 'dreamslab'); 
                   } ?>
               </span>
               <svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" enable-background="new 0 0 20 20" height="512" viewBox="0 0 20 20" width="512"><path d="m12 2-1.4 1.4 5.6 5.6h-16.2v2h16.2l-5.6 5.6 1.4 1.4 8-8z" fill="rgb(0,0,0)"/></svg>
           </a>
       </div>
   </div>
</div>
<?php get_footer();
