<?php if ( class_exists( 'WooCommerce' ) ) {
    add_action( 'pxl_anchor_target', 'dreamslab_hook_anchor_cart');
    $cart_count = 0;
    if ( function_exists( 'WC' ) && WC()->cart ) {
        $cart_count = WC()->cart->get_cart_contents_count();
    }
    ?>
    <div class="pxl-cart-sidebar-button <?php echo esc_attr($settings['style']); ?>">
        <?php
        if ( ! empty( $settings['pxl_icon']['value'] ) ) {
            \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true' ], 'i' );
        } elseif ( ! empty( $settings['image']['id'] ) ) {
            $image_size = ! empty( $settings['img_size'] ) ? $settings['img_size'] : 'full';
            $img        = pxl_get_image_by_size( [
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $image_size,
            ] );
            echo wp_kses_post( $img['thumbnail'] );
        } else {
            echo '<i class="bootstrap-icons bi-cart"></i>';
        }
        ?>

        <span class="pxl_cart_counter">
            <?php echo sprintf( _n( '%d', '%d', $cart_count, 'dreamslab' ), $cart_count ); ?>
        </span>
    </div>
<?php } ?>
