<?php 
$html_id = pxl_get_element_id($settings); 
if ( ! empty( $settings['link']['url'] ) ) {
	$widget->add_render_attribute( 'button', 'href', $settings['link']['url'] );

	if ( $settings['link']['is_external'] ) {
		$widget->add_render_attribute( 'button', 'target', '_blank' );
	}

	if ( $settings['link']['nofollow'] ) {
		$widget->add_render_attribute( 'button', 'rel', 'nofollow' );
	}
}
?>
<div class="pxl-banner pxl-banner2 <?php echo esc_attr($settings['style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
	<div class="pxl-banner-inner">
		<?php if(!empty($settings['banner_image']['id'])) :
			$img = pxl_get_image_by_size( array(
				'attach_id'  => $settings['banner_image']['id'],
				// 'thumb_size' => '880x716',
				'thumb_size' => 'full',
			));
			$thumbnail = $img['thumbnail']; ?>
			<div class="pxl-item--image">
				<?php echo pxl_print_html($thumbnail); ?>
			</div>
		<?php endif; ?>
		<?php if(!empty($settings['banner_image_logo']['id'])) :
			$img_l = pxl_get_image_by_size( array(
				'attach_id'  => $settings['banner_image_logo']['id'],
				'thumb_size' => 'full',
			));
			$thumbnail_l = $img_l['thumbnail']; ?>
			<div class="pxl-item--logo pxl-middle">
				<?php echo pxl_print_html($thumbnail_l); ?>
			</div>
		<?php endif; ?>
		<?php foreach ($settings['item'] as $key => $value): 
			$content = isset($value['content']) ? $value['content'] : ''; 
			$item_position = isset($value['item_position']) ? $value['item_position'] : ''; 
			$link_key = $widget->get_repeater_setting_key('icon_link', 'value', $key);

			if (!empty($value['icon_link']['url'])) {
				$widget->add_render_attribute($link_key, 'href', $value['icon_link']['url']);

				if (!empty($value['icon_link']['is_external'])) {
					$widget->add_render_attribute($link_key, 'target', '_blank');
				}

				if (!empty($value['icon_link']['nofollow'])) {
					$widget->add_render_attribute($link_key, 'rel', 'nofollow');
				}
			}

			$link_attributes = $widget->get_render_attribute_string($link_key);
			?>
			<a class="elementor-repeater-item-<?php echo esc_attr($value['_id'] . ' ' . $item_position); ?> wow zoomIn" <?php echo wp_kses_post($link_attributes); ?>>
				<?php if (!empty($content)): ?>
					<i class="pxl-icon--plus"></i>
					<div class="pxl-counter--content">
						<?php echo pxl_print_html($content); ?>
					</div>
				<?php endif; ?>
			</a>
		<?php endforeach; ?>
	</div>
</div>