<?php
$html_id = pxl_get_element_id($settings);

if (!empty($settings['link']['url'])) {
    $widget->add_render_attribute('button', 'href', $settings['link']['url']);
    if (!empty($settings['link']['is_external'])) {
        $widget->add_render_attribute('button', 'target', '_blank');
    }
    if (!empty($settings['link']['nofollow'])) {
        $widget->add_render_attribute('button', 'rel', 'nofollow');
    }
}

$template = (int) $widget->get_setting('popup_template', '0');
if ($template > 0 && !has_action('pxl_anchor_target_page_popup_' . $template)) {
    add_action('pxl_anchor_target_page_popup_' . $template, 'dreamslab_hook_anchor_page_popup');
}

$parallax_x = isset($settings['parallax_value_x']) ? sanitize_parallax_values($settings['parallax_value_x']) : 0;
$parallax_y = isset($settings['parallax_value_y']) ? sanitize_parallax_values($settings['parallax_value_y']) : 0;
$parallax_z = isset($settings['parallax_value_z']) ? sanitize_parallax_values($settings['parallax_value_z']) : 0;

$parallax_data = wp_json_encode([
    'x' => $parallax_x,
    'y' => $parallax_y,
    'z' => $parallax_z,
]);
$has_parallax = ($parallax_x != 0 || $parallax_y != 0 || $parallax_z != 0);

$btn_icon        = !empty($settings['btn_icon']) ? $settings['btn_icon'] : '';
$btn_style       = !empty($settings['btn_style']) ? $settings['btn_style'] : '';
$btn_text_effect = !empty($settings['btn_text_effect']) ? $settings['btn_text_effect'] : '';
$btn_text        = !empty($settings['text']) ? $settings['text'] : '';
$chars           = preg_split('//u', $btn_text, -1, PREG_SPLIT_NO_EMPTY);

/** ==== Build wrapper classes ==== */
$wrapper_classes = [
    'pxl-button',
    $settings['btn_action'],
    $settings['pxl_animate'],
];
if ($has_parallax) {
    $wrapper_classes[] = 'pxl-button-parallax';
}

/** ==== Build <a> button classes ==== */
$btn_classes = ['btn'];
if ($btn_style === 'btn-popup') {
    $btn_classes[] = 'pxl-action-popup';
}
if ($btn_style === 'btn-drow-arrow') {
    $btn_classes[] = 'parallax-wrap';
}
if (!empty($btn_icon)) {
    $btn_classes[] = 'pxl-icon-active';
}
$btn_classes[] = $btn_text_effect;
$btn_classes[] = $btn_style;
$btn_classes[] = $settings['pxl_animate'];
$btn_classes[] = $settings['btn_w'];
$btn_classes[] = 'pxl-icon--' . $settings['icon_align'];
?>

<div id="pxl-<?php echo esc_attr($html_id); ?>"
     class="<?php echo esc_attr(implode(' ', array_filter($wrapper_classes))); ?>"
     data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms"
     data-pxl-parallax='<?php echo esc_attr($parallax_data); ?>'>

    <a data-cursor-hover
       <?php pxl_print_html($widget->get_render_attribute_string('button')); ?>
       class="<?php echo esc_attr(implode(' ', array_filter($btn_classes))); ?>"
       data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms"
       data-target=".pxl-page-popup-template-<?php echo esc_attr($template); ?>">

        <?php if ($btn_text_effect !== 'btn-text-applied' && $btn_style !== 'btn-icon-box-square' && $btn_style !== 'btn-full-box') : ?>
            <?php if ($btn_style === 'btn-drow-arrow') : ?>
                <span class="icon-arrow">
            <?php if (!empty($btn_icon)) \Elementor\Icons_Manager::render_icon($btn_icon, ['aria-hidden' => 'true'], 'i'); ?>
                </span>
            <?php else: ?>
                <?php if (!empty($btn_icon)) \Elementor\Icons_Manager::render_icon($btn_icon, ['aria-hidden' => 'true'], 'i'); ?>
            <?php endif; ?>

        <?php elseif ($btn_style === 'btn-icon-box-square' || $btn_style === 'btn-full-box') : ?>
            <span class="button-arrow-hover">
                <?php
                if (!empty($btn_icon)) {
                    \Elementor\Icons_Manager::render_icon($btn_icon, ['aria-hidden' => 'true'], 'i');
                    \Elementor\Icons_Manager::render_icon($btn_icon, ['aria-hidden' => 'true'], 'i');
                }
                ?>
            </span>

        <?php else : ?>
            <span class="btn-icon-left">
                <?php if (!empty($btn_icon)) \Elementor\Icons_Manager::render_icon($btn_icon, ['aria-hidden' => 'true'], 'i'); ?>
            </span>
        <?php endif; ?>

        <?php if ($btn_style === 'btn-icon-box-dot') : ?>
            <svg class="pxl-scroll-progress-circle" width="100%" height="100%" viewBox="-1 -1 102 102">
                <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"/>
            </svg>
        <?php endif; ?>

        <span class="pxl--btn-text" data-text="<?php echo esc_attr($btn_text); ?>">
            <?php
            if (in_array($btn_text_effect, ['btn-text-nina', 'btn-text-nanuk'], true)) {
                foreach ($chars as $char) {
                    if ($char === ' ') {
                        echo '<span class="spacer">&nbsp;</span>';
                    } else {
                        printf('<span>%s</span>', esc_html($char));
                    }
                }

            } elseif (in_array($btn_text_effect, ['btn-text-applied', 'btn-hide-icon'], true) || $btn_style === 'btn-border') {
                echo '<span class="chars">';
                $totalChars = count($chars) - 1;
                foreach ($chars as $i => $char) {
                    $class  = ($char === ' ') ? 'spacer' : '';
                    $output = ($char === ' ') ? '&nbsp;' : esc_html($char);

                    printf(
                        '<span class="%s" style="--chars-index:%d; --chars-last-index:%d;">%s</span>',
                        esc_attr($class),
                        esc_attr($i),
                        esc_attr($totalChars - $i),
                        $output
                    );
                }
                echo '</span>';

            } elseif (in_array($btn_text_effect, ['btn-text-smoke', 'btn-text-reverse'], true)) {
                foreach (['front', 'back'] as $side) {
                    echo '<span class="pxl-text--' . esc_attr($side) . '"><span class="pxl-text--inner">';
                    foreach ($chars as $char) {
                        if ($char === ' ') {
                            echo '<span class="spacer">&nbsp;</span>';
                        } else {
                            printf('<span>%s</span>', esc_html($char));
                        }
                    }
                    echo '</span></span>';
                }

            } else {
                echo '<span>' . esc_html($btn_text) . '</span>';
            }
            ?>
        </span>

        <?php if ($btn_text_effect === 'btn-text-applied') : ?>
            <span class="btn-icon-right">
                <?php if (!empty($btn_icon)) \Elementor\Icons_Manager::render_icon($btn_icon, ['aria-hidden' => 'true'], 'i'); ?>
            </span>
        <?php endif; ?>

        <?php if ($btn_style === 'btn-stroke') : ?>
            <svg class="pxl-svg-line" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 407">
                <path d="M972.93,86.54S671-39.25,337.37,29.6c-80.16,16.54-161,42.55-230.72,86.3-41.44,26-92,65.5-97.81,118.12-6,54.11,45,90.17,88,110.52,70.87,33.53,149.4,43.59,226.73,49.23,125.73,9.17,252.43,1.74,377.33-14.07,51.43-6.5,102.76-14.71,152.76-28.37,61-16.66,156.08-57.51,137.63-137.73C979.5,162.21,933.23,134.78,887,117.4,814.24,90,734.45,79.35,657.54,71.31c-7-.73-13.94-1.42-20.93-2"/>
            </svg>
        <?php endif; ?>

    </a>
</div>
