<?php
$widget->add_render_attribute( 'counter', [
    'class' => 'pxl-counter--value '.$settings['effect'].' '.$settings['custom_font'].'',
    'data-duration' => $settings['duration'],
    'data-startnumber' => $settings['starting_number'],
    'data-endnumber' => $settings['ending_number'],
    'data-to-value' => $settings['ending_number'],
    'data-delimiter' => $settings['thousand_separator_char'],
] );

if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
} ?>
<div class="pxl-counter pxl-counter8 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-counter--inner">
        <div class="pxl-counter--holder ">
            <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
                <div class="pxl-counter--icon">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                </div>
            <?php endif; ?>
            <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
                <div class="pxl-counter--icon">
                    <?php $img_icon  = pxl_get_image_by_size( array(
                        'attach_id'  => $settings['icon_image']['id'],
                        'thumb_size' => 'full',
                    ) );
                    $thumbnail_icon    = $img_icon['thumbnail'];
                    echo pxl_print_html($thumbnail_icon); ?>
                </div>
            <?php endif; ?>
            <div class="pxl-counter--number ">
                <span class="pxl-counter--prefix el-empty"><?php echo pxl_print_html($settings['prefix']); ?></span>
                <span <?php pxl_print_html($widget->get_render_attribute_string( 'counter' )); ?>><?php echo esc_html($settings['starting_number']); ?></span>
                <?php if(!empty($settings['suffix'])) : ?>
                    <span class="pxl-counter--suffix"><?php echo pxl_print_html($settings['suffix']); ?></span>
                <?php endif; ?>
            </div>
            <div class="pxl-divider"></div>
            <?php if(!empty($settings['title'])) : ?>
               <div class="pxl-counter--title <?php echo esc_attr($settings['title_w']); ?>"><a <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?>><?php echo pxl_print_html($settings['title']); ?></a></div>
           <?php endif; ?>
       </div>
       <div class="pxl-counter--backdrop">
        <?php if(!empty($settings['title'])) : ?>
            <div class="pxl-counter--title <?php echo esc_attr($settings['title_w']); ?>"><a <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?>><?php echo pxl_print_html($settings['title']); ?></a></div>
        <?php endif; ?>
        <?php if(!empty($settings['title'])) : ?>
            <div class="pxl-counter--content"><p><?php echo pxl_print_html($settings['content']); ?></p></div>
        <?php endif; ?>
        <a <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?> class="btn btn-default btn-text-nanuk">
            <span class="pxl--btn-text">
                <?php 
                $btn_text = $settings['button_text'];
                $chars = preg_split('//u', $btn_text, -1, PREG_SPLIT_NO_EMPTY);
                foreach ($chars as $value) {
                    if($value == ' ') {
                        echo '<span class="spacer">&nbsp;</span>';
                    } else {
                        echo '<span>'.$value.'</span>';
                    }
                }
            ?></span>
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 753.2 476.2" style="enable-background:new 0 0 753.2 476.2;" xml:space="preserve">
                <polygon points="622.6,107.5 601.4,128.7 695.8,223.1 277,223.1 277,253.1 695.8,253.1 601.4,347.5 622.6,368.7 753.2,238.1 "/>
                <rect y="223.1" width="283.9" height="30"/>
            </svg>
        </a>
    </div>
</div>
</div>