 <?php
 $col_xs = $widget->get_setting('col_xs', '');
 $col_sm = $widget->get_setting('col_sm', '');
 $col_md = $widget->get_setting('col_md', '');
 $col_lg = $widget->get_setting('col_lg', '');
 $col_xl = $widget->get_setting('col_xl', '');
 $col_xxl = $widget->get_setting('col_xxl', '');
 if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$grid_masonry = $widget->get_setting('grid_masonry');
$images_size = !empty($img_size) ? $img_size : 'full';
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite', false);  
$reverse = $widget->get_setting('reverse', false);  
$effect = $widget->get_setting('effect','slide');
$speed = $widget->get_setting('speed', '500');
$drap = $widget->get_setting('drap', false);  
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => $effect,
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'            => $col_xxl, 
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => $col_sm, 
    'slides_to_show_xs'             => $col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'reverse'                       => $reverse,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
$cursor_arrow_cls = 'cursor-arrow';
$pxl_g_id = uniqid();
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full';
if(isset($settings['image']) && !empty($settings['image']) && count($settings['image'])): ?>
    <div id="pxl-gallery-<?php echo esc_attr($pxl_g_id); ?>" class="pxl-swiper-slider pxl-image-carousel pxl-image-carousel1 <?php echo esc_attr($settings['style']); ?>" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_attr('DRAG');?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">

            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['image'] as $key => $value):
                        $image = isset($value['image']) ? $value['image'] : '';
                        $source = isset($value['source']) ? $value['source'] : '';
                        $video_link = isset($value['video_link']) ? $value['video_link'] : '';

                        if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                            $img_size_m = $grid_masonry[$key]['img_size_m'];

                            if(!empty($img_size_m)) {
                                $images_size = $img_size_m;                                
                            }
                        } elseif (!empty($img_size)) {
                            $images_size = $img_size;
                        }
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate'].' '.$settings['style_img']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                            <?php if(!empty($image['id'])) { 
                                $class = 'no-lazyload' . ($effect == 'gl' ? ' swiper-gl-image' : '');
                                $img = pxl_get_image_by_size( array(
                                    'attach_id'  => $image['id'],
                                    'thumb_size' => $images_size,
                                    'class'      => $class,
                                ));
                                $thumbnail = $img['thumbnail'];
                                $thumbnail_url = $img['url'];
                                ?>
                                <?php if ($settings['style_img'] == 'image') { ?>
                                    <div class="pxl-item--image ">
                                        <?php if ($settings['image_parallax'] == true) { ?>
                                            <img src="<?php echo esc_attr($thumbnail_url); ?>" alt="img-<?php echo esc_attr($key); ?>">
                                        <?php } else { ?>
                                            <?php echo wp_kses_post($thumbnail); ?>
                                        <?php } ?>
                                        <?php if ($settings['style'] == 'style-2'): ?>
                                            <a href="<?php echo esc_url($thumbnail_url); ?>" class="lightbox" data-elementor-lightbox-slideshow="pxl-gallery-<?php echo esc_attr($pxl_g_id); ?>"><i class="fas fa-eye"></i></a>
                                        <?php endif ?>
                                        <?php if ($settings['style'] == 'style-4'): ?>
                                            <a href="<?php echo esc_url($thumbnail_url); ?>" class="lightbox" data-elementor-lightbox-slideshow="pxl-gallery-<?php echo esc_attr($pxl_g_id); ?>"><?php esc_html_e('Click To View Image', 'dreamslab'); ?></a>
                                        <?php endif ?>
                                        <?php if ($settings['style'] == 'style-5'): ?>
                                            <a href="<?php echo esc_url($thumbnail_url); ?>" class="lightbox" data-elementor-lightbox-slideshow="pxl-gallery-<?php echo esc_attr($pxl_g_id); ?>"></a>
                                        <?php endif ?>
                                    </div>
                                <?php } ?>
                                <?php if ($settings['style_img'] == 'bgr') { ?>
                                    <div class="pxl-item--image " style="background-image: url(<?php echo esc_attr($thumbnail_url); ?>);">
                                        <?php if ($settings['style'] == 'style-2'): ?>
                                            <a href="<?php echo esc_url($thumbnail_url); ?>" class="lightbox" data-elementor-lightbox-slideshow="pxl-gallery-<?php echo esc_attr($pxl_g_id); ?>"><i class="fas fa-eye"></i></a>
                                        <?php endif ?>
                                        <?php if ($settings['style'] == 'style-4'): ?>
                                            <a href="<?php echo esc_url($thumbnail_url); ?>" class="lightbox" data-elementor-lightbox-slideshow="pxl-gallery-<?php echo esc_attr($pxl_g_id); ?>"><?php esc_html_e('Click To View Image', 'dreamslab'); ?></a>
                                        <?php endif ?>
                                        <?php if ($settings['style'] == 'style-5'): ?>
                                            <a href="<?php echo esc_url($thumbnail_url); ?>" class="lightbox" data-elementor-lightbox-slideshow="pxl-gallery-<?php echo esc_attr($pxl_g_id); ?>"></a>
                                        <?php endif ?>
                                    </div>
                                <?php } ?>

                            <?php } ?>
                            <?php if(!empty($video_link) && $source == 'mp4') : ?>
                                <div class="localvideo-bg">
                                    <video autoplay="" muted="" loop="" playsinline="">
                                        <source src="<?php echo esc_url($video_link); ?>" type="video/mp4">
                                        </video>
                                    </div>
                                <?php endif; ?>
                                <?php if(!empty($video_link) && $source == 'youtube') : ?>
                                    <iframe 
                                    class="elementor-video"
                                    src="<?php echo esc_url(str_replace('watch?v=', 'embed/', $video_link) . '?rel=0&autoplay=1&mute=1&showinfo=0&modestbranding=1'); ?>" 
                                    frameborder="0" 
                                    title="YouTube video player" 
                                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                    allowfullscreen>
                                </iframe>
                            <?php endif; ?>
                            <?php if(!empty($video_link) && $source == 'vimeo') : ?>
                             <iframe 
                             src="<?php echo esc_url(str_replace('vimeo.com/', 'player.vimeo.com/video/', $video_link) . '?rel=0&autoplay=1&mute=1&showinfo=0&modestbranding=1'); ?>" 
                             frameborder="0" 
                             title="Vimeo video player" 
                             allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                             allowfullscreen>
                         </iframe>
                     <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php if($arrows !== false): ?>
            <div class="pxl-swiper-arrow-wrap <?php echo esc_attr($settings['arr_style']); ?>">
                <?php if ($settings['arr_style'] == 'style-1') { ?>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 57.7 60.45"><polyline class="cls-1" points="26.8 0.71 56.28 30.23 26.8 59.74"></polyline><line class="cls-1" x1="56.28" y1="30.23" y2="30.23"></line></svg></div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 57.7 60.45"><polyline class="cls-1" points="26.8 0.71 56.28 30.23 26.8 59.74"></polyline><line class="cls-1" x1="56.28" y1="30.23" y2="30.23"></line></svg></div>
                <?php } else if ($settings['arr_style'] == 'style-2' || $settings['arr_style'] == 'style-4') { ?>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" enable-background="new 0 0 20 20" height="16" viewBox="0 0 20 20" width="18"><path d="m12 2-1.4 1.4 5.6 5.6h-16.2v2h16.2l-5.6 5.6 1.4 1.4 8-8z" fill="rgb(0,0,0)"/></svg></div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" enable-background="new 0 0 20 20" height="16" viewBox="0 0 20 20" width="18"><path d="m12 2-1.4 1.4 5.6 5.6h-16.2v2h16.2l-5.6 5.6 1.4 1.4 8-8z" fill="rgb(0,0,0)"/></svg></div>
                <?php } else if ($settings['arr_style'] == 'style-3') { ?>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev <?php echo esc_attr($cursor_arrow_cls.'-prev') ?>"></div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next <?php echo esc_attr($cursor_arrow_cls.'-next') ?>"></div>
                <?php } ?>
            </div>
        <?php endif; ?>
    </div>
    <?php if($pagination !== false): ?>
        <div class="pxl-swiper-bottom pxl-flex-middle">
            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots style-1"></div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>
<?php endif; ?>
