<?php
$all_images = [];

if (!empty($settings['image7'])) {
    foreach ($settings['image7'] as $item) {
        if (!empty($item['gallery'])) {
            foreach ($item['gallery'] as $image) {
                $all_images[] = $image;
            }
        }
    }
}

$columns = 3;
$grouped_columns = array_fill(0, $columns, []);
foreach ($all_images as $index => $image) {
    $column_index = $index % $columns;
    $grouped_columns[$column_index][] = $image;
}
?>
<div class="columns-wrapper">
    <?php foreach ($grouped_columns as $col_index => $images): 
        $col_id = 'col' . ($col_index + 1); ?>
        <div class="column">
            <div class="column-inner" id="<?php echo esc_attr($col_id); ?>">
                <?php
                for ($r = 0; $r < 2; $r++) {
                    foreach ($images as $image) {
                        $thumb = wp_get_attachment_image($image['id'], 'full');
                        echo '<div class="slide">' . wp_kses_post($thumb) . '</div>';
                    }
                }
                ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>
