<?php 
$number = 1;
$img_size = isset($value['img_size']) ? $value['img_size'] : 'full';
$data_settings = array(
    'height' => $settings['gallery_height'],
    'width' => $settings['gallery_width'],
    'radius' => $settings['gallery_radius'],
);
if(isset($settings['images']) && !empty($settings['images']) && count($settings['images'])): 
    ?>
<div class="pxl-images-slip pxl-images-slip2 <?php echo esc_attr($settings['effect_style']); ?>" data-settings="<?php echo esc_attr( json_encode( $data_settings ) ); ?>">
    <div class="pxl-images--content">
        <?php foreach ($settings['images'] as $key => $value) :
            $image = isset($value['image']) ? $value['image'] : '';
            $is_active = ($number === 1) ? 'active' : '';
            ?>
            <div class="pxl-item--content <?php echo esc_attr($is_active); ?>">
                <?php if(!empty($image['id'])) { 
                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $image['id'],
                        'thumb_size' => $img_size,
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];
                    ?>
                    <?php echo wp_kses_post($thumbnail); ?>
                <?php } ?>
            </div>
            <?php 
            $number++;
        endforeach; ?>
    </div>
</div>
<?php endif; ?>
