<?php 
if ( ! empty( $settings['item_link']['url'] ) ) {
	$widget->add_render_attribute( 'button', 'href', $settings['item_link']['url'] );

	if ( $settings['item_link']['is_external'] ) {
		$widget->add_render_attribute( 'button', 'target', '_blank' );
	}

	if ( $settings['item_link']['nofollow'] ) {
		$widget->add_render_attribute( 'button', 'rel', 'nofollow' );
	}
}
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full';
?>
<div class="pxl-info-box2 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
	<div class="pxl-info--inner" data-parallax='{"y":<?php echo esc_attr($settings['parallax_scroll_value_y']); ?>}'>
		<?php if(!empty($settings['image']['id'])) :
			$img = pxl_get_image_by_size( array(
				'attach_id'  => $settings['image']['id'],
				'thumb_size' => $image_size,
			));
			$thumbnail = $img['thumbnail']; ?>
			<div class="pxl-item--image">
				<a <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?>>
					<?php echo pxl_print_html($thumbnail); ?>
				</a>
				<?php if (!empty($settings['button_text'])) { ?>
					<a class="btn btn-text-nanuk" <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?>>
						<span class="pxl--btn-text">
							<?php $btn_text = $settings['button_text'];
							$chars = preg_split('//u', $btn_text, -1, PREG_SPLIT_NO_EMPTY);
							foreach ($chars as $value) {
								if($value == ' ') {
									echo '<span class="spacer">&nbsp;</span>';
								} else {
									echo '<span>'.$value.'</span>';
								}
							} ?>
						</span>
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 753.2 476.2" style="enable-background:new 0 0 753.2 476.2;" xml:space="preserve">
							<polygon points="622.6,107.5 601.4,128.7 695.8,223.1 277,223.1 277,253.1 695.8,253.1 601.4,347.5 622.6,368.7 753.2,238.1 "/>
							<rect y="223.1" width="283.9" height="30"/>
						</svg>
					</a>
				<?php } ?>
			</div>
		<?php endif; ?>
		<?php if (!empty($settings['title'])) { ?>
			<h5 class="pxl-title">	<a <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?>>
				<?php echo pxl_print_html($settings['title']); ?></a></h5>
			<?php } ?>
			<?php if (!empty($settings['sub_title'])) { ?>
				<div class="pxl-sub-title"><?php echo pxl_print_html($settings['sub_title']); ?></div>
			<?php } ?>
		</div>
	</div>