<?php 
$is_new = \Elementor\Icons_Manager::is_migration_allowed();

if ( ! empty( $settings['item_link']['url'] ) ) {
	$widget->add_render_attribute( 'button', 'href', $settings['item_link']['url'] );

	if ( $settings['item_link']['is_external'] ) {
		$widget->add_render_attribute( 'button', 'target', '_blank' );
	}

	if ( $settings['item_link']['nofollow'] ) {
		$widget->add_render_attribute( 'button', 'rel', 'nofollow' );
	}
}
if($settings['popup_template'] > 0 ){
	if ( !has_action( 'pxl_anchor_target_page_popup_'.$settings['popup_template']) ){
		add_action( 'pxl_anchor_target_page_popup_'.$settings['popup_template'], 'dreamslab_hook_anchor_page_popup' );
	} 
}
?>
<div class="pxl-info-box3 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
	<?php if(!empty($settings['image']['id'])) :
		$img = pxl_get_image_by_size( array(
			'attach_id'  => $settings['image']['id'],
			'thumb_size' => '767x485',
		));
		$thumbnail = $img['thumbnail']; ?>
		<div class="pxl-item--image">
			<?php if ($settings['popup_template'] > 0) { ?>
				<a class="btn-overlay pxl-middle-full" href="javascript:void(0)" data-target=".pxl-page-popup-template-<?php echo esc_attr($settings['popup_template']); ?>">   
				</a>
			<?php } else { ?>
				<a <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?>></a>
			<?php } ?>
			<?php echo pxl_print_html($thumbnail); ?>
			<?php if ( $is_new ):
				echo '<div class="pxl-post--icon">';
				\Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true' ] );
				echo '</div>';
			elseif(!empty($settings['pxl_icon'])): ?>
				<div class="pxl-post--icon">
					<i class="<?php echo esc_attr( $settings['pxl_icon'] ); ?>" aria-hidden="true"></i>
				</div>
			<?php endif; ?>
		</div>
	<?php endif; ?>
	<div class="pxl-holder-content">
		<?php if (!empty($settings['title'])) { ?>
			<h5 class="pxl-title"><a class="btn-overlay" href="javascript:void(0)" data-target=".pxl-page-popup-template-<?php echo esc_attr($settings['popup_template']); ?>"><?php echo pxl_print_html($settings['title']); ?></a></h5>
			<div class="pxl-desc"><?php echo pxl_print_html($settings['desc']); ?></div>
			<?php if (!empty($settings['button_text'])) { ?>
				<div class="pxl-post--readmore">
					<a class="btn-readmore btn-text-nanuk btn-overlay <?php if ($settings['popup_template'] > 0) {echo 'btn-atc-popup';} ?>" <?php if ($settings['popup_template'] > 0) { ?> data-target=".pxl-page-popup-template-<?php echo esc_attr($settings['popup_template']); ?>"<?php } else { ?><?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?><?php } ?>>
					<span class="pxl--btn-text">
						<?php $btn_text = $settings['button_text'];
						$chars = preg_split('//u', $btn_text, -1, PREG_SPLIT_NO_EMPTY);
						foreach ($chars as $value) {
							if($value == ' ') {
								echo '<span class="spacer">&nbsp;</span>';
							} else {
								echo '<span>'.$value.'</span>';
							}
						} ?>
					</span>
					<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 753.2 476.2" style="enable-background:new 0 0 753.2 476.2;" xml:space="preserve">
						<polygon points="622.6,107.5 601.4,128.7 695.8,223.1 277,223.1 277,253.1 695.8,253.1 601.4,347.5 622.6,368.7 753.2,238.1 "></polygon>
						<rect y="223.1" width="283.9" height="30"></rect>
					</svg>
				</a>
			</div>
		<?php } ?>
	<?php } ?>
</div>
</div>