<?php
$html_id = pxl_get_element_id($settings);
if(isset($settings['items']) && !empty($settings['items']) && count($settings['items'])): ?>
    <div id="pxl-link-scroll <?php echo esc_attr($html_id) ?>" class="pxl-link-scroll1 <?php echo esc_attr($settings['pxl_animate'].' '.$settings['position']); ?> <?php if($settings['hidden_on_mobile'] == 'yes') { echo 'hidden_lg'; } ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php
        foreach ($settings['items'] as $key => $link):
            $link_key = $widget->get_repeater_setting_key( 'link', 'value', $key );
            if ( ! empty( $link['link']['url'] ) ) {
                $widget->add_render_attribute( $link_key, 'href', $link['link']['url'] );

                if ( $link['link']['is_external'] ) {
                    $widget->add_render_attribute( $link_key, 'target', '_blank' );
                }

                if ( $link['link']['nofollow'] ) {
                    $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                }
            }
            $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
            <div class="pxl--item">
                <a class="pxl-item--onepage pxl-flex-center <?php if($key == 0) : ?>pxl-onepage-active<?php endif; ?>" <?php echo implode( ' ', [ $link_attributes ] ); ?> data-onepage-offset="<?php if(!empty($link['offset'])) { echo esc_attr($link['offset']); } else { echo '0'; } ?>">
                    <?php if(!empty($link['pxl_icon'])){
                        \Elementor\Icons_Manager::render_icon( $link['pxl_icon'], [ 'aria-hidden' => 'true' ], 'i' );
                    } ?>
                    <span><?php echo pxl_print_html($link['text']); ?></span>
                </a>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
