<?php
if(!empty($settings['menu'])) { 
    $p_menu = dreamslab()->get_page_opt('p_menu'); 
    $show_image = $widget->get_setting('show_image', false);
    if ( ! empty( $settings['link']['url'] ) ) {
        $widget->add_render_attribute( 'button', 'href', $settings['link']['url'] );

        if ( $settings['link']['is_external'] ) {
            $widget->add_render_attribute( 'button', 'target', '_blank' );
        }

        if ( $settings['link']['nofollow'] ) {
            $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
        }
    }
    if(!empty($p_menu)) {
        $settings['menu'] = $p_menu;
    } ?>
    <div class="pxl-menu-hidden-sidebar <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <div class="pxl-menu-button-wrap">
            <div class="pxl-menu-button <?php echo esc_attr($settings['icon_type']); ?>">
                <?php if(!empty($settings['text'])) { ?>
                    <div class="pxl-anchor--title"><?php echo esc_html($settings['text']); ?></div>
                <?php } elseif($settings['icon_type'] == 'df' || $settings['icon_type'] == 'style-3') { ?>
                    <div class="pxl-anchor-divider">
                        <div class="pxl-icon-line pxl-icon-line1"></div>
                        <div class="pxl-icon-line pxl-icon-line2"></div>
                        <div class="pxl-icon-line pxl-icon-line3"></div>
                        <div class="pxl-icon-line pxl-icon-line4"></div>
                    </div>
                <?php } ?>
            </div>
        </div>
        <div class="pxl-menu-wrap">
            <div class="pxl-background">
                <div class="pxl-bg-side-container pxl-bg-before-container">
                    <span style="<?php if ($show_image) { ?><?php if (!empty($settings['image']['id'])) { ?>background-image: url(<?php echo esc_url($settings['image']['url']); ?>);<?php } ?><?php } ?>"></span>
                </div>
                <div class="pxl-bg-container">
                    <div class="pxl-bg-row">
                        <div><span style="<?php if ($show_image) { ?><?php if (!empty($settings['image']['id'])) { ?>background-image: url(<?php echo esc_url($settings['image']['url']); ?>);<?php } ?><?php } ?>"></span></div>
                        <div><span style="<?php if ($show_image) { ?><?php if (!empty($settings['image']['id'])) { ?>background-image: url(<?php echo esc_url($settings['image']['url']); ?>);<?php } ?><?php } ?>"></span></div>
                        <div><span style="<?php if ($show_image) { ?><?php if (!empty($settings['image']['id'])) { ?>background-image: url(<?php echo esc_url($settings['image']['url']); ?>);<?php } ?><?php } ?>"></span></div>
                        <div><span style="<?php if ($show_image) { ?><?php if (!empty($settings['image']['id'])) { ?>background-image: url(<?php echo esc_url($settings['image']['url']); ?>);<?php } ?><?php } ?>"></span></div>
                    </div>
                </div>
                <div class="pxl-bg-side-container pxl-bg-after-container">
                    <span style="<?php if ($show_image) { ?><?php if (!empty($settings['image']['id'])) { ?>background-image: url(<?php echo esc_url($settings['image']['url']); ?>);<?php } ?><?php } ?>"></span>
                </div>
            </div>
            <div class="pxl-menu-popup-wrap">
                <div class="pxl-menu-popup-container">
                    <div class="pxl-menu-popup--top">
                        <div class="pxl-menu-popup-close">
                            <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                            viewBox="0 0 496.096 496.096" width="26" height="26" xml:space="preserve">
                            <g>
                                <g>
                                    <path d="M259.41,247.998L493.754,13.654c3.123-3.124,3.123-8.188,0-11.312c-3.124-3.123-8.188-3.123-11.312,0L248.098,236.686
                                    L13.754,2.342C10.576-0.727,5.512-0.639,2.442,2.539c-2.994,3.1-2.994,8.015,0,11.115l234.344,234.344L2.442,482.342
                                    c-3.178,3.07-3.266,8.134-0.196,11.312s8.134,3.266,11.312,0.196c0.067-0.064,0.132-0.13,0.196-0.196L248.098,259.31
                                    l234.344,234.344c3.178,3.07,8.242,2.982,11.312-0.196c2.995-3.1,2.995-8.016,0-11.116L259.41,247.998z"/>
                                </g>
                            </g>
                        </svg>
                    </div>
                    <div class="pxl-item-content">
                        <div class="pxl-item--top-content">
                            <span class="pxl--btn-s-title"><?php echo pxl_print_html($settings['sub_title_t']); ?></span>
                            <span class="pxl--btn-title"><?php echo pxl_print_html($settings['title_t']); ?></span>
                        </div>
                        <a <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?> class="btn btn-border">
                            <span class="pxl--btn-text"><?php echo pxl_print_html($settings['btn_text']); ?></span>
                            <svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" enable-background="new 0 0 20 20" height="512" viewBox="0 0 20 20" width="512"><path d="m12 2-1.4 1.4 5.6 5.6h-16.2v2h16.2l-5.6 5.6 1.4 1.4 8-8z" fill="rgb(0,0,0)"/></svg>
                        </a>
                    </div>  
                </div>
                <div class="pxl-menu-popup-inner">
                    <div class="pxl-menu-popup">
                        <?php
                        require_once get_template_directory() . '/includes/class-custom-walker.php';
                        wp_nav_menu(array(
                            'theme_location' => 'primary',
                            'menu_class' => 'pxl-menu-hidden clearfix',
                            'walker'     => new Custom_Menu_Walker(),
                            'link_before'     => '<span class="pxl-menu-item-text">',
                            'link_after'      => '</span>',
                            'menu'        => wp_get_nav_menu_object($settings['menu'])
                        ));
                        ?>
                    </div>
                    <div class="pxl-menu-popup-content">
                        <?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): ?>
                        <div class="pxl-list-info">
                            <?php foreach ($settings['lists'] as $key => $value): 
                                $link_key = $widget->get_repeater_setting_key( 'link_list', 'value', $key );
                                if ( ! empty( $value['link_list']['url'] ) ) {
                                    $widget->add_render_attribute( $link_key, 'href', $value['link_list']['url'] );

                                    if ( $value['link_list']['is_external'] ) {
                                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                                    }

                                    if ( $value['link_list']['nofollow'] ) {
                                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                                    }
                                }
                                $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
                                <a <?php echo implode( ' ', [ $link_attributes ] ); ?> class="pxl--item">
                                    <?php if(!empty($value['sub_title'])) : ?><h5><?php echo pxl_print_html($value['sub_title'])?></h5><?php endif; ?>
                                    <p>
                                        <?php if(!empty($value['content'])) : ?><?php echo pxl_print_html($value['content'])?><?php endif; ?>
                                    </p>
                                </a>
                            <?php endforeach; ?>
                            <?php if(!empty($settings['social'])): ?>
                                <div class="pxl-item--social">
                                    <?php
                                    $team_social = json_decode($settings['social'], true);
                                    foreach ($team_social as $value):
                                        if (!empty($value['url'])): ?>
                                            <a href="<?php echo esc_url($value['url']); ?>">
                                            <?php endif; ?>
                                            <i class="<?php echo esc_attr($value['icon']); ?>"></i>
                                            <?php if (!empty($value['url'])): ?>
                                            </a>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty($settings['image_r']['id'])) :
                        $img = pxl_get_image_by_size( array(
                            'attach_id'  => $settings['image_r']['id'],
                            'thumb_size' => 'full',
                        ));
                        $thumbnail = $img['thumbnail']; ?>
                        <div class="pxl-item--image wrap-img-distortion">
                            <?php echo wp_kses_post($thumbnail); ?>
                            <div class="wrap-distort-canvas"></div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<?php } ?>