    <?php
    extract($settings);
    $html_id = pxl_get_element_id($settings);
    $tax = ['portfolio-category'];
    $select_post_by = $widget->get_setting('select_post_by', '');
    $source = $post_ids = [];
    if($select_post_by === 'post_selected'){
        $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
    }else{
        $source  = $widget->get_setting('source_'.$settings['post_type'], '');
    }
    $orderby = $widget->get_setting('orderby', 'date');
    $order = $widget->get_setting('order', 'desc');
    $limit = $widget->get_setting('limit', 6);
    $settings['layout']    = $settings['layout_'.$settings['post_type']];
    extract(pxl_get_posts_of_grid('portfolio', [
        'source' => $source,
        'orderby' => $orderby,
        'order' => $order,
        'limit' => $limit,
        'post_ids' => $post_ids,
        'tax'=> $tax,
    ]));
    ?>

    <?php if (is_array($posts)): ?>
        <div class="pxl-portfolio-carousel pxl-portfolio-carousel5 pxl-portfolio-style1 ">
            <div class="snap-slider-holder" >
                <div class="snap-slider-captions">
                    <div class="snap-slider-pagination">
                      <div class="current-wrapper">
                        <div class="number-slide current"></div>
                    </div>
                    <span class="divider">/</span>
                    <div class="total">06</div>
                </div>
                <div class="snap-slider-captions-wrapper content-full-width">
                    <?php
                    foreach ($posts as $post):
                        ?>
                        <div class="snap-slide-caption">
                          <?php if($show_category == 'true'): ?>
                            <div class="pxl-post--category">
                                <?php the_terms( $post->ID, 'portfolio-category', '', '' ); ?>
                            </div>
                        <?php endif; ?>
                        <h4 class="pxl-post--title">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a>
                        </h4>
                        <?php if($show_excerpt == 'true'): ?>
                            <div class="pxl-post--content">
                                <?php if($show_excerpt == 'true'): ?>
                                    <p>
                                        <?php
                                        echo wp_trim_words( $post->post_excerpt, $num_words, $more = null );
                                        ?>
                                    </p>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <div class="btn-readmore">
                            <a class="btn btn-border" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">   
                                <span class="pxl--btn-text">
                                    <?php if(!empty($button_text)) {
                                        echo pxl_print_html($button_text);
                                    } else {
                                        echo esc_html__('Read More', 'dreamslab');
                                    } ?>
                                </span>
                                <svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" enable-background="new 0 0 20 20" height="512" viewBox="0 0 20 20" width="512"><path d="m12 2-1.4 1.4 5.6 5.6h-16.2v2h16.2l-5.6 5.6 1.4 1.4 8-8z" fill="rgb(0,0,0)"/></svg>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div> 
        </div>
        <div class="snap-slider-thumbs">
            <div class="snap-slider-thumbs-wrapper">
                <?php
                foreach ($posts as $post):
                    $image_size = !empty($img_size) ? $img_size : 'full';
                    $img_id       = get_post_thumbnail_id( $post->ID );
                    $img          = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $image_size,
                        'class' => 'item-image grid__item-img'
                    ) );
                    $thumbnail    = $img['thumbnail']; 
                    $thumbnail_url    = $img['url']; 
                    $filter_class = '';
                    if ($select_post_by === 'term_selected' )
                        $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));

                    $multi_text_country = get_post_meta($post->ID, 'multi_text_country', true);  
                    $multi_text_country_link = get_post_meta($post->ID, 'multi_text_country_link', true);  
                    $icon_multi_text = get_post_meta($post->ID, 'icon_multi_text', true);
                    ?>
                    <div class="thumb-slide">
                        <div class="thumb-slide-img ">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </div>
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">   
                        </a>  
                    </div>
                <?php endforeach; ?>
            </div> 
        </div>
        <div class="snap-slider-images">
            <div class="snap-slider-images-wrapper">
                <?php
                foreach ($posts as $post):
                    $image_size = !empty($img_size) ? $img_size : '942x796';
                    $img_id       = get_post_thumbnail_id( $post->ID );
                    $img          = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $image_size,
                        'class' => 'item-image grid__item-img'
                    ) );
                    $thumbnail    = $img['thumbnail']; 
                    $thumbnail_url    = $img['url']; 
                    $filter_class = '';
                    if ($select_post_by === 'term_selected' )
                        $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));

                    $multi_text_country = get_post_meta($post->ID, 'multi_text_country', true);  
                    $multi_text_country_link = get_post_meta($post->ID, 'multi_text_country_link', true);  
                    $icon_multi_text = get_post_meta($post->ID, 'icon_multi_text', true);
                    ?>
                    <div class="snap-slide change-header-color">
                        <div class="img-mask ">
                            <a class="section-image" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">   
                                <?php echo wp_kses_post($thumbnail); ?>
                            </a>
                            <?php echo wp_kses_post($thumbnail); ?>    
                        </div>
                    </div>
                <?php endforeach; ?>
            </div> 
            <div class="slider-pagination-fraction"></div>
        </div>
    </div>
</div>
<?php endif; ?>