<?php
use elementor\embed;
$html_id = pxl_get_element_id($settings);
$tax = ['category'];
$select_post_by = $widget->get_setting('select_post_by', 'term_selected');
$source = $post_ids = $post_ids_unselected = [];

if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
    $post_ids_unselected  = $widget->get_setting('source_'.$settings['post_type'].'_post_ids_unselected', '');
}

if($settings['col_xl'] == '5') {
    $col_xl = 'pxl5';
} else {
    $col_xl = 12 / intval($widget->get_setting('col_xl', 4));
}
$col_lg = 12 / intval($widget->get_setting('col_lg', 4));
$col_md = 12 / intval($widget->get_setting('col_md', 3));
$col_sm = 12 / intval($widget->get_setting('col_sm', 2));
$col_xs = 12 / intval($widget->get_setting('col_xs', 1));
$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";

$grid_class = 'pxl-grid-inner pxl-list-inner d-flex-wrap relative row';

$orderby   = $widget->get_setting('orderby', 'date');
$order     = $widget->get_setting('order', 'desc');
$limit     = $widget->get_setting('limit', 6);

$query_result = pxl_get_posts_of_grid('portfolio', ['source' => $source, 'orderby' => $orderby, 'order' => $order, 'limit' => $limit, 'post_ids' => $post_ids, 'post_not_in' => $post_ids_unselected ], $tax);

extract($query_result);

$post_type            = $widget->get_setting('post_type','portfolio');
$layout               = $widget->get_setting('layout_'.$post_type, 'portfolio-list-2');
$layout_mode          = $widget->get_setting('layout_mode', 'fitrows');
$pagination_type      = $widget->get_setting('pagination_type', 'pagination');
$pxl_animate = $widget->get_setting('pxl_animate');

$load_more = array(
    'tax'                 => $tax,
    'post_type'           => $post_type,   
    'layout'              => $layout,
    'select_post_by'      => $select_post_by,
    'layout_mode'         => $layout_mode,
    'startpage'           => $paged,
    'maxpages'            => $max,
    'total'               => $total,
    'perpage'             => $limit,
    'nextlink'            => $next_link,
    'source'              => $source,
    'post_ids'            => $post_ids,
    'orderby'             => $orderby,
    'order'               => $order,
    'limit'               => $limit,
    'col_xl'          => $col_xl,
    'col_lg'          => $col_lg,
    'col_md'          => $col_md,
    'col_sm'          => $col_sm,
    'col_xs'          => $col_xs,

    'item_animation'          => $widget->get_setting('item_animation', ''),  
    'item_animation_duration' => $widget->get_setting('item_animation_duration', 'normal'),  
    'item_animation_delay'    => $widget->get_setting('item_animation_delay', '150'),  

    'img_size'            => $widget->get_setting('img_size','1216x535'),
    'show_number'       => $widget->get_setting('post_number'),
    'show_readmore'       => $widget->get_setting('post_readmore'),
    'show_category'       => $widget->get_setting('post_category'),
    'pxl_animate'     => $pxl_animate,

    'pagination_type'     => $pagination_type,
    'show_toolbar'        => $widget->get_setting('show_toolbar','hide'),
    'wg_type'             => 'portfolio-list',
);

$wrap_attrs = [
    'id'               => $html_id,
    'class'            => trim('pxl-grid pxl-portfolio-list ' . ' layout-' . $layout),
];

if ($pagination_type != 'false'){
    $wrap_attrs['data-loadmore'] = json_encode($load_more);
}

$widget->add_render_attribute( 'wrapper', $wrap_attrs );

if( count($posts) <= 0){
    echo '<div class="pxl-no-portfolio-list">'.esc_html__( 'no post found', 'dreamslab' ). '</div>';
    return;
}
?>
<div <?php pxl_print_html($widget->get_render_attribute_string( 'wrapper' )) ?>>
    <div class="card-counter-left">
      <div class="current-card-wrapper">
        <div class="current-card"></div>
    </div>
</div>
<div class="<?php echo esc_attr($grid_class); ?>" data-gutter="15"> 
  <?php dreamslab_get_post_list($posts, $load_more); ?>
</div>
<!-- Counter Right -->
<div class="card-counter-right">
  <div class="total-card">/ 00</div>
</div>
<?php if ($pagination_type == 'pagination') { ?>
    <div class="pxl-grid-pagination pagin-post">
        <?php dreamslab()->page->get_pagination($query, true); ?>
    </div>
<?php } ?>
<?php if (!empty($next_link) && $pagination_type == 'loadmore'): 
    $icon_pos = ( !empty($settings['loadmore_icon']) && !empty($settings['icon_align'])) ? $settings['icon_align'] : ''; 
    ?>
    <div class="pxl-load-more " data-loading-text="<?php echo esc_attr__('loading', 'dreamslab') ?>" data-loadmore-text="<?php echo esc_html($settings['loadmore_text']); ?>">
        <span class="btn btn-grid-loadmore">
            <span class="btn-text"><?php echo esc_html($settings['loadmore_text']); ?></span>
        </span>
    </div>
<?php endif; ?>
</div>