<?php 
$key = 0;
$link_key = $widget->get_repeater_setting_key( 'link5', 'value', $key );
if ( ! empty( $settings['link5']['url'] ) ) {
    $widget->add_render_attribute( $link_key, 'href', $settings['link5']['url'] );

    if ( $settings['link5']['is_external'] ) {
        $widget->add_render_attribute( $link_key, 'target', '_blank' );
    }

    if ( $settings['link5']['nofollow'] ) {
        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
    }
}
$link_attributes = $widget->get_render_attribute_string( $link_key );
?>
<div class="pxl-process pxl-process5 <?php echo esc_attr($settings['pxl_animate'] .' '.$settings['style']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <?php if(isset($settings['lists_content5']) && !empty($settings['lists_content5']) && count($settings['lists_content5'])): ?>
        <ul class="pxl-list-content">
            <?php foreach ($settings['lists_content5'] as $key => $value): ?>
                <li class="pxl--item">
                    <div class="pxl--item-wrap">
                        <div class="pxl-item--left">
                            <div class="pxl--item-number">
                                <?php echo esc_html__('step', 'dreamslab'); ?> <?php echo esc_attr($key + 1); ?>
                            </div>
                            <?php if(!empty($value['pxl_icon5']['value'])) { 
                                echo '<div class="pxl-icon">';
                                \Elementor\Icons_Manager::render_icon( $value['pxl_icon5'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' );
                                echo '</div>';
                            } ?>
                        </div>
                        <div class="pxl--item-container">
                            <h4 class="pxl-item--title el-empty"><?php echo pxl_print_html($value['title_c5']); ?></h4>
                            <div class="pxl-item--description el-empty"><?php echo pxl_print_html($value['desc_c5']); ?></div>
                            <?php if (!empty($value['image']['id']) ) : ?>
                                <?php $img  = pxl_get_image_by_size( array(
                                    'attach_id'  => $value['image']['id'],
                                    'thumb_size' => 'full',
                                ) );
                                $thumbnail_url    = $img['url']; ?>
                                <div class="pxl-item--image" style="background-image: url(<?php echo esc_url($thumbnail_url); ?>);">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </li>
            <?php endforeach; ?>
            <li class="pxl--item item--last">
                <div class="pxl--item-container">
                    <h1 class="title-last el-empty"><?php echo esc_html($settings['title_c5_last']); ?></h1>
                    <div class="subtitle-last el-empty"><?php echo esc_html($settings['sub_title_c5_last']); ?></div>
                    <a <?php echo implode( ' ', [ $link_attributes ] ); ?> class="btn btn-border">
                        <span class="pxl--btn-text"><?php echo esc_html($settings['btn_c5_last']); ?></span>
                        <svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" height="512" viewBox="0 0 20 20" width="512"><path d="m12 2-1.4 1.4 5.6 5.6h-16.2v2h16.2l-5.6 5.6 1.4 1.4 8-8z" fill="rgb(0,0,0)"></path></svg>
                    </a>
                </div>
                <?php if(isset($settings['lists_content_last5']) && !empty($settings['lists_content_last5']) && count($settings['lists_content_last5'])): ?>
                <div class="pxl-images">
                <?php foreach ($settings['lists_content_last5'] as $key => $value): ?>
                    <?php if (!empty($value['image_last']['id']) ) : ?>
                        <?php
                        $img_l  = pxl_get_image_by_size(array(
                            'attach_id'  => $value['image_last']['id'],
                            'thumb_size' => 'full',
                        ));
                        $thumbnail_l = $img_l['thumbnail'];
                        ?>
                        <div class="pxl-last--image <?php echo ( intval( $key ) === 0 ) ? esc_attr( 'active' ) : ''; ?>">
                            <?php echo pxl_print_html($thumbnail_l); ?>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
               </div>
           <?php endif; ?>
       </li>
       </ul> <?php endif; ?>
   </div>
</div>