<?php 
$key = 0;
$link_key = $widget->get_repeater_setting_key( 'link6', 'value', $key );
if ( ! empty( $settings['link6']['url'] ) ) {
    $widget->add_render_attribute( $link_key, 'href', $settings['link6']['url'] );

    if ( $settings['link6']['is_external'] ) {
        $widget->add_render_attribute( $link_key, 'target', '_blank' );
    }

    if ( $settings['link6']['nofollow'] ) {
        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
    }
}
$link_attributes = $widget->get_render_attribute_string( $link_key );
?>
<div class="pxl-process pxl-process6 <?php echo esc_attr($settings['pxl_animate'] .' '.$settings['style']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <?php if(isset($settings['lists_content6']) && !empty($settings['lists_content6']) && count($settings['lists_content6'])): ?>
        <ul class="pxl-list-content">
            <?php foreach ($settings['lists_content6'] as $key => $value): ?>
                <li class="pxl--item ">
                    <div class="pxl--item-wrap">
                        <div class="pxl-item--left">
                            <div class="pxl--item-number">
                                <?php echo esc_html__('step', 'dreamslab'); ?> <?php echo esc_attr($key + 1); ?>
                            </div>
                            <?php if(!empty($value['pxl_icon6']['value'])) { 
                                echo '<div class="pxl-icon">';
                                \Elementor\Icons_Manager::render_icon( $value['pxl_icon6'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' );
                                echo '</div>';
                            } ?>
                        </div>
                        <?php if(!empty($value['pxl_icon6']['value'])) { 
                            echo '<div class="pxl-icon--white">';
                            \Elementor\Icons_Manager::render_icon( $value['pxl_icon6'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' );
                            echo '</div>';
                        } ?>
                        <div class="pxl--item-container">
                            <h4 class="pxl-item--title el-empty"><p><?php echo pxl_print_html($value['title_c6']); ?></p></h4>
                            <div class="pxl-item--description el-empty"><p><?php echo pxl_print_html($value['desc_c6']); ?></p></div>
                            <?php if (!empty($value['image']['id']) ) : ?>
                                <?php $img  = pxl_get_image_by_size( array(
                                    'attach_id'  => $value['image']['id'],
                                    'thumb_size' => 'full',
                                ) );
                                $thumbnail_url    = $img['url']; ?>
                                <div class="pxl-item--image" style="background-image: url(<?php echo esc_url($thumbnail_url); ?>);">
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="whipe overlay_bg"></div>
                    </div>
                </li>
            <?php endforeach; ?>
            </ul> <?php endif; ?>
        </div>
    </div>
    