<?php
$html_id = pxl_get_element_id($settings);
extract($settings);

$ids = esc_attr('grad-'.$html_id);
$ids1 = esc_attr('grad1-'.$html_id);

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
$allow_touchmove = $widget->get_setting('allow_touchmove',false);
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');
$arrows = $widget->get_setting('arrows',false);
$pagination = $widget->get_setting('pagination',false);
$pagination_type = $widget->get_setting('pagination_type','bullets');
$effect = $widget->get_setting('effect','gl');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite',false);
$mousewheel = $widget->get_setting('mousewheel',true);
$speed = $widget->get_setting('speed', '500');
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1',
    'slide_mode'                    => $effect,
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl,
    'slides_to_show_lg'             => (int)$col_lg,
    'slides_to_show_md'             => (int)$col_md,
    'slides_to_show_sm'             => (int)$col_sm,
    'slides_to_show_xs'             => (int)$col_xs,
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'mousewheel'                          => (bool)$mousewheel,
    'speed'                         => (int)$speed,
    'allow_touch_move'              => true
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['slider2']) && !empty($settings['slider2']) && count($settings['slider2'])): ?>
    <div class="pxl-swiper-slider pxl-slider-carousel pxl-slider-carousel2 pxl-drag-area pxl-parent-transition pxl-parent-cursor pxl-swiper-arrow-show 
<?php if ($arrows === 'true') echo 'pxl-show-arrow'; ?>"
data-view-auto="<?php echo esc_attr($col_xl); ?>">
<div class="pxl-carousel-inner">
    <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
        <div class="pxl-swiper-wrapper">
            <?php foreach ($settings['slider2'] as $key => $value):
                $image_light = isset($value['image1']) ? $value['image1'] : '';
                $title = isset($value['title1']) ? $value['title1'] : '';
                $subtitle = isset($value['sub_title1']) ? $value['sub_title1'] : '';
                $desc = isset($value['desc1']) ? $value['desc1'] : '';
                $btn_text = isset($value['btn_text1']) ? $value['btn_text1'] : '';
                $link = isset($value['btn_link1']) ? $value['btn_link1'] : '';
                $link_key = $widget->get_repeater_setting_key( 'title1', 'value', $key );
                if ( ! empty( $link['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $link['url'] );

                    if ( $link['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $link['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key );
                ?>
                <div class="pxl-swiper-slide">
                    <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>"  data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                      <?php if(!empty($image_light['id'])) { 
                        $img = pxl_get_image_by_size( array(
                            'attach_id'  => $image_light['id'],
                            'thumb_size' => 'full',
                            'class' => 'no-lazyload swiper-gl-image',
                        ));
                        $thumbnail = $img['thumbnail'];
                        ?>
                        <div class="pxl-item--image ">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </div>
                    <?php } ?>
                    <div class="content--wrapper">
                        <?php if(!empty($subtitle)) : ?>
                            <div class="pxl-item--subtitle el-empty wow fadeInUp" data-duration="200ms" data-wow-delay="300ms"><?php echo pxl_print_html($subtitle); ?></div>
                        <?php endif; ?>
                        <?php if(!empty($title)) : ?>
                            <h4 class="pxl-item--title el-empty wow fadeInUp" data-duration="200ms" data-wow-delay="500ms"><?php echo pxl_print_html($title); ?></h4>
                        <?php endif; ?>
                        <?php if(!empty($desc)) : ?>
                            <p class="pxl-item--desc el-empty wow fadeInRight"  data-duration="200ms" data-wow-delay="700ms"><?php echo pxl_print_html($desc); ?></p>
                        <?php endif; ?>
                        <div class="pxl-item--link  wow zoomIn"  data-duration="200ms" data-wow-delay="900ms">
                            <?php if ( !empty( $link['url'] ) ) { ?>
                                <a class="item--button btn  btn-glossy" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                    <span class="button-arrow-hover"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" enable-background="new 0 0 1500 1500" height="512" viewBox="0 0 1500 1500" width="512"><g><path d="m1251.1 148.3h-728.4v-142.3h971.3v970l-142.3-.1v-727l-1245.1 1245.1-100.6-100.6z"/></g></svg><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" enable-background="new 0 0 1500 1500" height="512" viewBox="0 0 1500 1500" width="512"><g><path d="m1251.1 148.3h-728.4v-142.3h971.3v970l-142.3-.1v-727l-1245.1 1245.1-100.6-100.6z"/></g></svg></span>
                                </a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>
<?php if($pagination !== false || $arrows !== false): ?>
    <div class="pxl-swwiper-slider-bottom">
        <?php if($pagination !== false): ?>
            <div class="pxl-swiper-dots style-1"></div>
        <?php endif; ?>
        <?php if($arrows !== false): ?>
            <div class="pxl-swiper-arrow-wrap style-3 ">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev" style="transform: scaleX(-1);"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" enable-background="new 0 0 20 20" height="512" viewBox="0 0 20 20" width="512"><path d="m12 2-1.4 1.4 5.6 5.6h-16.2v2h16.2l-5.6 5.6 1.4 1.4 8-8z" fill="#fff"/></svg></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" enable-background="new 0 0 20 20" height="512" viewBox="0 0 20 20" width="512"><path d="m12 2-1.4 1.4 5.6 5.6h-16.2v2h16.2l-5.6 5.6 1.4 1.4 8-8z" fill="#fff"/></svg></div>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
</div>
</div>
<?php endif; ?>