<?php $html_id = pxl_get_element_id($settings); 
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
if(isset($settings['tabs2']) && !empty($settings['tabs2']) && count($settings['tabs2'])): 
    $tab_bd_ids = [];
?>
<div class="pxl-tabs pxl-tabs2 <?php echo esc_attr($settings['tab_effect'].' '.$settings['style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-tabs--inner">
        <div class="wrap-title">
            <div class="pxl-tabs--title">
                <?php foreach ($settings['tabs2'] as $key => $value) : ?>
                    <span class="pxl-item--title <?php if($settings['tab_active'] == $key + 1) { echo 'active'; } ?>" data-target="#<?php echo esc_attr($html_id.'-'.$value['_id']); ?>">
                        <?php if ( $is_new ):
                            \Elementor\Icons_Manager::render_icon( $value['pxl_icon2'], [ 'aria-hidden' => 'true' ] );
                        elseif(!empty($value['pxl_icon2'])): ?>
                            <i class="<?php echo esc_attr( $value['pxl_icon2'] ); ?>" aria-hidden="true"></i>
                        <?php endif; ?>
                        <span class="divider"></span>
                        <?php echo pxl_print_html($value['title2']); ?>
                    </span>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="pxl-tabs--content">
            <?php foreach ($settings['tabs2'] as $key => $content) : 
                $link = isset($content['link']) ? $content['link'] : '';
                $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                if ( ! empty( $link['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $link['url'] );

                    if ( $link['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $link['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key );
                ?>
                <div id="<?php echo esc_attr($html_id.'-'.$content['_id']); ?>" class="pxl-item--content <?php if($settings['tab_active'] == $key + 1) { echo 'active'; } ?> " <?php if($settings['tab_active'] == $key + 1) { ?>style="display: block;"<?php } ?>>
                  <?php if ( $is_new ):
                    \Elementor\Icons_Manager::render_icon( $content['pxl_icon2'], [ 'aria-hidden' => 'true' ] );
                elseif(!empty($content['pxl_icon2'])): ?>
                    <i class="<?php echo esc_attr( $content['pxl_icon2'] ); ?>" aria-hidden="true"></i>
                <?php endif; ?>
                <?php if (!empty($content['title2'])) { ?>
                    <h4 class="tab-title">
                        <?php echo pxl_print_html($content['title2']); ?>
                    </h4>
                <?php } ?>
                <?php if (!empty($content['title2'])) { ?>
                    <div class="tab-desc">
                        <?php echo pxl_print_html($content['desc2']); ?>
                    </div>
                <?php } ?>
                <?php if (!empty($content['btn_text'])) { ?>
                 <a class="btn btn-border" <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php echo pxl_print_html($content['btn_text']); ?><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" enable-background="new 0 0 20 20" height="512" viewBox="0 0 20 20" width="512"><path d="m12 2-1.4 1.4 5.6 5.6h-16.2v2h16.2l-5.6 5.6 1.4 1.4 8-8z" fill="rgb(0,0,0)"/></svg></a>
             <?php } ?>
         </div>
     <?php endforeach; ?>
 </div>

</div>
</div>
<?php endif; ?>