<?php if ( ! empty( $settings['item_link']['url'] ) ) {
    $widget->add_render_attribute( 'item_link2', 'href', $settings['item_link']['url'] );

    if ( $settings['item_link']['is_external'] ) {
        $widget->add_render_attribute( 'item_link2', 'target', '_blank' );
    }

    if ( $settings['item_link']['nofollow'] ) {
        $widget->add_render_attribute( 'item_link2', 'rel', 'nofollow' );
    } ?>
<?php } ?>
<div class="pxl-team-box pxl-team-box1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-parallax='{"y":<?php echo esc_attr($settings['parallax_scroll_value_y']); ?>}'>
    <div class="pxl-item--inner">
        <?php if(!empty($settings['image']['id'])) : 
            $img  = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => 'full',
            ) );
            $thumbnail    = $img['thumbnail'];
            ?>
            <div class="pxl-item--img wrap-img-distortion">
                <?php echo wp_kses_post($thumbnail); ?>
                <div class="wrap-distort-canvas"></div>
            </div>
        <?php endif; ?>
        <a class="pxl-middle-full" <?php pxl_print_html($widget->get_render_attribute_string( 'item_link2' )); ?>>
        </a>
        <div class="box-right">
            <h5 class="pxl-item--title">
             <a <?php pxl_print_html($widget->get_render_attribute_string( 'item_link2' )); ?>><?php echo pxl_print_html($settings['title']); ?></a>
         </h5>
         <h5 class="pxl-item--position"><a <?php pxl_print_html($widget->get_render_attribute_string( 'item_link2' )); ?>><?php echo pxl_print_html($settings['pos']); ?></a></h5>
     </div>
 </div>
</div>