<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', '500');
$drap = $widget->get_setting('drap', false);  
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
?>
<?php if(isset($settings['team2']) && !empty($settings['team2']) && count($settings['team2'])): 
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : '368x431'; ?>
<div class="pxl-swiper-slider pxl-team pxl-team-carousel2 pxl-team-layout3 <?php echo esc_attr($settings['style']); ?> " <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_html('drag', 'dreamslab'); ?>"<?php endif; ?>>
    <div class="pxl-carousel-inner">
        <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
            <div class="pxl-swiper-wrapper">
                <?php foreach ($settings['team2'] as $key => $value):
                    $title = isset($value['title2']) ? $value['title2'] : '';
                    $position = isset($value['position2']) ? $value['position2'] : '';
                    $desc = isset($value['desc']) ? $value['desc'] : '';
                    $image = isset($value['image2']) ? $value['image2'] : '';
                    $social = isset($value['social2']) ? $value['social2'] : '';  
                    $link = isset($value['link2']) ? $value['link2'] : '';
                    $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                    if ( ! empty( $link['url'] ) ) {
                        $widget->add_render_attribute( $link_key, 'href', $link['url'] );

                        if ( $link['is_external'] ) {
                            $widget->add_render_attribute( $link_key, 'target', '_blank' );
                        }

                        if ( $link['nofollow'] ) {
                            $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                        }
                    }
                    $link_attributes = $widget->get_render_attribute_string( $link_key );
                    if(!empty($image['id'])) { ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>">
                                <?php if(!empty($social)): ?>
                                    <div class="pxl-item--social">
                                     <?php
                                     $team_social = json_decode($social, true);
                                     foreach ($team_social as $value):
                                        if (!empty($value['url'])): ?>
                                            <a href="<?php echo esc_url($value['url']); ?>">
                                            <?php endif; ?>
                                            <span><?php echo pxl_print_html($value['content']); ?></span>
                                            <?php if (!empty($value['url'])): ?>
                                            </a>
                                        <?php endif;
                                    endforeach;
                                    ?>
                                </div>
                            <?php endif; ?>
                            <?php if(!empty($image['id'])) { 
                                $img = pxl_get_image_by_size( array(
                                    'attach_id'  => $image['id'],
                                    'thumb_size' => $image_size,
                                    'class' => 'no-lazyload',
                                ));
                                $thumbnail = $img['thumbnail'];
                                ?>
                                <div class="pxl-item--image">
                                    <a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php echo wp_kses_post($thumbnail); ?></a>
                                    <?php if ( ! empty( $link['url'] ) ) { ?><a class="btn-arrow" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                        <span class="button-arrow-hover">
                                            <svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" enable-background="new 0 0 1500 1500" height="512" viewBox="0 0 1500 1500" width="512"><g><path d="m1251.1 148.3h-728.4v-142.3h971.3v970l-142.3-.1v-727l-1245.1 1245.1-100.6-100.6z"/></g></svg>
                                            <svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" enable-background="new 0 0 1500 1500" height="512" viewBox="0 0 1500 1500" width="512"><g><path d="m1251.1 148.3h-728.4v-142.3h971.3v970l-142.3-.1v-727l-1245.1 1245.1-100.6-100.6z"/></g></svg>
                                        </span>
                                    <?php } ?>
                                    <?php if ( ! empty( $link['url'] ) ) { ?></a><?php } ?>
                                </div>
                            <?php } ?>
                            <div class="pxl-item--holder">
                                <h3 class="pxl-item--title">    
                                    <a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php echo pxl_print_html($title); ?></a>
                                </h3>
                                <div class="pxl-item--position"><?php echo pxl_print_html($position); ?></div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            <?php endforeach; ?>
        </div>
    </div>

    <?php if($pagination !== false): ?>
        <div class="pxl-swiper-dots style-1"></div>
    <?php endif; ?>

    <?php if($arrows !== false): ?>
        <div class="pxl-swiper-arrow-wrap style-9">
            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 753.2 476.2" style="enable-background:new 0 0 753.2 476.2;" xml:space="preserve">
                    <polygon points="622.6,107.5 601.4,128.7 695.8,223.1 277,223.1 277,253.1 695.8,253.1 601.4,347.5 622.6,368.7 753.2,238.1 "/>
                    <rect y="223.1" width="283.9" height="30"/>
                </svg>
            </div>
            <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 753.2 476.2" style="enable-background:new 0 0 753.2 476.2;" xml:space="preserve">
                    <polygon points="622.6,107.5 601.4,128.7 695.8,223.1 277,223.1 277,253.1 695.8,253.1 601.4,347.5 622.6,368.7 753.2,238.1 "/>
                    <rect y="223.1" width="283.9" height="30"/>
                </svg>
            </div>
        </div>
    <?php endif; ?>

</div>
</div>
<?php endif; ?>
