<?php
if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="pxl-testimonial-carousel pxl-testimonial-carousel6 pxl-animate-shadow">
            <?php foreach ($settings['testimonial'] as $key => $value):
                $name = isset($value['name']) ? $value['name'] : '';
                $title3 = isset($value['title']) ? $value['title'] : '';
                $position = isset($value['position']) ? $value['position'] : '';
                $image = isset($value['image']) ? $value['image'] : '';
                $sub_title = isset($value['sub_title']) ? $value['sub_title'] : '';
                $desc3 = isset($value['desc']) ? $value['desc'] : '';
                ?>
                <div class="pxl-card-slide">
                    <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                    <?php if(!empty($image['id'])) { 
                        $img = pxl_get_image_by_size( array(
                            'attach_id'  => $image['id'],
                            'thumb_size' => '70x70',
                            'class' => 'no-lazyload',
                        ));
                        $thumbnail = $img['thumbnail'];?>
                        <div class="pxl-item--avatar ">
                            <?php echo wp_kses_post($thumbnail); ?>
                            <div class="pxl-item--meta">
                                <h5 class="pxl-item--title"><?php echo pxl_print_html($title3); ?></h5>
                                <div class="pxl-item--position"><?php echo pxl_print_html($position); ?></div>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="pxl-item--icon">“</div>
                    <h3 class="pxl-item--heading"><?php echo pxl_print_html($sub_title); ?></h3>
                    <div class="pxl-item--desc"><?php echo pxl_print_html($desc3); ?></div>
                </div>
            </div>
        <?php endforeach; ?>
        <div class="nav-wrapper">
            <div class="nav left">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 753.2 476.2" style="enable-background:new 0 0 753.2 476.2;" xml:space="preserve">
                <polygon points="622.6,107.5 601.4,128.7 695.8,223.1 277,223.1 277,253.1 695.8,253.1 601.4,347.5 622.6,368.7 753.2,238.1 "/>
                <rect y="223.1" width="283.9" height="30"/>
                </svg>
            </div>
            <div class="nav right">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 753.2 476.2" style="enable-background:new 0 0 753.2 476.2;" xml:space="preserve">
                <polygon points="622.6,107.5 601.4,128.7 695.8,223.1 277,223.1 277,253.1 695.8,253.1 601.4,347.5 622.6,368.7 753.2,238.1 "/>
                <rect y="223.1" width="283.9" height="30"/>
                </svg>
            </div>
        </div>
    </div>
<?php endif; ?>
