<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$center = $widget->get_setting('center', false);
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', '500');
$drap = $widget->get_setting('drap', false);  
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'center_slide'                  => (bool)$center, 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['text7']) && !empty($settings['text7']) && count($settings['text7'])): ?>
    <div class="pxl-swiper-slider pxl-text-carousel pxl-text-carousel7 pxl-parent-transition <?php echo esc_attr($settings['style_t']); ?>" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'dreamslab'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['text7'] as $key => $value):
                        $title2 = isset($value['title7']) ? $value['title7'] : '';
                        $sub_title2 = isset($value['sub_title7']) ? $value['sub_title7'] : '';
                        $desc2 = isset($value['desc7']) ? $value['desc7'] : '';
                        $image = isset($value['image7']) ? $value['image7'] : '';
                        $btn_text = isset($value['btn_text7']) ? $value['btn_text7'] : '';
                        $link_key = $widget->get_repeater_setting_key( 'icon_link7', 'value', $key );
                        if ( ! empty( $value['icon_link7']['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $value['icon_link7']['url'] );

                            if ( $value['icon_link7']['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $value['icon_link7']['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key );
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                <?php if ( !empty($image['id']) ) : ?>
                                    <div class="pxl-item--image pxl-middle pxl-hover-transition">
                                        <?php $img  = pxl_get_image_by_size( array(
                                            'attach_id'  => $image['id'],
                                            'thumb_size' => 'full',
                                        ) );
                                        $thumbnail    = $img['thumbnail'];
                                        echo pxl_print_html($thumbnail); ?>
                                    </div>
                                <?php endif; ?>
                                <div class="pxl-item--subtitle el-empty pxl-transtion"><?php echo pxl_print_html($sub_title2); ?></div>
                                <h3 class="pxl-item--title el-empty pxl-transtion"><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php echo pxl_print_html($title2); ?></a></h3>
                                <p class="pxl-item--desc el-empty pxl-transtion"><?php echo pxl_print_html($desc2); ?></p>
                                <?php if (!empty($btn_text)) { ?>
                                    <a class="btn-readmore btn-text-nanuk pxl-flex-center" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                       <span class="pxl--btn-text" data-text="<?php echo esc_attr($btn_text); ?>">
                                        <?php if(!empty($btn_text)) {
                                            $chars = preg_split('//u', $btn_text, -1, PREG_SPLIT_NO_EMPTY);
                                            foreach ($chars as $value) {
                                                if($value == ' ') {
                                                    echo '<span class="spacer">&nbsp;</span>';
                                                } else {
                                                    echo '<span>'.$value.'</span>';
                                                }
                                            }
                                        } else {
                                            echo esc_html__('find out more', 'dreamslab');
                                        } ?>
                                    </span>
                                </a>
                            <?php } ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

    </div>
    <?php if($pagination !== false || $arrows !== false): ?>
        <div class="pxl-swiper-bottom pxl-flex-middle">
            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots style-1"></div>
            <?php endif; ?>
            <?php if($arrows !== false): ?>
                <div class="pxl-wrap-arrow pxl-flex-middle">
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 57.7 60.45"><defs><style>.cls-1{fill:none;stroke:#fff;stroke-miterlimit:10;stroke-width:2px;}</style></defs><polyline class="cls-1" points="26.8 0.71 56.28 30.23 26.8 59.74"/><line class="cls-1" x1="56.28" y1="30.23" y2="30.23"/></svg></div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 57.7 60.45"><defs><style>.cls-1{fill:none;stroke:#fff;stroke-miterlimit:10;stroke-width:2px;}</style></defs><polyline class="cls-1" points="26.8 0.71 56.28 30.23 26.8 59.74"/><line class="cls-1" x1="56.28" y1="30.23" y2="30.23"/></svg></div>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>
<?php endif; ?>
