<?php 
$img_size = '';
if(!empty($settings['img_size'])) {
    $img_size = $settings['img_size'];
} else {
    $img_size = 'full';
}
?>
<div class="pxl-video-player pxl-video-player1 pxl-video-<?php echo esc_attr($settings['btn_video_style'].' '.$settings['box_style']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-video--inner ">
        <?php if( $settings['image_type'] != 'none' && !empty( $settings['image']['url'] ) ) : 
            $img  = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $img_size,
            ) );
            $thumbnail    = $img['thumbnail'];
            ?>
            <div class="pxl-video--holder wrap-img-distortion">
                <?php if ($settings['image_type'] == 'img') { ?>
                    <?php if ( ! empty( $settings['image']['url'] ) ) { echo wp_kses_post($thumbnail); } ?>
                    <div class="wrap-distort-canvas"></div>
                <?php } else { ?>
                    <div class="pxl-video--imagebg">
                        <div class="bg-image" data-parallax='{"y":-60}' style="background-image: url(<?php echo esc_url($settings['image']['url']); ?>);"></div>
                    </div>
                <?php } ?>
            </div>
        <?php endif; ?>
        <?php if(!empty($settings['video_link'])) : ?>
            <div class="btn-video-wrap  el-parallax-wrap <?php echo esc_attr($settings['btn_video_position']); ?>">
                <a class="pxl-btn-video pxl-action-popup el-parallax-item <?php echo esc_attr($settings['btn_video_style']); ?>" href="<?php echo esc_url($settings['video_link']); ?>">
                    <?php if ( !empty($settings['video_icon']['value']) ) { ?>
                        <?php \Elementor\Icons_Manager::render_icon( $settings['video_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                    <?php } else { ?>
                        <i class="fas fa-play"></i>
                    <?php } ?>
                </a>
                <?php if (!empty($settings['label'])): ?>
                <span class="label-text">
                    <?php echo pxl_print_html($settings['label']);?>
                </span>
                <?php endif ?>
            </div>
        <?php endif; ?>
    </div>
</div>