( function( $ ) {
    $( window ).on( 'elementor/frontend/init', function() {
        setTimeout(function() {
            $('.pxl-grid').each(function(index, element) { 
                var $grid_scope = $(this);
                dreamslab_hover();
                dreamslab_accordion();
                
                // var svgPaths = $('.pxl-service-list .pxl-post--icon svg path, .pxl-service-list .pxl-post--icon svg line, .pxl-service-list .pxl-post--icon svg circle, .pxl-icon-list.style-5 svg path, .pxl-icon-list.style-5 svg line, .pxl-icon-list.style-5 svg circle,.pxl-icon-box7 .pxl-item--icon svg path,.pxl-icon-box7 .pxl-item--icon svg line,.pxl-icon-box7 .pxl-item--icon svg rect,.pxl-icon-box7 .pxl-item--icon svg circle');
                // var svgPaths_load = $('.pxl-service-list .pxl-post--icon.animated svg path, .pxl-service-list .pxl-post--icon.animated svg line, .pxl-service-list .pxl-post--icon.animated svg circle, .pxl-icon-list.style-5 .animated svg path, .pxl-icon-list.style-5 .animated svg line, .pxl-icon-list.style-5 .animated svg circle');
                // svgPaths.each(function() {
                //     var totalLength = this.getTotalLength();

                //     $(this).attr({
                //         'stroke-dashoffset': totalLength,
                //         'stroke-dasharray': totalLength,
                //     });
                // });

                if( $grid_scope.hasClass('pxl-post-list')){
                    var isoOptions = {};
                    var $grid_isotope = null;
                }else{
                    var $grid_masonry = $grid_scope.find('.pxl-grid-masonry');
                    var isoOptions = {
                        itemSelector: '.pxl-grid-item',
                        layoutMode: $(this).closest('.pxl-grid').attr('data-layout'),
                        fitRows: {
                            gutter: 0
                        },
                        percentPosition: true,
                        masonry: {
                            columnWidth: '.grid-sizer',
                        },
                        containerStyle: null,
                        stagger: 30,
                        sortBy : 'name',
                    };
                    var $grid_isotope = $grid_masonry.isotope(isoOptions);


                    $grid_scope.on('click', '.pxl-grid-filter .filter-item', function(e) {

                        var $this = $(this);
                        var term_slug = $this.attr('data-filter');  
                        
                        $this.siblings('.filter-item.active').removeClass('active');
                        $this.addClass('active'); 
                        $grid_scope.find('.pxl-post--inner').removeClass('animated');

                        if( $this.closest('.pxl-grid-filter').hasClass('ajax') ){
                            var loadmore = $grid_scope.data('loadmore');
                            loadmore.term_slug = term_slug;
                            dreamslab_grid_ajax_handler( $this, $grid_scope, $grid_isotope, 
                                { action: 'dreamslab_load_more_post_grid', loadmore: loadmore, iso_options: isoOptions, handler_click: 'filter', scrolltop: 0 }
                                );
                        }else{
                            $grid_isotope.isotope({ filter: term_slug });

                        }
                    });
                }
                $grid_scope.on('click', '.pxl-grid-pagination .ajax a.page-numbers', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    var $this = $(this);
                    var loadmore = $grid_scope.data('loadmore');
                    var paged = $this.attr('href');
                    paged = paged.replace('#', '');
                    loadmore.paged = parseInt(paged);
                    dreamslab_grid_ajax_handler( $this, $grid_scope, $grid_isotope, 
                        { action: 'dreamslab_load_more_post_grid', loadmore: loadmore, iso_options: isoOptions, handler_click: 'pagination', scrolltop: 0 }
                        );
                    $('html,body').animate({scrollTop: $grid_scope.offset().top - 130}, 500);
                });

                $grid_scope.on('click', '.btn-grid-loadmore', function(e) {
                    e.preventDefault();
                    var $this = $(this);
                    var loadmore = $grid_scope.data('loadmore');
                    loadmore.paged = parseInt($grid_scope.data('start-page')) + 1; 

                    dreamslab_grid_ajax_handler( $this, $grid_scope, $grid_isotope, 
                        { action: 'dreamslab_load_more_post_grid', loadmore: loadmore, iso_options: isoOptions, handler_click: 'loadmore', scrolltop: 0 }
                        );
                });

                $grid_scope.on('change', '.orderby', function(e) {
                    e.preventDefault();
                    var $this = $(this);
                    var loadmore = $grid_scope.data('loadmore');
                    loadmore.orderby = $this.val(); 

                    dreamslab_grid_ajax_handler( $this, $grid_scope, $grid_isotope, 
                        { action: 'dreamslab_load_more_post_grid', loadmore: loadmore, iso_options: isoOptions, handler_click: 'select_orderby', scrolltop: 0 }
                        );
                });

            });
function dreamslab_check_scroll() {
    var $gridItems = $('.pxl-check-scroll .list-item');
    var viewportBottom = $(window).scrollTop() + $(window).height();

    $gridItems.each(function() {
        var $gridItem = $(this);
        var elementTop = $gridItem.offset().top;
        var elementBottom = elementTop + $gridItem.outerHeight();

        if (elementTop < viewportBottom && elementBottom > $(window).scrollTop()) {
            $gridItem.addClass('visible');
        } else {
            $gridItem.removeClass('visible');
        }
    });
}

    /* Get Mouse Move Direction */
function dreamslab_hover() {
    function getDirection(ev, obj) {
        var w = $(obj).width(),
        h = $(obj).height(),
        x = (ev.pageX - $(obj).offset().left - (w / 2)) * (w > h ? (h / w) : 1),
        y = (ev.pageY - $(obj).offset().top - (h / 2)) * (h > w ? (w / h) : 1),
        d = Math.round( Math.atan2(y, x) / 1.57079633 + 5 ) % 4;
        return d;
    }
    function addClass( ev, obj, state ) {
        var direction = getDirection( ev, obj ),
        class_suffix = null;
        $(obj).removeAttr('class');
        switch ( direction ) {
        case 0 : class_suffix = '--top';    break;
        case 1 : class_suffix = '--right';  break;
        case 2 : class_suffix = '--bottom'; break;
        case 3 : class_suffix = '--left';   break;
        }
        $(obj).addClass( state + class_suffix );
    }
    $.fn.ctDeriction = function () {
        this.each(function () {
            $(this).on('mouseenter',function(ev){
                addClass( ev, this, 'pxl-in' );
            });
            $(this).on('mouseleave',function(ev){
                addClass( ev, this, 'pxl-out' );
            });
        });
    }
    $('.pxl-effect--3d .pxl-effect--direction').ctDeriction();
}

function dreamslab_accordion() {
    $(".pxl-grid-inner .pxl-accordion--title").on("click", function(e){
        e.preventDefault();

        var $clickedTitle = $(this);
        var pxl_target = $clickedTitle.data("target");
        var $item = $clickedTitle.closest('.pxl--item');
        var $accordion = $clickedTitle.closest('.pxl-accordion');
        var $allTitles = $accordion.find(".pxl-accordion--title");

        $.each($allTitles, function(index, item){
            var target = $(item).data("target");
            if (target !== pxl_target) {
                $(item).removeClass("active");
                $(item).closest('.pxl--item').removeClass("active");
                $(target).slideUp(400);
            }
        });

        $clickedTitle.addClass("active");
$item.addClass("active");
$(pxl_target).slideDown(400);
    });
}


function dreamslab_grid_ajax_handler($this, $grid_scope, $grid_isotope, args = {}){
    var settings = $.extend( true, {}, {
        action: '',
        loadmore: '',
        iso_options: {},
        handler_click: '',
        scrolltop: 0
    }, args );

    var offset_top = $grid_scope.offset().top; 

    if( settings.handler_click == 'loadmore' ){
        var loadmore_text  = $this.closest('.pxl-load-more').data('loadmore-text');
        var loading_text  = $this.closest('.pxl-load-more').data('loading-text');
        var curoffsettop = $this.offset().top;
    }    

    $.ajax({
        url: main_data.ajax_url,
        type: 'POST',
        data: {
            action: settings.action,
            settings: settings.loadmore,
            handler_click: settings.handler_click
        },
        success: function( res ) {   
            if(res.status == true){  

                if( settings.handler_click == 'loadmore' ){
                    if( settings.loadmore.wg_type == 'post-list'){
                        $grid_scope.find('.pxl-list-inner').append(res.data.html)
                    }else{
                        $grid_scope.find('.pxl-grid-inner').append(res.data.html)
                    }
                }else{
                    if( settings.loadmore.wg_type == 'post-list'){
                        $grid_scope.find('.pxl-list-inner .list-item').remove();
                        $grid_scope.find('.pxl-list-inner').append(res.data.html);
                    }else{
                        $grid_scope.find('.pxl-grid-inner .pxl-grid-item').remove();
                        $grid_scope.find('.pxl-grid-inner').append(res.data.html);
                    }
                }

                if( settings.iso_options && $grid_isotope != null){
                    $grid_isotope.isotope('destroy');
                    $grid_isotope.isotope(settings.iso_options);
                }


                $grid_scope.data('start-page', res.data.paged);

                if( settings.loadmore['pagination_type'] == 'loadmore'){
                    if(res.data.paged >= res.data.max){
                        $grid_scope.find('.pxl-load-more').hide();
                    }else{
                        $grid_scope.find('.pxl-load-more').show();
                    } 
                } 
                if( settings.loadmore['pagination_type'] == 'pagination'){
                    $grid_scope.find(".pxl-grid-pagination").html(res.data.pagin_html);
                }

                if( $grid_scope.find('.result-count').length > 0 ){
                    $grid_scope.find(".result-count").html(res.data.result_count);
                } 
                dreamslab_check_scroll();
                dreamslab_hover();

                $(document).on('click', '.filter-item, .nice-select .option', function() {
                    $('.pxl-check-scroll .list-item').removeClass('visible').addClass('visible');
                });
            }      

        },
        beforeSend: function() {  
            $grid_scope.find('.pxl-grid-overlay-loading').removeClass( 'loaded' ).addClass( 'loader' );
            if( settings.handler_click == 'loadmore' ){
                $this.find('.pxl-loadmore-text').text(loading_text);
                $this.parent().addClass('loading');
            }
        },
        complete: function() {
            $grid_scope.find('.pxl-grid-overlay-loading').removeClass( 'loader' ).addClass( 'loaded' ); 
            if( settings.handler_click == 'loadmore' ){
                $this.find('.pxl-loadmore-text').text(loadmore_text);
                $this.parent().removeClass('loading');
            }
            if ( settings.scrolltop ) {
                $( 'html, body' ).animate( { scrollTop: offset_top - 100 }, 0 );
            }
        }
    });
}
}, 150);
});

} )( jQuery ); 