( function( $ ) {

  $(document).ready(function () {
    $(".pxl-tabs").each(function () {
      var $tabs = $(this);

      $tabs.find("#toggleTab").on("change", function () {
        let $switchBtn = $(this).closest(".pxl-tabs__switch-btn");
        let $tabsContent = $tabs.find(".pxl-tabs__content");
        let $tabItems = $tabsContent.find(".pxl-tabs__item");

        let $dataTab1 = $switchBtn.data("st");
        let $dataTab2 = $switchBtn.data("nd");

        $tabItems.toggleClass("active");
        $tabItems.filter(".active").prependTo($tabsContent);
  });

      pxl_widget_tabs_handler(
      {
          find: function (selector) {
            return $tabs.find(selector);
        }
    },
    $
    );
  });
});

  var pxl_widget_tabs_handler = function( $scope, $ ) {
    $scope.find(".pxl-tabs.tab-effect-slide .pxl-item--title").on("click", function(e){
        e.preventDefault();
        var target = $(this).data("target");
        var parent = $(this).parents(".pxl-tabs");

        parent.find(".pxl-tabs--content .pxl-item--content").stop(true, true).slideUp(500);
        parent.find(".pxl-tabs--title .pxl-item--title").removeClass('active');

        $(this).addClass("active");
        $(target).stop(true, true).slideDown(500);
    });

    $scope.find(".pxl-tabs.tab-effect-fade .pxl-item--title").on("click", function(e){
        e.preventDefault();
        var target = $(this).data("target");
        var parent = $(this).parents(".pxl-tabs");
        parent.find(".pxl-tabs--content .pxl-item--content").removeClass("active");
        parent.find(".pxl-tabs--title .pxl-item--title").removeClass('active');
        $(this).addClass("active");
        $(target).addClass("active");
    });
};

$( window ).on( 'elementor/frontend/init', function() {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_tabs.default', pxl_widget_tabs_handler );
} );

} )( jQuery ); 