<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_banner_box',
        'title' => esc_html__('BR Banner Box', 'dreamslab'),
        'icon' => 'eicon-posts-ticker icon-brand-elementor',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dreamslab' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_banner_box/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_banner_box/layout2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__('Layout 3', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_banner_box/layout3.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content2',
                    'label' => esc_html__('Content', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                        'layout' => ['3'],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'sub_title3',
                            'label' => esc_html__('Step', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'title2',
                            'label' => esc_html__('Title', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'desc3',
                            'label' => esc_html__('Description', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'rows' => 10,
                            'show_label' => false,
                        ),
                        array(
                            'name' => 'link3',
                            'label' => esc_html__('Link', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'default' => [
                                'url' => '#',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dreamslab'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                        'layout' => ['1','2'],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'banner_image',
                            'label' => esc_html__('Image', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'banner_image_logo',
                            'label' => esc_html__('Logo', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'text',
                            'label' => esc_html__('Text', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Click Here', 'dreamslab'),
                            'condition' => [
                                'layout' => ['1'],
                            ],
                        ),
                        array(
                            'name' => 'btn_icon',
                            'label' => esc_html__('Icon', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'label_block' => true,
                            'fa4compatibility' => 'icon',
                            'condition' => [
                                'layout' => ['1'],
                            ],
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'default' => [
                                'url' => '#',
                            ],
                            'condition' => [
                                'layout' => ['1'],
                            ],
                        ),
                        array(
                            'name' => 'item',
                            'label' => esc_html__('Items', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => [
                                'layout' => ['2'],
                            ],
                            'controls' => array(
                                array(
                                    'name' => 'icon_link',
                                    'label' => esc_html__('Link', 'dreamslab'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'content',
                                    'label' => esc_html__('Content', 'dreamslab'),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'item_position',
                                    'label' => esc_html__('Item Position', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'options' => [
                                        'p-center' => 'Center',
                                        'p-top-left' => 'Top Left',
                                        'p-top-right' => 'Top Right',
                                        'p-bottom-left' => 'Bottom Left',
                                        'p-bottom-right' => 'Bottom Right',
                                    ],
                                    'default' => 'p-center',
                                ),
                                array(
                                    'name' => 'item_top_positioon',
                                    'label' => esc_html__('Top Position', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'size_units' => [ 'px', '%' ],
                                    'control_type' => 'responsive',
                                    'range' => [
                                        '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                    'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-banner {{CURRENT_ITEM}}.p-top-left, {{WRAPPER}} .pxl-banner {{CURRENT_ITEM}}.p-top-right' => 'top: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                                array(
                                    'name' => 'item_right_positioon',
                                    'label' => esc_html__('Right Position', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'size_units' => [ 'px', '%' ],
                                    'control_type' => 'responsive',
                                    'range' => [
                                        '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                    'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-banner {{CURRENT_ITEM}}.p-top-right, {{WRAPPER}} .pxl-banner {{CURRENT_ITEM}}.p-bottom-right' => 'right: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                                array(
                                    'name' => 'item_bottom_positioon',
                                    'label' => esc_html__('Bottom Position', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'size_units' => [ 'px', '%' ],
                                    'control_type' => 'responsive',
                                    'range' => [
                                        '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                    'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-banner {{CURRENT_ITEM}}.p-bottom-left, {{WRAPPER}} .pxl-banner {{CURRENT_ITEM}}.p-bottom-right' => 'bottom: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                                array(
                                    'name' => 'item_left_positioon',
                                    'label' => esc_html__('Left Position', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'size_units' => [ 'px', '%' ],
                                    'control_type' => 'responsive',
                                    'range' => [
                                        '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                    'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-banner {{CURRENT_ITEM}}.p-top-left, {{WRAPPER}} .pxl-banner {{CURRENT_ITEM}}.p-bottom-left' => 'left: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                            ),
'title_field' => '{{{ content }}}',
),
),
),
array(
    'name' => 'section_style',
    'label' => esc_html__('Style', 'dreamslab'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'style',
            'label' => esc_html__( 'Style', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style-1' => 'Style 1',
                'style-2' => 'Style 2',
            ],
            'default' => 'style-1',
        ),
        array(
            'name' => 'box_padding',
            'label' => esc_html__('Box Padding', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-banner .btn-banner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'control_type' => 'responsive',
            'condition' => [
                'layout' => ['1'],
            ],
        ),
        array(
            'name' => 'box_color',
            'label' => esc_html__('Box Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-banner .btn-banner' => 'background-color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_color',
            'label' => esc_html__('Title Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-banner .pxl--btn-text' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_typography',
            'label' => esc_html__('Typography', 'dreamslab' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-banner .pxl--btn-text',
        ),
        array(
            'name' => 'arrow_color',
            'label' => esc_html__('Arrow Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-banner svg path' => 'fill: {{VALUE}} !important;',
            ],
            'condition' => [
                'layout' => ['1'],
            ],
        ),
        array(
            'name' => 'image_height',
            'label' => esc_html__('Image Height', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'dreamslab' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-banner img' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'image_mheight',
            'label' => esc_html__('Image Max Height', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'dreamslab' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-banner img' => 'max-height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'box_width',
            'label' => esc_html__('Box Width', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'dreamslab' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'condition' => [
                'layout' => ['1'],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-banner .btn-banner' => 'max-width: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'box_width_poin',
            'label' => esc_html__('Box Width', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'dreamslab' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'condition' => [
                'layout' => ['2'],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-banner2 .pxl-banner-inner > a .pxl-icon--plus' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};border-radius: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'box_position',
            'label' => esc_html__('Box Position', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'p-center' => 'Center',
                'p-top-left' => 'Top Left',
                'p-top-right' => 'Top Right',
                'p-bottom-left' => 'Bottom Left',
                'p-bottom-right' => 'Bottom Right',
            ],
            'default' => 'p-center',
            'condition' => [
                'layout' => ['1'],
            ],
        ),
        array(
            'name' => 'top_positioon',
            'label' => esc_html__('Top Position', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'control_type' => 'responsive',
            'range' => [
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-banner .btn-banner.p-top-left, {{WRAPPER}} .pxl-banner .btn-banner.p-top-right' => 'top: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'box_position' => ['p-top-left', 'p-top-right'],
            ],
        ),
        array(
            'name' => 'right_positioon',
            'label' => esc_html__('Right Position', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'control_type' => 'responsive',
            'range' => [
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-banner .btn-banner.p-top-right, {{WRAPPER}} .pxl-banner .btn-banner.p-bottom-right' => 'right: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'box_position' => ['p-top-right', 'p-bottom-right'],
            ],
        ),
        array(
            'name' => 'bottom_positioon',
            'label' => esc_html__('Bottom Position', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'control_type' => 'responsive',
            'range' => [
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-banner .btn-banner.p-bottom-left, {{WRAPPER}} .pxl-banner .btn-banner.p-bottom-right' => 'bottom: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'box_position' => ['p-bottom-left', 'p-bottom-right'],
            ],
        ),
        array(
            'name' => 'left_positioon',
            'label' => esc_html__('Left Position', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'control_type' => 'responsive',
            'range' => [
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-banner .btn-banner.p-top-left, {{WRAPPER}} .pxl-banner .btn-banner.p-bottom-left' => 'left: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'box_position' => ['p-top-left', 'p-bottom-left'],
            ],
        ),
    ),
),
array(
    'name' => 'section_style_icon',
    'label' => esc_html__('Icon', 'dreamslab'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'icon_top_positioon',
            'label' => esc_html__('Top Position', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'control_type' => 'responsive',
            'range' => [
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-banner .btn-banner .button-arrow-hover' => 'top: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'icon_right_positioon',
            'label' => esc_html__('Right Position', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'control_type' => 'responsive',
            'range' => [
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-banner .btn-banner .button-arrow-hover' => 'right: {{SIZE}}{{UNIT}};',
            ],
        ),
    ),
),
dreamslab_widget_animation_settings(),
),
),
),
dreamslab_get_class_widget_path()
);