<?php
$templates_df = ['0' => esc_html__('None', 'dreamslab')];
$templates = $templates_df + dreamslab_get_templates_option('popup') ;
pxl_add_custom_widget(
    array(
        'name' => 'pxl_button',
        'title' => esc_html__('BR Button', 'dreamslab' ),
        'icon' => 'eicon-button icon-brand-elementor',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'btn_style',
                            'label' => esc_html__('Type', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'btn-default',
                            'options' => [
                                'btn-default' => esc_html__('Default', 'dreamslab' ),
                                'btn-drow-arrow' => esc_html__('Arrows', 'dreamslab' ),
                                'btn-icon-box' => esc_html__('Icon Box', 'dreamslab' ),
                                'btn-icon-box-hover' => esc_html__('Icon Box Hover', 'dreamslab' ),
                                'btn-icon-box-square' => esc_html__('Icon Box Square', 'dreamslab' ),
                                'btn-blur' => esc_html__('Background Blur', 'dreamslab' ),
                                'btn-gradient' => esc_html__('Background Gradient', 'dreamslab' ),
                                'btn-border' => esc_html__('Border', 'dreamslab' ),
                                'btn-popup' => esc_html__('Popup', 'dreamslab' ),
                                'btn-full-box' => esc_html__('Full Box', 'dreamslab' ),
                                'btn-icon-box2' => esc_html__('Icon Box Shadow', 'dreamslab' ),
                            ],
                        ),
                        array(
                            'name'         => 'btn_gradient_box',
                            'label' => esc_html__( 'Background Type', 'dreamslab' ),
                            'type'         => \Elementor\Group_Control_Background::get_type(),
                            'control_type' => 'group',
                            'types' => [ 'gradient' ],
                            'selector'     => '{{WRAPPER}} .pxl-button .btn.btn-icon-box2',
                             'condition' => [
                                'btn_style' => ['btn-icon-box2'],
                            ],
                        ),
                        array(
                            'name' => 'button_width_border',
                            'label' => esc_html__( 'Button Width', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button .btn.btn-border' => 'max-width: {{SIZE}}{{UNIT}};min-width: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'btn_style' => ['btn-border'],
                            ],
                        ),
                        array(
                            'name' => 'button_width_square',
                            'label' => esc_html__( 'Button Height', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button .btn.btn-icon-box-square' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'btn_style' => ['btn-icon-box-square'],
                            ],
                        ),
                        array(
                            'name' => 'text',
                            'label' => esc_html__('Text', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Click Here', 'dreamslab'),
                        ),
                        array(
                            'name' => 'btn_action',
                            'label' => esc_html__('Action', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'pxl-atc-link',
                            'options' => [
                                'pxl-atc-link' => esc_html__('Link', 'dreamslab' ),
                                'pxl-atc-popup' => esc_html__('Popup', 'dreamslab' ),
                                'pxl-caption-btn' => esc_html__('Caption Loading', 'dreamslab' ),
                            ],
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'default' => [
                                'url' => '#',
                            ],
                            'condition' => [
                                'btn_action' => ['pxl-atc-link','pxl-caption-btn'],
                            ],
                        ),

                        array(
                            'name' => 'popup_template',
                            'label' => esc_html__('Select Popup Template', 'dreamslab'),
                            'type' => 'select',
                            'options' => $templates,
                            'default' => 'df',
                            'description' => 'Add new tab template: "<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '" target="_blank">Click Here</a>"',
                            'condition' => [
                                'btn_action' => ['pxl-atc-popup'],
                            ],
                        ),

                        array(
                            'name' => 'align',
                            'label' => esc_html__('Alignment', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left'    => [
                                    'title' => esc_html__('Left', 'dreamslab' ),
                                    'icon' => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__('Center', 'dreamslab' ),
                                    'icon' => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__('Right', 'dreamslab' ),
                                    'icon' => 'fa fa-align-right',
                                ],
                                'justify' => [
                                    'title' => esc_html__('Justified', 'dreamslab' ),
                                    'icon' => 'fa fa-align-justify',
                                ],
                            ],
                            'prefix_class' => 'elementor-align-',
                            'default' => '',
                            'selectors'         => [
                                '{{WRAPPER}} .pxl-button' => 'text-align: {{VALUE}}',
                            ],
                        ),
                        array(
                            'name' => 'btn_icon',
                            'label' => esc_html__('Icon', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'label_block' => true,
                            'fa4compatibility' => 'icon',
                        ),
                        array(
                            'name' => 'icon_align',
                            'label' => esc_html__('Icon Position', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'right',
                            'options' => [
                                'left' => esc_html__('Before', 'dreamslab' ),
                                'right' => esc_html__('After', 'dreamslab' ),
                            ],
                        ),
                    ),
),

array(
    'name' => 'section_style_button',
    'label' => esc_html__('Button Normal', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array_merge(
        array(
            array(
                'name' => 'btn_w',
                'label' => esc_html__('Width', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'inline',
                'options' => [
                    'inline' => esc_html__('Inline', 'dreamslab' ),
                    'full' => esc_html__('Full Width', 'dreamslab' ),
                ],
            ),
            array(
                'name' => 'button_width',
                'label' => esc_html__( 'Button Width/Height', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn.btn-icon-box,{{WRAPPER}} .pxl-button .btn.btn-icon-box-hover,{{WRAPPER}} .btn.btn-icon-box-dot,{{WRAPPER}} .btn.btn-icon-box2' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'btn_style' => ['btn-icon-box','btn-icon-box-hover','btn-icon-box-dot','btn-icon-box2'],
                ],
            ),
            array(
                'name' => 'color',
                'label' => esc_html__('Color', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 'btn_bg_color',
                'label' => esc_html__('Background Color', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn' => 'background-color: {{VALUE}};',
                ],
            ),

            array(
                'name' => 'btn_stroke_color',
                'label' => esc_html__('Stroke Color', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn.btn-stroke .pxl-svg-line path' => 'stroke: {{VALUE}};',
                ],
                'condition' => [
                    'btn_style' => ['btn-stroke'],
                ],
            ),
            array(
                'name'         => 'btn_gradient',
                'label' => esc_html__( 'Background Type', 'dreamslab' ),
                'type'         => \Elementor\Group_Control_Background::get_type(),
                'control_type' => 'group',
                'types' => [ 'gradient' ],
                'selector'     => '{{WRAPPER}} .pxl-button .btn',
                'condition' => [
                    'btn_style' => 'btn-gradient',
                ],
            ),
            array(
                'name' => 'btn_typography',
                'label' => esc_html__('Typography', 'dreamslab' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-button .btn',
            ),
            array(
                'name'         => 'btn_box_shadow',
                'label' => esc_html__( 'Box Shadow', 'dreamslab' ),
                'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                'control_type' => 'group',
                'selector'     => '{{WRAPPER}} .pxl-button .btn',
            ),
            array(
                'name' => 'border_type',
                'label' => esc_html__( 'Border Type', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__( 'None', 'dreamslab' ),
                    'solid' => esc_html__( 'Solid', 'dreamslab' ),
                    'double' => esc_html__( 'Double', 'dreamslab' ),
                    'dotted' => esc_html__( 'Dotted', 'dreamslab' ),
                    'dashed' => esc_html__( 'Dashed', 'dreamslab' ),
                    'groove' => esc_html__( 'Groove', 'dreamslab' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn' => 'border-style: {{VALUE}} !important;',
                ],
            ),
            array(
                'name' => 'border_width',
                'label' => esc_html__( 'Border Width', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
                'control_type' => 'responsive',
                'condition' => [
                    'border_type!' => '',
                ],
                'responsive' => true,
            ),
            array(
                'name' => 'border_color',
                'label' => esc_html__( 'Border Color', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn' => 'border-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'border_type!' => '',
                ],
            ),

            array(
                'name' => 'border_width_outline_gradient',
                'label' => esc_html__('Broder Width Gradient', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pxl-button .btn.btn-outline-gradient:after' => 'top: {{SIZE}}{{UNIT}};right: {{SIZE}}{{UNIT}};bottom: {{SIZE}}{{UNIT}};left: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'btn_style' => ['btn-outline-gradient'],
                ],
            ),
            array(
                'name'    => 'parallax_value_x',
                'label'   => esc_html__( 'Parallax Value X', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '0',
            ),
            array(
                'name'    => 'parallax_value_y',
                'label'   => esc_html__( 'Parallax Value Y', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '0',
            ),
            array(
                'name'    => 'parallax_value_z',
                'label'   => esc_html__( 'Parallax Value Z', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '0',
            ),
        ),

array(
    array(
        'name' => 'btn_border_radius',
        'label' => esc_html__('Border Radius', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
            '{{WRAPPER}} .pxl-button .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ),
    array(
        'name' => 'btn_padding',
        'label' => esc_html__('Padding', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
            '{{WRAPPER}} .pxl-button .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'control_type' => 'responsive',
    ),
)
),
),

array(
    'name' => 'section_style_button_hover',
    'label' => esc_html__('Button Hover', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'btn_text_effect',
            'label' => esc_html__('Text Effect', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '',
            'options' => [
                '' => esc_html__('Default', 'dreamslab' ),
                'btn-text-nina' => esc_html__('Nina', 'dreamslab' ),
                'btn-text-nanuk' => esc_html__('Nanuk', 'dreamslab' ),
                'btn-text-smoke' => esc_html__('Smoke', 'dreamslab' ),
                'btn-text-reverse' => esc_html__('Reverse', 'dreamslab' ),
                'btn-text-parallax' => esc_html__('Text Parallax', 'dreamslab' ),
                'btn-hide-icon' => esc_html__('Hide Icon', 'dreamslab' ),
                'btn-glossy' => esc_html__('Glossy', 'dreamslab' ),
                'btn-underline' => esc_html__('Underline', 'dreamslab' ),
                'btn-text-applied' => esc_html__('Applied', 'dreamslab' ),
            ],
        ),
        array(
            'name' => 'button_gap',
            'label' => esc_html__( 'Button Gap', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn.btn-text-applied .pxl--btn-text' => 'margin-right: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-button .btn.btn-text-applied:hover .pxl--btn-text' => 'margin-left: {{SIZE}}{{UNIT}};margin-right: 0;',
            ],
            'condition' => [
                'btn_text_effect' => ['btn-text-applied'],
            ],
        ),
        array(
            'name' => 'gap_hide_icon',
            'label' => esc_html__( 'Gap Hide Icon', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .btn:not(.btn-stroke).btn-hide-icon:hover svg' => 'transform: translateX({{SIZE}}{{UNIT}});',
                '{{WRAPPER}} .btn:not(.btn-stroke).btn-hide-icon:hover .chars' => 'transform: translateX(-{{SIZE}}{{UNIT}});',
            ],
            'condition' => [
                'btn_text_effect' => 'btn-hide-icon',
            ],
        ),
        array(
            'name' => 'transition_duration',
            'label' => esc_html__('Transition Duration', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .btn.btn-text-reverse .pxl-text--inner span' => 'transition-duration: {{SIZE}}ms;',
            ],
            'condition' => [
                'btn_text_effect' => ['btn-text-reverse'],
            ],
            'description' => 'Enter number, unit is ms.',
        ),
        array(
            'name' => 'color_hover',
            'label' => esc_html__('Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn:hover' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-button .btn-hide-icon .pxl--btn-text:before' => 'background-color: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'bd_color_hover',
            'label' => esc_html__('Border Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn:hover' => ' border-color: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'btn_bg_color_hover',
            'label' => esc_html__('Background Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn:hover' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'btn_style!' => [''],
            ],
        ),

        array(
            'name'         => 'btn_box_shadow_hover',
            'label' => esc_html__( 'Box Shadow', 'dreamslab' ),
            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
            'control_type' => 'group',
            'selector'     => '{{WRAPPER}} .pxl-button .btn:hover',
        ),
    ),
),

array(
    'name' => 'section_style_icon',
    'label' => esc_html__('Icon', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'icon_type',
            'label' => esc_html__('Icon Type', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'icon-fill',
            'options' => [
                'icon-fill' => esc_html__('Fill', 'dreamslab' ),
                'icon-stroke' => esc_html__('Stroke', 'dreamslab' ),
            ],
        ),
        array(
            'name' => 'icon_color',
            'label' => esc_html__('Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn i' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-button .btn svg path' => 'fill: {{VALUE}};',
                '{{WRAPPER}} .pxl-button .btn .st0' => 'stroke: {{VALUE}};',
            ],
            'condition' => [
                'icon_type' => ['icon-fill'],
            ],
        ),
        array(
            'name' => 'icon_hv_color',
            'label' => esc_html__('Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn:hover i' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-button .btn:hover svg path' => 'fill: {{VALUE}};',
            ],
            'condition' => [
                'icon_type' => ['icon-fill'],
            ],
        ),
        array(
            'name' => 'icon_color_s',
            'label' => esc_html__('Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn i' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-button .btn svg' => 'stroke: {{VALUE}};',
            ],
            'condition' => [
                'icon_type' => ['icon-stroke'],
            ],
        ),
        array(
            'name' => 'icon_hv_color_s',
            'label' => esc_html__('Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn:hover i' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-button .btn:hover svg' => 'stroke: {{VALUE}};',
            ],
            'condition' => [
                'icon_type' => ['icon-stroke'],
            ],
        ),
        array(
            'name' => 'icon_font_size',
            'label' => esc_html__('Font Size', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-button .btn svg' => 'width: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-button .btn-svg:hover svg' => 'width: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'icon_font_siz_s',
            'label' => esc_html__('Font Size Svg', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn svg' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'icon_space_left',
            'label' => esc_html__('Icon Spacer', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'default' => [
                'size' => 9,
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn.pxl-icon--left:not(.btn-svg) i, {{WRAPPER}} .pxl-button .btn.pxl-icon--left:not(.btn-svg) svg' => 'margin-right: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-button .btn-svg.pxl-icon--left:hover  svg' => 'margin-right: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-button .btn-drow-arrow.pxl-icon--left .crossline-arrow' => 'margin-right: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'icon_align' => ['left'],
                'btn_text_effect!' => ['btn-text-applied'],
            ],
        ),
        array(
            'name' => 'icon_space_bottom_box',
            'label' => esc_html__('Icon Spacer Bottom', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'default' => [
                'size' => 9,
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn.pxl-icon--left:not(.btn-svg) i, {{WRAPPER}} .pxl-button .btn.pxl-icon--left:not(.btn-svg) svg' => 'margin-right: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-button .btn-svg.pxl-icon--left:hover  svg' => 'margin-right: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-button .btn-drow-arrow.pxl-icon--left .crossline-arrow' => 'margin-right: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'icon_align' => ['left'],
                'btn_text_effect!' => ['btn-text-applied'],
            ],
        ),
        array(
            'name' => 'icon_space_left_applied',
            'label' => esc_html__('Icon Spacer Left', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'default' => [
                'size' => 0,
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn .btn-icon-left' => 'margin-inline-end: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'btn_text_effect' => ['btn-text-applied'],
            ],
        ),
        array(
            'name' => 'icon_space_right_applied',
            'label' => esc_html__('Icon Spacer Right', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn .btn-icon-right' => 'margin-inline-start: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-button .btn:hover .btn-icon-left' => 'margin-inline-end: {{SIZE}}{{UNIT}};margin-inline-start: 0;',
                '{{WRAPPER}} .pxl-button .btn:hover .btn-icon-right' => 'margin-inline-start: 0;',
            ],
            'condition' => [
                'btn_text_effect' => ['btn-text-applied'],
            ],
        ),
        array(
            'name' => 'icon_space_right',
            'label' => esc_html__('Icon Spacer', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-button .btn.pxl-icon--right:not(.btn-svg) i, {{WRAPPER}} .pxl-button .btn.pxl-icon--right:not(.btn-svg) svg' => 'margin-left: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-button .btn-svg.pxl-icon--right:hover svg' => 'margin-left: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-button .btn-drow-arrow.pxl-icon--right .crossline-arrow' => 'margin-left: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'icon_align' => ['right'],
                'btn_text_effect!' => ['btn-text-applied'],
            ],
        ),
    ),
),
dreamslab_widget_animation_settings(),
),
),
),
dreamslab_get_class_widget_path()
);