<?php
$templates_df = ['0' => esc_html__('None', 'dreamslab')];
$templates = $templates_df + dreamslab_get_templates_option('popup') ;

pxl_add_custom_widget(
    array(
        'name' => 'pxl_icon',
        'title' => esc_html__('BR Icons', 'dreamslab'),
        'icon' => 'eicon-alert icon-brand-elementor',
        'categories' => array('pxltheme-core'),
        'scripts'    => array(
            'pxl-MotionPathPlugin',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dreamslab'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'icons',
                            'label' => esc_html__('Icons', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                ),
                                array(
                                    'name' => 'icon_link',
                                    'label' => esc_html__('Link', 'dreamslab'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'popup_template',
                                    'label' => esc_html__('Select Popup Template', 'dreamslab'),
                                    'type' => 'select',
                                    'options' => $templates,
                                    'default' => 'df',
                                    'description' => 'Add new tab template: "<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '" target="_blank">Click Here</a>"',
                                ),
                                array(
                                    'name' => 'label',
                                    'label' => esc_html__('Label', 'dreamslab'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'content',
                                    'label' => esc_html__('Content', 'dreamslab'),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'label_block' => true,
                                    'description' => 'Apply Style Box Paralax',
                                ),
                                array(
                                    'name' => 'color_item',
                                    'label' => esc_html__( 'Color', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                    'default' => '',
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-icon1 {{CURRENT_ITEM}}' => 'color: {{VALUE}};',
                                    ],
                                ),
                                array(
                                    'name' => 'color_item_hover',
                                    'label' => esc_html__( 'Color Hover', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                    'default' => '',
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-icon1 {{CURRENT_ITEM}}:hover' => 'color: {{VALUE}};',
                                    ],
                                ),
                            ),
                            'title_field' => '{{{ label }}}',
                        ),
                        array(
                          'name' => 'align',
                          'label' => esc_html__( 'Alignment', 'dreamslab' ),
                          'type' => \Elementor\Controls_Manager::CHOOSE,
                          'control_type' => 'responsive',
                          'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'dreamslab' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'dreamslab' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'dreamslab' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-icon1' => 'text-align: {{VALUE}};justify-content: {{VALUE}};',
                        ],
                    ),
                    ),
),
array(
    'name' => 'section_style',
    'label' => esc_html__('Style', 'dreamslab'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'style',
            'label' => esc_html__('Style', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style-1' => 'Default',
                'style-2' => 'Style Box',
                'style-4' => 'Style Box 2',
                'style-3' => 'Style Label',
                'style-6' => 'Style Label 2',
                'style-5' => 'Draw Svg',
                'style-7' => 'Style Box Blur',
                'style-box-paralax' => 'Box Paralax',
            ],
            'default' => 'style-1',
        ),
        array(
            'name' => 'animate_hover',
            'label' => esc_html__('Animation Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '',
            'options' => [
                '' => esc_html__('Style 1', 'dreamslab' ),
                'ani1' => esc_html__('Style 2', 'dreamslab' ),
                'ani2' => esc_html__('Style 3', 'dreamslab' ),
                'ani3' => esc_html__('Style 4', 'dreamslab' ),
                'down' => esc_html__('Scroll Down', 'dreamslab' ),
            ],
        ),
        array(
            'name' => 'icon_svg',
            'label' => esc_html__('Icon Svg Style', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'fill',
            'options' => [
                'fill' => esc_html__('Fill', 'dreamslab' ),
                'stroke' => esc_html__('Stroke', 'dreamslab' ),
            ],
        ),
        array(
            'name' => 'color',
            'label' => esc_html__( 'Icon Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-icon1 a svg path,{{WRAPPER}} .pxl-icon1 a svg circle' => 'fill: {{VALUE}};',
            ],
            'condition' => [
                'icon_svg' => 'fill',
            ],
        ),
        array(
            'name' => 'color_h',
            'label' => esc_html__( 'Icon Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a:hover' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-icon1 a:hover svg path' => 'fill: {{VALUE}};',
            ],
            'condition' => [
                'icon_svg' => 'fill',
            ],
        ),
        array(
            'name' => 'color_s',
            'label' => esc_html__( 'Icon Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-icon1 a svg path,{{WRAPPER}} .pxl-icon1 a svg circle,{{WRAPPER}} .pxl-icon1 a svg line,{{WRAPPER}} .pxl-icon1 a svg polygon,{{WRAPPER}} .pxl-icon1 a svg rect,{{WRAPPER}} .pxl-icon1 a svg polyline' => 'stroke: {{VALUE}};',
            ],
            'condition' => [
                'icon_svg' => 'stroke',
            ],
        ),
        array(
            'name' => 'color_s_h',
            'label' => esc_html__( 'Icon Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a:hover' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-icon1 a:hover svg path,{{WRAPPER}} .pxl-icon1 a:hover svg circle,{{WRAPPER}} .pxl-icon1 a:hover svg line,{{WRAPPER}} .pxl-icon1 a:hover svg polygon,{{WRAPPER}} .pxl-icon1 a:hover svg rect,{{WRAPPER}} .pxl-icon1 a:hover svg polyline' => 'stroke: {{VALUE}};',
            ],
            'condition' => [
                'icon_svg' => 'stroke',
            ],
        ),
        array(
            'name' => 'space_t_tl',
            'label' => esc_html__('Space Bottom', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-list i' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-icon-list img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-icon-list svg' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'color_hover',
            'label' => esc_html__( 'Icon Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a:hover' => 'color: {{VALUE}};',
                '{{WRAPPER}} .pxl-icon1 a:hover svg path' => 'fill: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'box_color',
            'label' => esc_html__( 'Box Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'background-color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'box_color_hover',
            'label' => esc_html__( 'Box Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a:hover' => 'background-color: {{VALUE}};',
            ],
        ),
        array(
            'name'         => 'box_gradient',
            'label' => esc_html__( 'Background Type', 'dreamslab' ),
            'type'         => \Elementor\Group_Control_Background::get_type(),
            'control_type' => 'group',
            'types' => [ 'gradient' ],
            'selector'     => '{{WRAPPER}} .pxl-icon1 a',
        ),
        array(
            'name' => 'box_width',
            'label' => esc_html__('Box Width', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','%' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'width: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'box_height',
            'label' => esc_html__('Box Height', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px','%' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'icon_font_size',
            'label' => esc_html__('Font Size', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'font-size: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .pxl-icon1 a svg' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'border_type',
            'label' => esc_html__( 'Border Type', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => esc_html__( 'None', 'dreamslab' ),
                'solid' => esc_html__( 'Solid', 'dreamslab' ),
                'double' => esc_html__( 'Double', 'dreamslab' ),
                'dotted' => esc_html__( 'Dotted', 'dreamslab' ),
                'dashed' => esc_html__( 'Dashed', 'dreamslab' ),
                'groove' => esc_html__( 'Groove', 'dreamslab' ),
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'border-style: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'border_width',
            'label' => esc_html__( 'Border Width', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
            'condition' => [
                'border_type!' => '',
            ],
            'responsive' => true,
        ),
        array(
            'name' => 'border_color',
            'label' => esc_html__( 'Border Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'border-color: {{VALUE}} !important;',
            ],
            'condition' => [
                'border_type!' => '',
            ],
        ),

        array(
            'name' => 'border_color_hover',
            'label' => esc_html__( 'Border Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a:hover' => 'border-color: {{VALUE}} !important;',
            ],
            'condition' => [
                'border_type!' => '',
            ],
        ),
        array(
            'name' => 'icon_border_radius',
            'label' => esc_html__('Border Radius', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'icon_margin',
            'label' => esc_html__('Margin', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon1 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                '{{WRAPPER}} .pxl-icon1' => 'margin-left: -{{LEFT}}{{UNIT}};margin-right: -{{RIGHT}}{{UNIT}};',
            ],
            'control_type' => 'responsive',
        ),
    ),
),
array(
    'name' => 'section_style_t',
    'label' => esc_html__('Title', 'dreamslab'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'title_color',
            'label' => esc_html__('Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-list span' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_color_h',
            'label' => esc_html__('Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-list span' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 't_typography',
            'label' => esc_html__('Typography', 'dreamslab' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-icon-list span',
        ),
        array(
            'name' => 'title_space_tb',
            'label' => esc_html__('Transform X', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => -300,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-list span' => 'transform: translatey({{SIZE}}{{UNIT}});',
            ],
        ),
        array(
            'name' => 'custom_font',
            'label' => esc_html__('Custom Font Family', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'Default',
                'ft-gt' => 'Clash Display',
            ],
            'default' => '',
        ),
    ),
),
array(
    'name' => 'section_style_c',
    'label' => esc_html__('Content', 'dreamslab'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'content_color',
            'label' => esc_html__('Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-list .pxl-counter--content' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'content_color_h',
            'label' => esc_html__('Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-list .pxl-counter--content' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'c_typography',
            'label' => esc_html__('Typography', 'dreamslab' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-icon-list .pxl-counter--content',
        ),
        array(
            'name' => 'c_padding',
            'label' => esc_html__('Padding', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-icon-list .pxl-counter--content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'control_type' => 'responsive',
        ),
    ),
),
dreamslab_widget_animation_settings(),
),
),
),
dreamslab_get_class_widget_path()
);