<?php
$slides_to_show = range( 1, 10 );
$slides_to_show = array_combine( $slides_to_show, $slides_to_show );

pxl_add_custom_widget(
    array(
        'name' => 'pxl_iconbox_carousel',
        'title' => esc_html__('BR Icon Box Carousel', 'dreamslab'),
        'icon' => 'eicon-testimonial icon-brand-elementor',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'swiper',
            'pxl-swiper',
            'pxl-effect-gl',
            'elementor-waypoints',
            'jquery-numerator',
            'pxl-counter',
            'pxl-counter-slide',
            'dreamslab-counter',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dreamslab' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_iconbox_carousel/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_iconbox_carousel/layout2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__('Layout 3', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_iconbox_carousel/layout3.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dreamslab'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'icons',
                            'label' => esc_html__('Icons', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => [
                                'layout' => ['1','2'],
                            ],
                            'controls' => array(
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                ),
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'dreamslab'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'desc',
                                    'label' => esc_html__('Description', 'dreamslab'),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ title }}}',
                        ),
                        array(
                            'name' => 'icons2',
                            'label' => esc_html__('Icons', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => [
                                'layout' => ['3'],
                            ],
                            'controls' => array(
                             array(
                                'name' => 'starting_number',
                                'label' => esc_html__('Starting Number', 'dreamslab'),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => 1,
                            ),
                             array(
                                'name' => 'ending_number',
                                'label' => esc_html__('Ending Number', 'dreamslab'),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => 100,
                            ),
                             array(
                                'name' => 'prefix',
                                'label' => esc_html__('Number Prefix', 'dreamslab'),
                                'type' => \Elementor\Controls_Manager::TEXT,
                                'default' => '',
                            ),
                             array(
                                'name' => 'suffix',
                                'label' => esc_html__('Number Suffix', 'dreamslab'),
                                'type' => \Elementor\Controls_Manager::TEXT,
                                'default' => '',
                            ),
                             array(
                                'name' => 'pxl_icon2',
                                'label' => esc_html__('Icon', 'dreamslab' ),
                                'type' => \Elementor\Controls_Manager::ICONS,
                                'fa4compatibility' => 'icon',
                            ),
                             array(
                                'name' => 'title2',
                                'label' => esc_html__('Title', 'dreamslab'),
                                'type' => \Elementor\Controls_Manager::TEXT,
                                'label_block' => true,
                            ),
                             array(
                                'name' => 'desc2',
                                'label' => esc_html__('Description', 'dreamslab'),
                                'type' => \Elementor\Controls_Manager::TEXTAREA,
                                'label_block' => true,
                            ),
                         ),
                            'title_field' => '{{{ title2 }}}',
                        ),
                    ),
),
array(
    'name' => 'section_settings_carousel',
    'label' => esc_html__('Settings', 'dreamslab'),
    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
    'controls' => array(
      array(
        'name' => 'gap',
        'label' => esc_html__('Gap', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'control_type' => 'responsive',
        'size_units' => [ 'px' ],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 300,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .pxl-icons-carousel .pxl-swiper-slide' => 'padding: {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}} 0 {{SIZE}}{{UNIT}} !important;',
        ],
    ),
      array(
        'name' => 'col_xs',
        'label' => esc_html__('Columns XS Devices', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
            'auto' => 'Auto',
            '1' => '1',
            '2' => '2',
            '3' => '3',
            '4' => '4',
            '6' => '6',
        ],
    ),
      array(
        'name' => 'col_sm',
        'label' => esc_html__('Columns SM Devices', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '2',
        'options' => [
            'auto' => 'Auto',
            '1' => '1',
            '2' => '2',
            '3' => '3',
            '4' => '4',
            '6' => '6',
        ],
    ),
      array(
        'name' => 'col_md',
        'label' => esc_html__('Columns MD Devices', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '3',
        'options' => [
            'auto' => 'Auto',
            '1' => '1',
            '2' => '2',
            '3' => '3',
            '4' => '4',
            '6' => '6',
        ],
    ),
      array(
        'name' => 'col_lg',
        'label' => esc_html__('Columns LG Devices', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '3',
        'options' => [
            'auto' => 'Auto',
            '1' => '1',
            '2' => '2',
            '3' => '3',
            '4' => '4',
            '6' => '6',
        ],
    ),
      array(
        'name' => 'col_xl',
        'label' => esc_html__('Columns XL Devices', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '3',
        'options' => [
            'auto' => 'Auto',
            '1' => '1',
            '2' => '2',
            '3' => '3',
            '4' => '4',
            '5' => '5',
            '6' => '6',
        ],
    ),
      array(
        'name' => 'col_xxl',
        'label' => esc_html__('Columns XXL Devices', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '3',
        'options' => [
            '1' => '1',
            '2' => '2',
            '3' => '3',
            '4' => '4',
            '5' => '5',
            '6' => '6',
        ],
    ),

      array(
        'name' => 'slides_to_scroll',
        'label' => esc_html__('Slides to scroll', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
            '1' => '1',
            '2' => '2',
            '3' => '3',
            '4' => '4',
            '5' => '5',
            '6' => '6',
        ],
    ),
      array(
        'name' => 'arrows',
        'label' => esc_html__('Show Arrows', 'dreamslab'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
    ),
      array(
        'name' => 'arr_style',
        'label' => esc_html__('Arrow Style', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'style-1',
        'options' => [
            'style-1' => esc_html__('Default', 'dreamslab' ),
            'style-2' => esc_html__('Style 2', 'dreamslab' ),
        ],
    ),
      array(
        'name' => 'pagination',
        'label' => esc_html__('Show Pagination', 'dreamslab'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => false,
    ),
      array(
        'name' => 'pagination_type',
        'label' => esc_html__('Pagination Type', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'bullets',
        'options' => [
            'bullets' => 'Bullets',
            'fraction' => 'Fraction',
            'progressbar' => 'Progressbar',
        ],
        'condition' => [
            'pagination' => 'true'
        ]
    ),

      array(
        'name' => 'dot_progressbar_color',
        'label' => esc_html__('Progressbar Color', 'dreamslab' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pxl-swiper-dots.pxl-swiper-pagination-progressbar .swiper-pagination-progressbar-fill' => 'background-color: {{VALUE}};',
        ],
        'condition' => [
            'pagination_type' => 'progressbar'
        ]
    ),

      array(
        'name' => 'pause_on_hover',
        'label' => esc_html__('Pause on Hover', 'dreamslab'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
    ),
      array(
        'name' => 'autoplay',
        'label' => esc_html__('Autoplay', 'dreamslab'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
    ),
      array(
        'name' => 'autoplay_speed',
        'label' => esc_html__('Autoplay Delay', 'dreamslab'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'default' => 5000,
        'condition' => [
            'autoplay' => 'true'
        ]
    ),
      array(
        'name' => 'infinite',
        'label' => esc_html__('Infinite Loop', 'dreamslab'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
    ),
      array(
        'name' => 'speed',
        'label' => esc_html__('Animation Speed', 'dreamslab'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'default' => 500,
    ),
      array(
        'name' => 'drap',
        'label' => esc_html__('Show Scroll Drap', 'dreamslab'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => false,
    ),
  ),
),
dreamslab_widget_animation_settings(),
),
),
),
dreamslab_get_class_widget_path()
);