<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_image',
        'title' => esc_html__('BR Image', 'dreamslab' ),
        'icon' => 'eicon-image icon-brand-elementor',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'tilt',
            'pxl-tweenmax',
            'scroll-magic',
            'pxl-observer',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_content',
                    'label' => esc_html__('Content', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'source_type',
                            'label' => esc_html__('Source Type', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                's_img' => 'Select Image',
                                'f_img' => 'Featured Image',
                            ],
                            'default' => 's_img',
                        ),
                        array(
                            'name' => 'image',
                            'label' => esc_html__('Choose Image', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'source_type' => ['s_img'],
                            ],
                        ),
                        array(
                            'name' => 'image_link',
                            'label' => esc_html__('Link', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::URL,
                        ),
                        array(
                            'name' => 'image_type',
                            'label' => esc_html__('Image Type', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'img' => 'Image',
                                'bg' => 'Background',
                            ],
                            'default' => 'img',
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).',
                            'condition' => [
                                'image_type' => ['img'],
                            ],
                        ),
                        array(
                            'name' => 'image_align',
                            'label' => esc_html__('Image Alignment', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left' => [
                                    'title' => esc_html__('Left', 'dreamslab' ),
                                    'icon' => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__('Center', 'dreamslab' ),
                                    'icon' => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__('Right', 'dreamslab' ),
                                    'icon' => 'fa fa-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single' => 'text-align: {{VALUE}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_style_img',
                    'label' => esc_html__('Image', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'style-im',
                            'label' => esc_html__( 'Style', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [  
                                'df' => esc_html__( 'Default', 'dreamslab' ),
                                'noise' => esc_html__( 'Noise', 'dreamslab' ),
                                'hover-noise' => esc_html__( 'Hover Noise', 'dreamslab' ),
                                'circle' => esc_html__( 'Circle', 'dreamslab' ),
                                'button-scroll' => esc_html__( 'Button Scroll', 'dreamslab' ),
                                'waving-hand' => esc_html__( 'Waving Hand', 'dreamslab' ),
                                'overlay' => esc_html__( 'Overlay', 'dreamslab' ),
                                'canvas' => esc_html__( 'Canvas', 'dreamslab' ),
                            ],
                            'default' => 'df',
                        ),
                        array(
                            'name' => 'w_circle',
                            'label' => esc_html__('Width Circle', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single.circle svg g circle' => 'r: {{SIZE}}; stroke-width: 0.5;',
                            ],
                            'condition' => [
                                'style-im' => ['circle'],
                            ],
                        ),
                        array(
                            'name' => 'w_circle_r',
                            'label' => esc_html__('Right Circle', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single.circle svg' => 'right: {{SIZE}}{{UNIT}};left: auto;transform: translate(0, -50%);',
                            ],
                            'condition' => [
                                'style-im' => ['circle'],
                            ],
                        ),
                        array(
                            'name' => 'overlay_color',
                            'label' => esc_html__( 'Overlay Color', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single.overlay .pxl-item--image:after' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'style-im' => 'overlay',
                            ],
                        ),
                        array(
                            'name' => 'custom_style',
                            'label' => esc_html__( 'Style Animate', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                ''           => esc_html__( 'None', 'dreamslab' ),
                                'pxl-image-ink' => esc_html__('Ink', 'dreamslab' ),
                                'move-from-left'  => esc_html__( 'Move From Left', 'dreamslab' ),
                                'move-from-right' => esc_html__( 'Move From Right', 'dreamslab' ),
                                'pxl-caption-image' => esc_html__( 'Caption Loading', 'dreamslab' ),
                            ],
                        ),
                        array(
                            'name' => 'w_block',
                            'label' => esc_html__('Width Block', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}}.elementor-widget-pxl_image,{{WRAPPER}} .elementor-widget-container,{{WRAPPER}} .pxl-image-single,{{WRAPPER}} .pxl-item--inner,{{WRAPPER}} .pxl-item--image,{{WRAPPER}} .pxl-item--image img' => 'width: {{SIZE}}{{UNIT}} !important;',
                            ],
                            'condition' => [
                                'style-im' => ['noise','hover-noise'],
                            ],
                        ),
                        array(
                            'name' => 'h_block',
                            'label' => esc_html__('Height Block', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}}.elementor-widget-pxl_image,{{WRAPPER}} .elementor-widget-container,{{WRAPPER}} .pxl-image-single,{{WRAPPER}} .pxl-item--inner,{{WRAPPER}} .pxl-item--image,{{WRAPPER}} .pxl-item--image img' => 'height: {{SIZE}}{{UNIT}} !important;',
                            ],
                            'description' => esc_html__('Image Full Height Coloumn.', 'dreamslab' ),
                            'condition' => [
                                'style-im' => ['noise','hover-noise'],
                            ],
                        ),
                        array(
                            'name' => 'w_block_over',
                            'label' => esc_html__('Width Block', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}}.elementor-widget-pxl_image,{{WRAPPER}} .elementor-widget-container,{{WRAPPER}} .pxl-image-single,{{WRAPPER}} .pxl-item--inner,{{WRAPPER}} .pxl-item--image' => 'width: {{SIZE}}{{UNIT}} !important;',
                            ],
                            'condition' => [
                                'img_effect' => ['pxl-parallax-scroll-over'],
                                'style-im!' => ['noise','hover-noise'],
                            ],
                        ),
                        array(
                            'name' => 'h_block_over',
                            'label' => esc_html__('Height Block', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}}.elementor-widget-pxl_image,{{WRAPPER}} .elementor-widget-container,{{WRAPPER}} .pxl-image-single,{{WRAPPER}} .pxl-item--inner,{{WRAPPER}} .pxl-item--image' => 'height: {{SIZE}}{{UNIT}} !important;',
                            ],
                            'description' => esc_html__('Image Full Height Coloumn.', 'dreamslab' ),
                            'condition' => [
                                'img_effect' => ['pxl-parallax-scroll-over'],
                                'style-im!' => ['noise','hover-noise'],
                            ],
                        ),
                        array(
                            'name' => 'image_max_height',
                            'label' => esc_html__('Image Max Height', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'description' => esc_html__('Enter number.', 'dreamslab' ),
                            'condition' => [
                                'image_type' => 'img',
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single img' => 'height: {{SIZE}}{{UNIT}};object-fit: cover;',
                            ],
                            'condition' => [
                                'image_type' => 'img',
                                'img_effect!' => 'pxl-parallax-scroll-over',
                            ],
                        ),
                        array(
                            'name' => 'image_max_height_button',
                            'label' => esc_html__('Image Button Max Height', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'description' => esc_html__('Enter number.', 'dreamslab' ),
                            'condition' => [
                                'image_type' => 'img',
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single' => 'max-height: {{SIZE}}{{UNIT}};overflow: hidden',
                            ],
                            'condition' => [
                                'image_type' => 'img',
                                'style-im' => 'button-scroll',
                            ],
                        ),
                        array(
                            'name' => 'image_max_height_over',
                            'label' => esc_html__('Image Max Height', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'description' => esc_html__('Enter number.', 'dreamslab' ),
                            'condition' => [
                                'image_type' => 'img',
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single' => 'max-height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'image_type' => 'img',
                                'img_effect' => 'pxl-parallax-scroll-over',
                            ],
                        ),
                        array(
                            'name' => 'image_width',
                            'label' => esc_html__('Image Width', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'options' => [
                                'auto' => [
                                    'title' => esc_html__( 'Auto', 'dreamslab' ),
                                    'icon' => 'fas fa-arrows-alt-v',
                                ],
                                '100%' => [
                                    'title' => esc_html__( 'Full', 'dreamslab' ),
                                    'icon' => 'fas fa-arrows-alt-h',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single img' => 'width: {{VALUE}};',
                            ],
                            'condition' => [
                                'image_type' => 'img',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'image_height',
                            'label' => esc_html__('Image Height', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'description' => esc_html__('Enter number.', 'dreamslab' ),
                            'condition' => [
                                'image_type' => 'bg',
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single .pxl-item--bg' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'border_radius',
                            'label' => esc_html__('Border Radius', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single img, {{WRAPPER}} .pxl-item--inner,{{WRAPPER}} .pxl-image-single.pxl-parallax-scroll-over' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};overflow: hidden;',
                            ],
                            'condition' => [
                                'style-im' => 'df',
                            ],
                        ),
                        array(
                            'name' => 'border_radius_noise',
                            'label' => esc_html__('Border Radius', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item--image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};overflow: hidden;',
                            ],
                            'condition' => [
                                'style-im!' => 'df',
                            ],
                        ),
                        array(
                            'name' => 'border_type',
                            'label' => esc_html__( 'Border Type', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => esc_html__( 'None', 'dreamslab' ),
                                'solid' => esc_html__( 'Solid', 'dreamslab' ),
                                'double' => esc_html__( 'Double', 'dreamslab' ),
                                'dotted' => esc_html__( 'Dotted', 'dreamslab' ),
                                'dashed' => esc_html__( 'Dashed', 'dreamslab' ),
                                'groove' => esc_html__( 'Groove', 'dreamslab' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single img' => 'border-style: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'border_width',
                            'label' => esc_html__( 'Border Width', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single img' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'condition' => [
                                'border_type!' => '',
                            ],
                            'responsive' => true,
                        ),
                        array(
                            'name' => 'border_color',
                            'label' => esc_html__( 'Border Color', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single img' => 'border-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'border_type!' => '',
                            ],
                        ),
                        array(
                            'name'         => 'box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'dreamslab' ),
                            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-image-single img'
                        ),
                        array(
                            'name' => 'img_effect',
                            'label' => esc_html__('Image Effect', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => 'None',
                                'pxl-image-effect1' => 'Zigzag',
                                'pxl-image-tilt' => 'Tilt',
                                'pxl-image-spin' => 'Spin',
                                'wow pxl-image-spin2' => 'Spin Border',
                                'pxl-image-zoom' => 'Zoom',
                                'pxl-image-bounce' => 'Bounce',
                                'slide-up-down' => 'Slide Up Down',
                                'slide-top-to-bottom' => 'Slide Top To Bottom ',
                                'pxl-image-effect2' => 'Slide Bottom To Top ',
                                'slide-right-to-left' => 'Slide Right To Left ',
                                'slide-left-to-right' => 'Slide Left To Right ',
                                'pxl-hover1' => 'ZoomIn',
                                'pxl-hover2' => 'ZoomOut',
                                'pxl-animation-round' => 'Round',
                                'pxl-image-parallax' => 'Parallax Hover',
                                'pxl-parallax-scroll' => 'Parallax Scroll',
                                'pxl-parallax-scroll-over' => 'Parallax Scroll Overlow',
                                'pxl-parallax-scroll-scale' => 'Parallax Scroll Scale',
                            ],
                            'default' => '',
                            'condition' => [
                                'image_type' => 'img',
                            ],
                        ),
                        array(
                            'name' => 'parallax_scroll_type',
                            'label' => esc_html__('Parallax Scroll Type', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'y' => 'Effect Y',
                                'x' => 'Effect X',
                                'z' => 'Effect Z',
                            ],
                            'default' => 'y',
                            'condition' => [
                                'img_effect' => ['pxl-parallax-scroll','pxl-parallax-scroll-over'],
                            ],
                        ),
                        array(
                            'name' => 'parallax_scroll_value_x',
                            'label' => esc_html__('Parallax Value', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'img_effect' => ['pxl-parallax-scroll','pxl-parallax-scroll-over','pxl-parallax-scroll-scale'],  
                            ],
                            'default' => '222',
                            'description' => esc_html__('Enter number.', 'dreamslab' ),
                        ),
                        array(
                            'name' => 'parallax_scroll_value_y',
                            'label' => esc_html__('Parallax Y Value', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'img_effect' => ['pxl-parallax-scroll-scale'],  
                            ],
                            'default' => '-123',
                            'description' => esc_html__('Enter number.', 'dreamslab' ),
                        ),
                        array(
                            'name' => 'parallax_scroll_value_scale',
                            'label' => esc_html__('Parallax Scale Value', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'img_effect' => ['pxl-parallax-scroll-scale'],  
                            ],
                            'default' => '80',
                            'description' => esc_html__('Enter number.', 'dreamslab' ),
                        ),
                        array(
                            'name' => 'parallax_value',
                            'label' => esc_html__('Parallax Value', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'img_effect' => 'pxl-image-parallax',
                            ],
                            'default' => '40',
                            'description' => esc_html__('Enter number.', 'dreamslab' ),
                        ),
                        array(
                            'name' => 'max_tilt',
                            'label' => esc_html__('Max Tilt', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'img_effect' => 'pxl-image-tilt',
                            ],
                            'default' => '10',
                            'description' => esc_html__('Enter number.', 'dreamslab' ),
                        ),
                        array(
                            'name' => 'speed_tilt',
                            'label' => esc_html__('Speed Tilt', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'img_effect' => 'pxl-image-tilt',
                            ],
                            'default' => '400',
                            'description' => esc_html__('Enter number.', 'dreamslab' ),
                        ),
                        array(
                            'name' => 'perspective_tilt',
                            'label' => esc_html__('Perspective Tilt', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'img_effect' => 'pxl-image-tilt',
                            ],
                            'default' => '1000',
                            'description' => esc_html__('Enter number.', 'dreamslab' ),
                        ),
                        array(
                            'name' => 'speed_effect',
                            'label' => esc_html__('Speed', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-single, {{WRAPPER}} .pxl-image-single img' => 'animation-duration: {{SIZE}}ms;',
                            ],
                            'condition' => [
                                'img_effect!' => ['pxl-image-tilt','pxl-hover1','pxl-parallax-scroll'],
                            ],
                            'description' => 'Enter number, unit is ms.',
                        ),
                        array(
                            'name' => 'img_display',
                            'label' => esc_html__('Hide on Screen <= 1400px', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'hide_parallax_1200',
                            'label' => esc_html__('Disable Parallax on Tablet <= 1200px', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                            'condition' => [
                                'img_effect' => ['pxl-parallax-scroll-scale'],
                            ],
                        ),
                        array(
                            'name' => 'hide_parallax_sm',
                            'label' => esc_html__('Disable Parallax on Mobile <= 767px', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                            'condition' => [
                                'img_effect' => ['pxl-parallax-scroll'],
                            ],
                        ),
                    ),
),
dreamslab_widget_animation_settings(),
),
),
),
dreamslab_get_class_widget_path()
);