<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_images_slip',
        'title' => esc_html__( 'Case Images Slip', 'dreamslab' ),
        'icon' => 'eicon-tabs icon-brand-elementor',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'dreamslab-tabs'
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dreamslab' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_images_slip/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_images_slip/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'image_content',
                    'label' => esc_html__( 'Images', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'images',
                            'label' => esc_html__('List', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            
                            'controls' => array(
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Image', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                            ),
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                        ),
                        array(
                            'name' => 'gallery_height',
                            'label' => esc_html__( 'Gallery Height', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 569,
                            'condition' => [
                                'layout' => ['1'],
                            ],
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'gallery_width',
                            'label' => esc_html__( 'Gallery Width', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 330,
                            'condition' => [
                                'layout' => ['1'],
                            ],
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'gallery_radius',
                            'label' => esc_html__( 'Gallery Border Radius', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 165,
                            'condition' => [
                                'layout' => ['1'],
                            ],
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'effect_style',
                            'label' => esc_html__('Effect Style', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'df' => 'Default',
                                'style-1' => 'Style 1',
                            ],
                            'default' => 'df',
                        ),   
                        array(
                            'name' => 'btn_border_radius',
                            'label' => esc_html__('Border Radius', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-images-slip .pxl-item--image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'sticky_top',
                            'label' => esc_html__('Top', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px'],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                ],
                            ],
                            'condition' => [
                                'layout' => ['2'],
                            ],
                            'selectors' => [
                             '{{WRAPPER}} .pxl-images-slip .pxl-images--content .pxl-item--content' => 'top: {{SIZE}}{{UNIT}};',
                         ],
                     ),
                        array(
                            'name' => 'gap_height',
                            'label' => esc_html__('Space Image', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px'],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                            ],
                            'selectors' => [
                             '{{WRAPPER}} .pxl-images-slip .pxl-images--content' => 'gap: {{SIZE}}{{UNIT}};',
                         ],
                     ),
                        array(
                            'name' => 'img_height',
                            'label' => esc_html__('Max Height Imgage', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                             '{{WRAPPER}} .pxl-images-slip .pxl-item--image' => 'max-height: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                         ],
                     ),
                    ),
),
),
),
),dreamslab_get_class_widget_path()
);