<?php
$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
$pxl_menus = array(
    '' => esc_html__('Default', 'dreamslab')
);
if ( is_array( $menus ) && ! empty( $menus ) ) {
    foreach ( $menus as $value ) {
        if ( is_object( $value ) && isset( $value->name, $value->slug ) ) {
            $pxl_menus[ $value->slug ] = $value->name;
        }
    }
} else {
    $pxl_menus = '';
}
pxl_add_custom_widget(
    array(
        'name' => 'pxl_menu_hidden_sidebar',
        'title' => esc_html__('BR Menu Hidden Sidebar', 'dreamslab'),
        'icon' => 'eicon-nav-menu icon-brand-elementor',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dreamslab'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'icon_type',
                            'label' => esc_html__('Icon Type', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'df' => 'Default',
                                'style-2' => 'Style 2',
                                'style-3' => 'Style 3',
                            ],
                            'default' => 'df',
                        ),
                        array(
                            'name' => 'text',
                            'label' => esc_html__('Text', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                        ),
                        array(
                            'name' => 'text_color_hv',
                            'label' => esc_html__( 'Text Color', 'dreamslab' ),
                            'type' => \elementor\controls_manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-menu-hidden-sidebar .pxl-menu-button .pxl-anchor--title' => 'color: {{value}};',
                            ],
                        ),
                        array(
                            'name' => 'icon_font_size_w',
                            'label' => esc_html__('Icon Width/Height', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-menu-hidden-sidebar .pxl-menu-button' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'show_image',
                            'label' => esc_html__('Show Image Paralax', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'image',
                            'label' => esc_html__( 'Background', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'show_image' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'image_r',
                            'label' => esc_html__( 'Image', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'sub_title_t',
                            'label' => esc_html__('Sub Title Top', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'title_t',
                            'label' => esc_html__('Title Top', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'btn_text',
                            'label' => esc_html__('Button Text', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'default' => [
                                'url' => '#',
                            ],
                        ),
                        array(
                            'name' => 'menu',
                            'label' => esc_html__('Select Menu', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => $pxl_menus,
                        ),
                        array(
                            'name' => 'lists',
                            'label' => esc_html__('Content Bottom', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'sub_title',
                                    'label' => esc_html__('Sub Title', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'content',
                                    'label' => esc_html__('Content', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'link_list',
                                    'label' => esc_html__('Link', 'dreamslab'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ content }}}',
                        ),
                        array(
                            'name' => 'social',
                            'label' => esc_html__( 'Social', 'dreamslab' ),
                            'type' => 'pxl_icons',
                        ),
                    ),
),
array(
    'name' => 'section_style',
    'label' => esc_html__('Style', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'icon_color',
            'label' => esc_html__('Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-menu-hidden-sidebar .pxl-menu-button .pxl-anchor-divider .pxl-icon-line' => 'background-color: {{VALUE}};',
            ],
        ),  
        array(
            'name' => 'icon_color_hv',
            'label' => esc_html__('Icon Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-menu-hidden-sidebar .pxl-menu-button:hover .pxl-anchor-divider .pxl-icon-line' => 'background-color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'logo_height',
            'label' => esc_html__('Logo Height', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'description' => esc_html__('Enter number.', 'dreamslab' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} .pxl-logo img' => 'max-height: {{SIZE}}{{UNIT}};',
            ],
        ),
        array(
            'name' => 'border_type',
            'label' => esc_html__( 'Border Type', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => esc_html__( 'None', 'dreamslab' ),
                'solid' => esc_html__( 'Solid', 'dreamslab' ),
                'double' => esc_html__( 'Double', 'dreamslab' ),
                'dotted' => esc_html__( 'Dotted', 'dreamslab' ),
                'dashed' => esc_html__( 'Dashed', 'dreamslab' ),
                'groove' => esc_html__( 'Groove', 'dreamslab' ),
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-menu-hidden-sidebar .pxl-menu-button' => 'border-style: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'border_width',
            'label' => esc_html__( 'Border Width', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .pxl-menu-hidden-sidebar .pxl-menu-button' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
            'condition' => [
                'border_type!' => '',
            ],
            'responsive' => true,
        ),
        array(
            'name' => 'border_color',
            'label' => esc_html__( 'Border Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-menu-hidden-sidebar .pxl-menu-button' => 'border-color: {{VALUE}} !important;',
            ],
            'condition' => [
                'border_type!' => '',
            ],
        ),
        array(
            'name' => 'icon_color_bg',
            'label' => esc_html__('Icon Color Background', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-menu-hidden-sidebar .pxl-menu-button' => 'background-color: {{VALUE}};',
            ],
        ),
                array(
            'name' => 'icon_color_bg_hover',
            'label' => esc_html__('Icon Color Background Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-menu-hidden-sidebar .pxl-menu-button:hover' => 'background-color: {{VALUE}};',
            ],
        ),
    ),
),
dreamslab_widget_animation_settings(),
),
),
),
dreamslab_get_class_widget_path()
);