<?php
$pt_supports = ['post','service','portfolio'];
use Elementor\Controls_Manager;
pxl_add_custom_widget(
    array(
        'name'       => 'pxl_post_list',
        'title'      => esc_html__('BR Post List', 'dreamslab' ),
        'icon'       => 'eicon-post-list icon-brand-elementor',
        'categories' => array('pxltheme-core'),
        'scripts'    => [
            'pxl-post-grid',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'dreamslab' ),
                    'tab'      => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'dreamslab' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => dreamslab_get_post_type_options($pt_supports),
                                'default'  => 'post'
                            )
                        ),
                        dreamslab_get_post_list_layout($pt_supports)
                    ),
                ),
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'dreamslab' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'dreamslab' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'dreamslab' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        dreamslab_get_term_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        dreamslab_get_ids_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        dreamslab_get_ids_unselected_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        array(
                            array(
                                'name'    => 'orderby',
                                'label'   => esc_html__('Order By', 'dreamslab' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date'   => esc_html__('Date', 'dreamslab' ),
                                    'ID'     => esc_html__('ID', 'dreamslab' ),
                                    'author' => esc_html__('Author', 'dreamslab' ),
                                    'title'  => esc_html__('Title', 'dreamslab' ),
                                    'rand'   => esc_html__('Random', 'dreamslab' ),
                                ],
                            ),
                            array(
                                'name'    => 'order',
                                'label'   => esc_html__('Sort Order', 'dreamslab' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'dreamslab' ),
                                    'asc'  => esc_html__('Ascending', 'dreamslab' ),
                                ],
                            ),
                            array(
                                'name'    => 'limit',
                                'label'   => esc_html__('Total items', 'dreamslab' ),
                                'type'    => \Elementor\Controls_Manager::NUMBER,
                                'default' => '6',
                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'general_section',
                    'label' => esc_html__('General Settings', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => ['post_type!' => 'portfolio','layout_post!' => ['portfolio-list-2','portfolio-list-3'] ],
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'active',
                                'label' => esc_html__('Active', 'dreamslab' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'separator' => 'after',
                                'default' => '1',
                                'condition' => ['post_type' => 'service','layout_service' => 'service-list-2' ],
                            ),
                            array(
                                'name'    => 'show_toolbar',
                                'label'   => esc_html__('Show Toolbar', 'dreamslab' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'default' => 'hide',
                                'options' => [
                                    'show' => esc_html__('Show', 'dreamslab' ),
                                    'hide'   => esc_html__('Hide', 'dreamslab' )
                                ],
                            ),
                            array(
                                'name' => 'scroll_effect',
                                'label' => esc_html__('Scroll Effects', 'dreamslab' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    'none' => 'None',
                                    'blinds_staggered' => 'Blinds Staggered',
                                    'zoom_in' => 'Zoom In',
                                ],
                                'default' => 'none',
                            ),
                            array(
                                'name'        => 'img_size',
                                'label'       => esc_html__('Image Size', 'dreamslab' ),
                                'type'        => \Elementor\Controls_Manager::TEXT,
                                'description' =>  esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: full).', 'dreamslab')
                            ),
                            array(
                                'name'    => 'pagination_type',
                                'label'   => esc_html__('Pagination Type', 'dreamslab' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'default' => 'false',
                                'options' => [
                                    'pagination' => esc_html__('Pagination', 'dreamslab' ),
                                    'loadmore'   => esc_html__('Loadmore', 'dreamslab' ),
                                    'false'      => esc_html__('Disable', 'dreamslab' ),
                                ],
                            ),
                            array(
                                'name'      => 'loadmore_text',
                                'label'     => esc_html__( 'Load More text', 'dreamslab' ),
                                'type'      => \Elementor\Controls_Manager::TEXT,
                                'default'   => esc_html__('Load More','dreamslab'),
                                'condition' => [
                                    'pagination_type' => 'loadmore'
                                ]
                            ),
                            array(
                                'name'         => 'pagination_alignment',
                                'label'        => esc_html__( 'Pagination Alignment', 'dreamslab' ),
                                'type'         => 'choose',
                                'control_type' => 'responsive',
                                'options' => [
                                    'start' => [
                                        'title' => esc_html__( 'Start', 'dreamslab' ),
                                        'icon'  => 'eicon-text-align-left',
                                    ],
                                    'center' => [
                                        'title' => esc_html__( 'Center', 'dreamslab' ),
                                        'icon'  => 'eicon-text-align-center',
                                    ],
                                    'end' => [
                                        'title' => esc_html__( 'End', 'dreamslab' ),
                                        'icon'  => 'eicon-text-align-right',
                                    ]
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-grid-pagination, {{WRAPPER}} .pxl-load-more' => 'justify-content: {{VALUE}};'
                                ],
                                'default'      => 'start',
                                'condition' => [
                                    'pagination_type' => ['pagination', 'loadmore'],
                                ],
                            ),
                            array(
                                'name' => 'col_xs',
                                'label' => esc_html__('Columns XS Devices', 'dreamslab' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => '1',
                                'options' => [
                                    '1' => '1',
                                    '2' => '2',
                                    '3' => '3',
                                    '4' => '4',
                                    '6' => '6',
                                ],
                            ),
                            array(
                                'name' => 'col_sm',
                                'label' => esc_html__('Columns SM Devices', 'dreamslab' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => '1',
                                'options' => [
                                    '1' => '1',
                                    '2' => '2',
                                    '3' => '3',
                                    '4' => '4',
                                    '6' => '6',
                                ],
                            ),
                            array(
                                'name' => 'col_md',
                                'label' => esc_html__('Columns MD Devices', 'dreamslab' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => '2',
                                'options' => [
                                    '1' => '1',
                                    '2' => '2',
                                    '3' => '3',
                                    '4' => '4',
                                    '6' => '6',
                                ],
                            ),
                            array(
                                'name' => 'col_lg',
                                'label' => esc_html__('Columns LG Devices', 'dreamslab' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => '2',
                                'options' => [
                                    '1' => '1',
                                    '2' => '2',
                                    '3' => '3',
                                    '4' => '4',
                                    '6' => '6',
                                ],
                            ),
                            array(
                                'name' => 'col_xl',
                                'label' => esc_html__('Columns XL Devices', 'dreamslab' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => '2',
                                'options' => [
                                    '1' => '1',
                                    '2' => '2',
                                    '3' => '3',
                                    '4' => '4',
                                    '5' => '5',
                                    '6' => '6',
                                ],
                            ),
                            array(
                                'name' => 'col_xxl',
                                'label' => esc_html__('Columns XXL Devices', 'dreamslab' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'inherit',
                                'options' => [
                                    '1' => '1',
                                    '2' => '2',
                                    '3' => '3',
                                    '4' => '4',
                                    '5' => '5',
                                    '6' => '6',
                                    'inherit' => 'Inherit',
                                ],
                            ),
                            array(
                                'name' => 'item_spacer',
                                'label' => esc_html__('Item Spacer', 'dreamslab' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'description' => 'Default: 15',
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-grid .pxl-grid-item' => 'padding:{{SIZE}}px;',
                                    '{{WRAPPER}} .pxl-grid .pxl-post--inner' => 'margin-bottom:0px;',
                                    '{{WRAPPER}} .pxl-grid .pxl-grid-masonry' => 'margin-left: -{{SIZE}}px;margin-right: -{{SIZE}}px;',
                                ],
                            ),
                        ),
)
),
array(
    'name' => 'display_post_section',
    'label' => esc_html__('Display Options', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    'controls' => array(
        array(
            'name'      => 'post_number',
            'label'     => esc_html__('Show Number', 'dreamslab' ),
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'default'   => 'true',
            'condition' => ['post_type' => 'service','layout_post' => 'service-list-1' ],
        ),
        array(
            'name'      => 'post_date',
            'label'     => esc_html__('Show Date', 'dreamslab' ),
            'condition' => ['post_type' => 'post','layout_post' => 'post-list-1' ],
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'default'   => 'true',
        ),
        array(
            'name'      => 'post_author',
            'label'     => esc_html__('Show Author', 'dreamslab' ),
            'condition' => ['post_type' => 'post','layout_post' => 'post-list-1' ],
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'default'   => 'true',
        ),
        array(
            'name'      => 'post_category',
            'label'     => esc_html__('Show Category', 'dreamslab' ),
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-list-1','post-list-2','post-list-3']]
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-list-4']]
                        ]
                    ],
                    [
                        'terms' => [
                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-list-1','portfolio-list-2','portfolio-list-3']]
                        ]
                    ]
                ],
            ],
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'default'   => 'false',
        ),
        array(
            'name'      => 'post_comment',
            'label'     => esc_html__('Show Comment', 'dreamslab' ),
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'default'   => 'true',
            'condition' => ['post_type' => 'post','layout_post' => 'post-list-1' ],
        ),
        array(
            'name'      => 'post_excerpt',
            'label'     => esc_html__('Show Excerpt', 'dreamslab' ),
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'default'   => 'true',
        ),
        array(
            'name'      => 'post_num_words',
            'label'     => esc_html__('Number of Words', 'dreamslab' ),
            'type'      => \Elementor\Controls_Manager::NUMBER,
            'condition' => [
                'post_excerpt' => 'true',
            ],
        ),
        array(
            'name'      => 'post_readmore',
            'label'     => esc_html__('Show Readmore', 'dreamslab' ),
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'default'   => 'true',
        ),
        array(
            'name'      => 'post_readmore_text',
            'label'     => esc_html__('Button Text', 'dreamslab' ),
            'type'      => \Elementor\Controls_Manager::TEXT,
            'condition' => [
                'post_readmore' => 'true',
            ],
        ),
        array(
            'name'      => 'post_share',
            'label'     => esc_html__('Show Social Share', 'dreamslab' ),
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'default'   => 'true',
            'condition' => ['post_type' => 'post','layout_post' => 'post-list-1' ],
        ),
    ),
),

),
),
),
dreamslab_get_class_widget_path()
);