<?php
// Register Icon Box Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_process',
        'title' => esc_html__('BR Process', 'dreamslab' ),
        'icon' => 'eicon-ellipsis-h icon-brand-elementor',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dreamslab' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_process/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_process/layout2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__('Layout 3', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_process/layout3.jpg'
                                ],
                                '4' => [
                                    'label' => esc_html__('Layout 4', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_process/layout4.jpg'
                                ],
                                '5' => [
                                    'label' => esc_html__('Layout 5', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_process/layout5.jpg'
                                ],
                                '6' => [
                                    'label' => esc_html__('Layout 6', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/pxl_process/layout6.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                        'layout' => ['2','1'],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'image',
                            'label' => esc_html__('Image', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'layout!' => '2',
                            ],
                        ),
                        array(
                            'name' => 'pxl_icon',
                            'label' => esc_html__('Icon', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                            'condition' => [
                                'layout!' => '2',
                            ],
                        ),
                        array(
                            'name' => 'step',
                            'label' => esc_html__('Step', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'condition' => [
                                'layout!' => '2',
                            ],
                        ),
                        array(
                            'name' => 'desc',
                            'label' => esc_html__('Description', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'rows' => 10,
                            'show_label' => false,
                            'condition' => [
                                'layout!' => '2',
                            ],
                        ),
                        array(
                            'name' => 'lists_content',
                            'label' => esc_html__('Content', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => [
                                'layout' => '2',
                            ],
                            'controls' => array(
                                array(
                                    'name' => 'title_c',
                                    'label' => esc_html__('Title', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'desc_c',
                                    'label' => esc_html__('Description', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'rows' => 10,
                                    'show_label' => false,
                                ),
                            ),
                            'title_field' => '{{{ title_c }}}',
                        ),
                        array(
                            'name' => 'lists',
                            'label' => esc_html__('List', 'dreamslab'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'label',
                                    'label' => esc_html__('Title', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'show_label' => false,
                                ),
                            ),
                            'title_field' => '{{{ label }}}',
                        ),
                    ),
),
array(
    'name' => 'section_content2',
    'label' => esc_html__('Content', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    'condition' => [
        'layout' => ['3'],
    ],
    'controls' => array(
        array(
            'name' => 'number_start',
            'label' => esc_html__('Number Start', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'separator' => 'after',
            'default' => '0',
        ),
        array(
            'name' => 'title3',
            'label' => esc_html__('Title', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'label_block' => true,
        ),
        array(
            'name' => 'lists_content3',
            'label' => esc_html__('Content', 'dreamslab'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'controls' => array(
                array(
                    'name' => 'title_c3',
                    'label' => esc_html__('Title', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                ),
                array(
                    'name' => 'desc_c3',
                    'label' => esc_html__('Description', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                    'rows' => 10,
                    'show_label' => false,
                ),
                array(
                    'name' => 'link3',
                    'label' => esc_html__('Link', 'dreamslab'),
                    'type' => \Elementor\Controls_Manager::URL,
                    'label_block' => true,
                ),
            ),
            'title_field' => '{{{ title_c3 }}}',
        ),
    ),
),
array(
    'name' => 'section_content6',
    'label' => esc_html__('Content', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    'condition' => [
        'layout' => ['6'],
    ],
    'controls' => array(
        array(
            'name' => 'lists_content6',
            'label' => esc_html__('Content', 'dreamslab'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'controls' => array(
                array(
                    'name' => 'pxl_icon6',
                    'label' => esc_html__('Icon', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                ),
                array(
                    'name' => 'title_c6',
                    'label' => esc_html__('Title', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                ),
                array(
                    'name' => 'desc_c6',
                    'label' => esc_html__('Description', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                    'rows' => 10,
                    'show_label' => false,
                ),
            ),
            'title_field' => '{{{ title_c6 }}}',
        ),
    ),
),
array(
    'name' => 'section_content5',
    'label' => esc_html__('Content', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    'condition' => [
        'layout' => ['5'],
    ],
    'controls' => array(
        array(
            'name' => 'lists_content5',
            'label' => esc_html__('Content', 'dreamslab'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'controls' => array(
                array(
                    'name' => 'pxl_icon5',
                    'label' => esc_html__('Icon', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                ),
                array(
                    'name' => 'title_c5',
                    'label' => esc_html__('Title', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                ),
                array(
                    'name' => 'desc_c5',
                    'label' => esc_html__('Description', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                    'rows' => 10,
                    'show_label' => false,
                ),
                array(
                    'name' => 'image',
                    'label' => esc_html__('Image', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::MEDIA,
                ),
            ),
            'title_field' => '{{{ title_c5 }}}',
        ),
        array(
            'name' => 'title_c5_last',
            'label' => esc_html__('Title Last', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'label_block' => true,
        ),
        array(
            'name' => 'sub_title_c5_last',
            'label' => esc_html__('SubTitle Last', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'label_block' => true,
        ),
        array(
            'name' => 'btn_c5_last',
            'label' => esc_html__('Button Text', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'label_block' => true,
        ),
        array(
            'name' => 'link5',
            'label' => esc_html__('Link', 'dreamslab'),
            'type' => \Elementor\Controls_Manager::URL,
            'label_block' => true,
        ),
        array(
            'name' => 'lists_content_last5',
            'label' => esc_html__('Image List', 'dreamslab'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'controls' => array(
                array(
                    'name' => 'image_last',
                    'label' => esc_html__('Image Last', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::MEDIA,
                ),
            ),
            'title_field' => '{{{ image_last }}}',
        ),
    ),
),
array(
    'name' => 'section_content3',
    'label' => esc_html__('Content', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    'condition' => [
        'layout' => ['4'],
    ],
    'controls' => array(
        array(
            'name' => 'title4',
            'label' => esc_html__('Title', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'label_block' => true,
        ),
        array(
            'name' => 'lists_content4',
            'label' => esc_html__('Content', 'dreamslab'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'controls' => array(
                array(
                    'name' => 'title_c4',
                    'label' => esc_html__('Title', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                ),
                array(
                    'name' => 'desc_c4',
                    'label' => esc_html__('Description', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                    'rows' => 10,
                    'show_label' => false,
                ),
                array(
                    'name' => 'btn_c4',
                    'label' => esc_html__('Button Text', 'dreamslab' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                ),
                array(
                    'name' => 'link4',
                    'label' => esc_html__('Link', 'dreamslab'),
                    'type' => \Elementor\Controls_Manager::URL,
                    'label_block' => true,
                ),
            ),
            'title_field' => '{{{ title_c4 }}}',
        ),
    ),
),

array(
    'name' => 'section_style_ge',
    'label' => esc_html__('General', 'dreamslab'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'style',
            'label' => esc_html__('Style', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style-default' => 'Default',
                'style-2' => 'Style 2',
            ],
            'default' => 'style-default',
        ),
        array(
            'name' => 'bd_color',
            'label' => esc_html__('Border Bottom Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-process .pxl-item--inner' => 'border-color: {{VALUE}} ;',
            ],
        ),
        array(
            'name' => 'border_type',
            'label' => esc_html__( 'Border Type', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'condition' => [
                'layout' => ['3'],
            ],
            'options' => [
                '' => esc_html__( 'None', 'dreamslab' ),
                'solid' => esc_html__( 'Solid', 'dreamslab' ),
                'double' => esc_html__( 'Double', 'dreamslab' ),
                'dotted' => esc_html__( 'Dotted', 'dreamslab' ),
                'dashed' => esc_html__( 'Dashed', 'dreamslab' ),
                'groove' => esc_html__( 'Groove', 'dreamslab' ),
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-process .pxl-item--inner' => 'border-style: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'border_width',
            'label' => esc_html__( 'Border Width', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .pxl-process .pxl-item--inner' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
            'condition' => [
                'border_type!' => '',
            ],
            'responsive' => true,
        ),
        array(
            'name' => 'border_color',
            'label' => esc_html__( 'Border Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-process .pxl-item--inner' => 'border-color: {{VALUE}} !important;',
            ],
            'condition' => [
                'border_type!' => '',
            ],
        ),
    ),
),
array(
    'name' => 'section_style_title',
    'label' => esc_html__('Title', 'dreamslab'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'pd_box',
            'label' => esc_html__('Padding Box', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
                '{{WRAPPER}} .pxl-process .pxl-item--inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'control_type' => 'responsive',
        ),
        array(
            'name' => 'title_tag',
            'label' => esc_html__('HTML Tag', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'h1' => 'H1',
                'h2' => 'H2',
                'h3' => 'H3',
                'h4' => 'H4',
                'h5' => 'H5',
                'h6' => 'H6',
                'div' => 'div',
                'span' => 'span',
                'p' => 'p',
            ],
            'default' => 'h5',
        ),
        array(
            'name' => 'title_color',
            'label' => esc_html__('Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-process .pxl-item--title' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_typography',
            'label' => esc_html__('Typography', 'dreamslab' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-process .pxl-item--title',
        ),
        array(
            'name' => 'title_top_spacer',
            'label' => esc_html__('Top Spacer', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-process .pxl-item--title' => 'margin-top: {{SIZE}}{{UNIT}} !important;',
            ],
        ),
        array(
            'name' => 'title_bottom_spacer',
            'label' => esc_html__('Bottom Spacer', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-process .pxl-item--title' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
            ],
        ),
    ),
),
array(
    'name' => 'section_style_desc',
    'label' => esc_html__('Description', 'dreamslab'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'desc_color',
            'label' => esc_html__('Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-process .pxl-item--description' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'desc_typography',
            'label' => esc_html__('Typography', 'dreamslab' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-process .pxl-item--description',
        ),
    ),
),
array(
    'name' => 'section_style_list',
    'label' => esc_html__('List', 'dreamslab'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'list_color',
            'label' => esc_html__('Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-process .pxl--item' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'list_typography',
            'label' => esc_html__('Typography', 'dreamslab' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-process .pxl--item',
        ),
    ),
),
dreamslab_widget_animation_settings(),
),
),
),dreamslab_get_class_widget_path()
);