<?php
$templates = dreamslab_get_templates_option('tab', []) ;
pxl_add_custom_widget(
    array(
        'name' => 'pxl_tabs',
        'title' => esc_html__( 'Case Tabs', 'dreamslab' ),
        'icon' => 'eicon-tabs icon-brand-elementor',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'dreamslab-tabs'
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dreamslab' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_tabs/layout-image/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_tabs/layout-image/layout2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__('Layout 3', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_tabs/layout-image/layout3.jpg'
                                ],
                                '4' => [
                                    'label' => esc_html__('Layout 4', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_tabs/layout-image/layout4.jpg'
                                ],
                                '5' => [
                                    'label' => esc_html__('Layout 5', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_tabs/layout-image/layout5.jpg'
                                ],
                                '6' => [
                                    'label' => esc_html__('Layout 6', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_tabs/layout-image/layout6.jpg'
                                ],
                                '7' => [
                                    'label' => esc_html__('Layout 7', 'dreamslab' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_tabs/layout-image/layout7.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_content',
                    'label' => esc_html__( 'Tabs', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name'      => 'tab1_text',
                            'label'     => esc_html__('Tab 1 Text', 'dreamslab'),
                            'type'      => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'layout' => ['7'],
                            ],
                            'separator' => 'before'
                        ),
                        array(
                            'name' => 'content_template_tab_1',
                            'label' => esc_html__('Select Template Tab 1', 'dreamslab'),
                            'type' => 'select',
                            'options' => $templates,
                            'default' => 'df',
                            'description' => 'Add new tab template: "<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '" target="_blank">Click Here</a>" and Edit template "<a href="' . esc_url( admin_url( 'edit.php?s&post_status=all&post_type=pxl-template&action=-1&m=0&pxl_filter_template_type=tab&filter_action=Filter&paged=1&action2=-1' ) ) . '" target="_blank">Here.</a>"',
                            'condition' => ['layout' => '7'],
                            'separator' => 'after'
                        ),
                        array(
                            'name'      => 'tab2_text',
                            'label'     => esc_html__('Tab 2 Text', 'dreamslab'),
                            'type'      => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'layout' => ['7'],
                            ],
                        ),
                        array(
                            'name' => 'content_template_tab_2',
                            'label' => esc_html__('Select Template Tab 2', 'dreamslab'),
                            'type' => 'select',
                            'options' => $templates,
                            'default' => 'df',
                            'description' => 'Add new tab template: "<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '" target="_blank">Click Here</a>" and Edit template "<a href="' . esc_url( admin_url( 'edit.php?s&post_status=all&post_type=pxl-template&action=-1&m=0&pxl_filter_template_type=tab&filter_action=Filter&paged=1&action2=-1' ) ) . '" target="_blank">Here.</a>"',
                            'condition' => ['layout' => '7'],
                            'separator' => 'after'
                        ),
                        array(
                            'name' => 'subtitle_box',
                            'label' => esc_html__(' Sub Title Box', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Text', 'dreamslab'),
                            'condition' => ['layout' => '5'], 
                        ),
                        array(
                            'name' => 'title_box',
                            'label' => esc_html__('Title Box', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'default' => esc_html__('Text', 'dreamslab'),
                            'condition' => ['layout' => '5'], 
                        ),
                        array(
                            'name' => 'desc_box',
                            'label' => esc_html__('Description Box', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'default' => esc_html__('Text', 'dreamslab'),
                            'condition' => ['layout' => '5'],
                        ),
                        array(
                            'name' => 'tab_active',
                            'label' => esc_html__( 'Active Tab', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 1,
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'title_button_color',
                            'label' => esc_html__( 'Color Button Title', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'condition' => ['layout!' => ['7']],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-tabs .pxl-tabs--title > .pxl-item--title' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_button_color_at',
                            'label' => esc_html__( 'Color Button Title Active', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'condition' => ['layout!' => ['7']],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-tabs .pxl-tabs--title > .pxl-item--title.active' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'tabs',
                            'label' => esc_html__( 'Content', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => ['layout!' => ['2','7']],
                            'controls' => array(
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__( 'Title', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'content_type',
                                    'label' => esc_html__('Content Type', 'dreamslab'),
                                    'type' => 'select',
                                    'options' => [
                                        'df' => esc_html__( 'Default', 'dreamslab' ),
                                        'template' => esc_html__( 'From Template Builder', 'dreamslab' )
                                    ],
                                    'default' => 'df' 
                                ),
                                array(
                                    'name' => 'desc',
                                    'label' => esc_html__( 'Content', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::WYSIWYG,
                                    'condition' => ['content_type' => 'df'] 
                                ),
                                array(
                                    'name' => 'content_template',
                                    'label' => esc_html__('Select Templates', 'dreamslab'),
                                    'type' => 'select',
                                    'options' => $templates,
                                    'default' => 'df',
                                    'description' => 'Add new tab template: "<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '" target="_blank">Click Here</a>"',
                                    'condition' => ['content_type' => 'template'] 
                                ),
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                    'condition' => ['content_type' => 'template'] 
                                ),
                            ),
                            'title_field' => '{{{ title }}}',
                        ),
                        array(
                            'name' => 'tabs2',
                            'label' => esc_html__( 'Content', 'dreamslab' ),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => ['layout' => '2'],
                            'controls' => array(
                                array(
                                    'name' => 'title2',
                                    'label' => esc_html__( 'Title', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'desc2',
                                    'label' => esc_html__( 'Content', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::WYSIWYG,
                                ),
                                array(
                                    'name' => 'pxl_icon2',
                                    'label' => esc_html__('Icon', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                ),
                                array(
                                    'name' => 'btn_text',
                                    'label' => esc_html__( 'Button Text', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'dreamslab' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'default' => [
                                        'url' => '#',
                                    ],
                                ),
                            ),
                            'title_field' => '{{{ title2 }}}',
                        ),
                    ),
),
array(
    'name' => 'section_subtitle_b',
    'label' => esc_html__('SubTitle Box', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'condition' => ['layout' => '5'], 
    'controls' => array_merge(
        array(
            array(
                'name' => 'subtitle_color',
                'label' => esc_html__('Color', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-tabs5 .wrap-content-title .subtitle-box' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 'subtitle_typography',
                'label' => esc_html__('Typography', 'dreamslab' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-tabs5 .wrap-content-title .subtitle-box',
            ),
        )
    ),
),
array(
    'name' => 'section_title_b',
    'label' => esc_html__('Title Box', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'condition' => ['layout' => '5'], 
    'controls' => array_merge(
        array(
            array(
                'name' => 'title_b_color',
                'label' => esc_html__(' Color', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-tabs5 .wrap-content-title .title-box' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 'titleb_typography',
                'label' => esc_html__('Typography', 'dreamslab' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-tabs5 .wrap-content-title .title-box',
            ),
        )
    ),
),
array(
    'name' => 'section_style_desc_bpx',
    'label' => esc_html__('Description Box', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'condition' => ['layout' => '5'], 
    'controls' => array_merge(
        array(
            array(
                'name' => 'des_color',
                'label' => esc_html__('Color', 'dreamslab' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pxl-tabs5 .wrap-content-title .desc-box' => 'color: {{VALUE}};',
                ],
            ),
            array(
                'name' => 'des_typography',
                'label' => esc_html__('Typography', 'dreamslab' ),
                'type' => \Elementor\Group_Control_Typography::get_type(),
                'control_type' => 'group',
                'selector' => '{{WRAPPER}} .pxl-tabs5 .wrap-content-title .desc-box',
            ),
        )
    ),
),
array(
    'name' => 'tab_style',
    'label' => esc_html__( 'Style', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'style',
            'label' => esc_html__('Style', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style-default' => 'Default',
                'style-2' => 'Style 2',
            ],
            'default' => 'style-default',
        ),
        array(
            'name' => 'title_space',
            'label' => esc_html__('Space Title', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-tabs .pxl-tabs--title ' => 'column-gap: {{SIZE}}{{UNIT}} ;',
            ],
        ),
        array(
            'name' => 'right_space',
            'label' => esc_html__('Space Right Content', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-tabs--content ' => 'right: {{SIZE}}{{UNIT}} ;',
            ],
        ),
        array(
            'name' => 'top_space',
            'label' => esc_html__('Space Top Content', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .pxl-tabs--content ' => 'top: {{SIZE}}{{UNIT}} ;',
            ],
        ),
        array(
            'name' => 'tab_effect',
            'label' => esc_html__('Effect', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'tab-effect-slide' => 'Slide',
                'tab-effect-fade' => 'Fade',
            ],
            'default' => 'tab-effect-slide',
        ),
        array(
            'name' => 'title_color',
            'label' => esc_html__('Title Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-tabs .pxl-tabs--title > .pxl-item--title' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_active_color',
            'label' => esc_html__('Title Active Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-tabs .pxl-tabs--title > .pxl-item--title.active' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_box_color_w',
            'label' => esc_html__('Title Box Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-tabs .pxl-tabs--title > .pxl-tabs--title' => 'background-color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'btn_color',
            'label' => esc_html__('Background Button Color Active', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-tabs .pxl-tabs--title > .pxl-item--title.active' => 'background-color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'dreamslab' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-tabs .pxl-tabs--title > .pxl-item--title',
            'separator' => 'after',
        ),
        array(
            'name' => 'content_color',
            'label' => esc_html__('Content Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-tabs .pxl-item--content' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'content_typography',
            'label' => esc_html__('Content Typography', 'dreamslab' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-tabs .pxl-item--content',
        ),
    ),
),
dreamslab_widget_animation_settings(),
),
),
),
dreamslab_get_class_widget_path()
);