<?php
// Register Text Editor
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
pxl_add_custom_widget(
    array(
        'name' => 'pxl_text_editor',
        'title' => esc_html__('BR Text Editor', 'dreamslab'),
        'icon' => 'eicon-text icon-brand-elementor ',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Text Editor', 'dreamslab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                       array(
                        'name' => 'h_title_style',
                        'label' => esc_html__('Style', 'dreamslab' ),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'options' => [
                            'style-default' => esc_html__( 'Default', 'dreamslab' ),
                            'pxl-caption-description'  => esc_html__( 'Caption Loading', 'dreamslab' ),
                        ],
                        'default' => 'style-default',
                    ),
                       array(
                        'name' => 'text_ed',
                        'label' => '',
                        'type' => Controls_Manager::WYSIWYG,
                        'default' => esc_html__( 'Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'dreamslab' ),
                        'description' => 'Create Highlight text width shortcode: [pxl_highlight text="Text Demo"], Create Underline text width shortcode: [pxl_underline text="Text Demo"]',
                    ),
                       array(
                          'name' => 'align',
                          'label' => esc_html__( 'Alignment', 'dreamslab' ),
                          'type' => \Elementor\Controls_Manager::CHOOSE,
                          'control_type' => 'responsive',
                          'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'dreamslab' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'dreamslab' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'dreamslab' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                            'justify' => [
                                'title' => esc_html__( 'Justified', 'dreamslab' ),
                                'icon' => 'eicon-text-align-justify',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-text-editor' => 'text-align: {{VALUE}};',
                        ],
                    ),
                       array(
                        'name' => 't_width',
                        'label' => esc_html__('Max Width', 'dreamslab' ),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'control_type' => 'responsive',
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 3000,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-text-editor .pxl-item--inner' => 'max-width: {{SIZE}}{{UNIT}};',
                        ],
                    ),
                       array(
                        'name' => 't_space',
                        'label' => esc_html__('Space', 'dreamslab' ),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'control_type' => 'responsive',
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .pxl-text-editor .pxl-item--inner p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ),
                       dreamslab_split_text_option(),
                       array(
                        'name' => 'duration_slit',
                        'label' => esc_html__( 'Duration', 'dreamslab' ),
                        'type' => \Elementor\Controls_Manager::NUMBER,
                        'default' => 1,
                        'separator' => 'after',
                    ),
                   ),
),
array(
    'name' => 'section_style_text',
    'label' => esc_html__( 'Text', 'dreamslab' ),
    'tab' => Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'text_color',
            'label' => esc_html__( 'Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor , {{WRAPPER}} .pxl-text-editor p' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'text_typography',
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'label' => esc_html__( 'Typography', 'dreamslab' ),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-text-editor , {{WRAPPER}} .pxl-text-editor p',
        ),
        array(
            'name' => 'custom_font',
            'label' => esc_html__('Custom Font Family', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                '' => 'Default',
                'ft-gt' => 'Clash Display',
            ],
            'default' => '',
        ),
    ),
),
array(
    'name' => 'section_style_quote',
    'label' => esc_html__( 'Block Quote', 'dreamslab' ),
    'tab' => Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'textb_color',
            'label' => esc_html__( 'Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor blockquote, {{WRAPPER}} .pxl-text-editor blockquote p' => 'color: {{VALUE}} !important;',
            ],
        ),
        array(
            'name' => 'textb_typography',
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'label' => esc_html__( 'Typography', 'dreamslab' ),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-text-editor blockquote, {{WRAPPER}} .pxl-text-editor blockquote p',
        ),
    ),
),
array(
    'name' => 'section_style_link',
    'label' => esc_html__( 'Link', 'dreamslab' ),
    'tab' => Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'link_color',
            'label' => esc_html__( 'Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor a' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'link_color_hover',
            'label' => esc_html__( 'Color Hover', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor a:hover' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'link_typography',
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'label' => esc_html__( 'Typography', 'dreamslab' ),
            'selector' => '{{WRAPPER}} .pxl-text-editor a',
            'control_type' => 'group',
        ),
    ),
),
array(
    'name' => 'section_style_title_highlight',
    'label' => esc_html__('Highlight', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'highlight_color',
            'label' => esc_html__('Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor .pxl-text--highlight' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'highlight_box_color',
            'label' => esc_html__('Box Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor .pxl-text--highlight' => 'background-color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'highlight_typography',
            'label' => esc_html__('Typography', 'dreamslab' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-text-editor .pxl-text--highlight',
        ),
    ),
),
array(
    'name' => 'section_style_title_underline',
    'label' => esc_html__('Underline', 'dreamslab' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'controls' => array(
        array(
            'name' => 'underline_color',
            'label' => esc_html__('Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor .pxl-text--underline' => 'color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'underline_box_color',
            'label' => esc_html__('Line Color', 'dreamslab' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .pxl-text-editor .pxl-text--underline:after' => 'background-color: {{VALUE}};',
            ],
        ),
        array(
            'name' => 'underline_typography',
            'label' => esc_html__('Typography', 'dreamslab' ),
            'type' => \Elementor\Group_Control_Typography::get_type(),
            'control_type' => 'group',
            'selector' => '{{WRAPPER}} .pxl-text-editor .pxl-text--underline',
        ),
    ),
),
dreamslab_widget_animation_settings(),
),
),
),
dreamslab_get_class_widget_path()
);