<?php if(!function_exists('dreamslab_configs')){
    function dreamslab_configs($value){
        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'dreamslab'), 
                    'value' => dreamslab()->get_opt('primary_color', '#121c27')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'dreamslab'), 
                    'value' => dreamslab()->get_opt('secondary_color', '#030303')
                ],
                'third'   => [
                    'title' => esc_html__('Third', 'dreamslab'), 
                    'value' => dreamslab()->get_opt('third_color', '#c2c2c2')
                ],
                'four'   => [
                    'title' => esc_html__('Four', 'dreamslab'), 
                    'value' => dreamslab()->get_opt('four_color', '#fff')
                ],
                'body_bg'   => [
                    'title' => esc_html__('Body Background Color', 'dreamslab'), 
                    'value' => dreamslab()->get_opt('body_bg_color', '#030303')
                ]
            ],
            'link' => [
                'color' => dreamslab()->get_opt('link_color', ['regular' => '#fff'])['regular'],
                'color-hover'   => dreamslab()->get_opt('link_color', ['hover' => '#fff'])['hover'],
                'color-active'  => dreamslab()->get_opt('link_color', ['active' => '#fff'])['active'],
            ],
        ];
        return $configs[$value];
    }
}
if(!function_exists('dreamslab_inline_styles')) {
    function dreamslab_inline_styles() {  

        $theme_colors      = dreamslab_configs('theme_colors');
        $link_color        = dreamslab_configs('link');
        //$gradient_color    = dreamslab_configs('gradient');
        ob_start();
        echo ':root{';

        foreach ($theme_colors as $color => $value) {
            printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
        }
        foreach ($theme_colors as $color => $value) {
            printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  dreamslab_hex_rgb($value['value']));
        }
        foreach ($link_color as $color => $value) {
            printf('--link-%1$s: %2$s;', $color, $value);
        }
            // foreach ($gradient_color as $color => $value) {
            //     printf('--gradient-%1$s: %2$s;', $color, $value);
            //}
        echo '}';

        return ob_get_clean();

    }
}
