<?php

add_action( 'pxl_post_metabox_register', 'dreamslab_page_options_register' );
function dreamslab_page_options_register( $metabox ) {

	$panels = [
		'post' => [
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post settings', 'dreamslab' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'post_settings' => [
					'title'  => esc_html__( 'Post settings', 'dreamslab' ),
					'icon'   => 'el el-refresh',
					'fields' => array_merge(
						dreamslab_sidebar_pos_opts(['prefix' => 'post_', 'default' => true, 'default_value' => '-1']),
						dreamslab_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						dreamslab_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'           => 'custom_main_title',
								'type'         => 'text',
								'title'        => esc_html__( 'Custom Main Title', 'dreamslab' ),
								'subtitle'     => esc_html__( 'custom heading text title', 'dreamslab' ),
								'required' => array( 'pt_mode', '!=', 'none' )
							),
							array(
								'id'      => 'custom_ptitle_desc',
								'type'    => 'textarea',
								'title'   => esc_html__('Page Title Description', 'dreamslab'),
								'default' => 'description details',
								'required' => array( 'pt_mode', '!=', 'none' )
							),
						),
						array(
							array(
								'id'          => 'featured-video-url',
								'type'        => 'text',
								'title'       => esc_html__( 'Video url', 'dreamslab' ),
								'description' => esc_html__( 'video will show when set post format is video', 'dreamslab' ),
								'validate'    => 'url',
								'msg'         => 'url error!',
							),
							array(
								'id'          => 'featured-audio-url',
								'type'        => 'text',
								'title'       => esc_html__( 'Audio url', 'dreamslab' ),
								'description' => esc_html__( 'audio that will show when set post format is audio', 'dreamslab' ),
								'validate'    => 'url',
								'msg'         => 'url error!',
							),
							array(
								'id'=>'featured-quote-text',
								'type' => 'textarea',
								'title' => esc_html__('Quote text', 'dreamslab'),
								'default' => '',
							),
							array(
								'id'          => 'featured-quote-cite',
								'type'        => 'text',
								'title'       => esc_html__( 'Quote cite', 'dreamslab' ),
								'description' => esc_html__( 'Quote will show when set post format is quote', 'dreamslab' ),
							),
							array(
								'id'       => 'featured-link-url',
								'type'     => 'text',
								'title'    => esc_html__( 'Format link url', 'dreamslab' ),
								'description' => esc_html__( 'Link will show when set post format is link', 'dreamslab' ),
							),
							array(
								'id'          => 'featured-link-text',
								'type'        => 'text',
								'title'       => esc_html__( 'Format link text', 'dreamslab' ),
							),
						)
					)
				]
			]
		],
		'page' => [
			'opt_name'            => 'pxl_page_options',
			'display_name'        => esc_html__( 'Page options', 'dreamslab' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'dreamslab' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						dreamslab_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						dreamslab_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'header_display',
								'type'     => 'button_set',
								'title'    => esc_html__('Header display', 'dreamslab'),
								'options'  => array(
									'show' => esc_html__('show', 'dreamslab'),
									'hide'  => esc_html__('hide', 'dreamslab'),
								),
								'default'  => 'show',
							),
							array(
								'id'       => 'logo_m',
								'type'     => 'media',
								'title'    => esc_html__('Mobile logo', 'dreamslab'),
								'default'  => '',
								'url'      => false,
							),
							array(
								'id'       => 'p_menu',
								'type'     => 'select',
								'title'    => esc_html__( 'Menu', 'dreamslab' ),
								'options'  => dreamslab_get_nav_menu_slug(),
								'default' => '',
							),
						),
						array(
							array(
								'id'       => 'sticky_scroll',
								'type'     => 'button_set',
								'title'    => esc_html__('Sticky scroll', 'dreamslab'),
								'options'  => array(
									'-1' => esc_html__('inherit', 'dreamslab'),
									'pxl-sticky-stt' => esc_html__('scroll to top', 'dreamslab'),
									'pxl-sticky-stb'  => esc_html__('scroll to bottom', 'dreamslab'),
								),
								'default'  => '-1',
							),
							array(
								'id'       => 'header_margin',
								'type'     => 'spacing',
								'mode'     => 'margin',
								'title'    => esc_html__('margin', 'dreamslab'),
								'width'    => false,
								'unit'     => 'px',
								'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
							),
						)
					)

				],
				'page_title' => [
					'title'  => esc_html__( 'Page title', 'dreamslab' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
						dreamslab_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'sg_post_title',
								'type'     => 'button_set',
								'title'    => esc_html__('Page title type', 'dreamslab'),
								'options'  => array(
									'default' => esc_html__('default', 'dreamslab'),
									'custom_text' => esc_html__('custom text', 'dreamslab'),
								),
								'default'  => 'default',
							),
							array(
								'id'      => 'custom_main_title',
								'type'    => 'text',
								'title'   => esc_html__('Page title text', 'dreamslab'),								
								'required' => array( 0 => 'sg_post_title', 1 => 'equals', 2 => 'custom_text' ),
							),
							array(
								'id'      => 'custom_ptitle_desc',
								'type'    => 'textarea',
								'title'   => esc_html__('Description title text', 'dreamslab'),								
								'required' => array( 0 => 'sg_post_title', 1 => 'equals', 2 => 'custom_text' ),
							),
						),
					)
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'dreamslab' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						dreamslab_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing top/bottom', 'dreamslab' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
							array(
								'id'           => 'loading_page',
								'type'         => 'button_set',
								'title'        => esc_html__( 'Loading', 'dreamslab' ),
								'options'      => array(
									'-1'  	   => esc_html__( 'Inherit', 'dreamslab' ),
									'bd' 	   => esc_html__( 'Custom', 'dreamslab' ),
								),
								'default'      => '-1',
							),
							array(
								'id'           => 'full_page',
								'title'        => esc_html__( 'Full Screen', 'dreamslab' ),
								'type'     => 'switch',
								'default'      => false,
							),
							array(
								'id'    => 'loader_style',
								'type'  => 'select',
								'title' => esc_html__('Loader Style', 'dreamslab'),
								'subtitle' => esc_html__('ㅤ', 'dreamslab'),
								'options' => [
									'style-text'           => esc_html__('Text', 'dreamslab'),
									'style-logo'     => esc_html__('Logo', 'dreamslab'),
									'style-overlay'     => esc_html__('Overlay', 'dreamslab'),
								],
								'default' => 'style-text',
								'indent' => true,
								'required' => array( 0 => 'loading_page', 1 => 'equals', 2 => 'bd' ),
							),
							array(
								'id'             => 'loading_text',
								'type'           => 'text',
								'title'          => esc_html__('Loading Text', 'dreamslab'),
								'default'        => '',
								'desc'           => esc_html__('Enter the text displayed on load.', 'dreamslab'),
								'required'       => array( 0 => 'loader_style', 1 => 'equals', 2 => array('style-text', 'style-text-blend') ),
								'force_output'   => true
							),
							array(
								'id'       => 'loader_logo',
								'type'     => 'media',
								'title'    => esc_html__('logo', 'dreamslab'),
								'url'      => false,
								'required' => array( 0 => 'loader_style', 1 => 'equals', 2 => array('loader_style', 'style-overlay') ),
							),
						)
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'dreamslab' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						dreamslab_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'footer_display',
								'type'     => 'button_set',
								'title'    => esc_html__('Footer display', 'dreamslab'),
								'options'  => array(
									'show' => esc_html__('show', 'dreamslab'),
									'hide'  => esc_html__('hide', 'dreamslab'),
								),
								'default'  => 'show',
							),
							array(
								'id'       => 'p_footer_fixed',
								'type'     => 'button_set',
								'title'    => esc_html__('Footer fixed', 'dreamslab'),
								'options'  => array(
									'inherit' => esc_html__('inherit', 'dreamslab'),
									'on' => esc_html__('on', 'dreamslab'),
									'off' => esc_html__('off', 'dreamslab'),
								),
								'default'  => 'inherit',
							),
							array(
								'id'       => 'back_top_top_style',
								'type'     => 'button_set',
								'title'    => esc_html__('Back to top style', 'dreamslab'),
								'options'  => array(
									'style-default' => esc_html__('default', 'dreamslab'),
									'style-round' => esc_html__('round', 'dreamslab'),
								),
								'default'  => 'style-default',
							),
						)
					)
				],
				'colors' => [
					'title'  => esc_html__( 'Colors', 'dreamslab' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						array(
							array(
								'id'       => 'content_bgp_color',
								'type'     => 'color_rgba',
								'title'    => esc_html__('Body background color', 'dreamslab'),
								'subtitle' => esc_html__('body background color.', 'dreamslab'),
								'output'   => array('background-color' => 'body')
							),
							array(
								'id'          => 'primary_color',
								'type'        => 'color',
								'title'       => esc_html__('Primary color', 'dreamslab'),
								'transparent' => false,
								'default'     => ''
							),
						)
					)
				],
				'extra' => [
					'title'  => esc_html__( 'Extra', 'dreamslab' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						array(
							array(
								'id' => 'body_custom_class',
								'type' => 'text',
								'title' => esc_html__('Body custom class', 'dreamslab'),
							),
						)
					)
				]
			]
		],
		'portfolio' => [
			'opt_name'            => 'pxl_portfolio_options',
			'display_name'        => esc_html__( 'Portfolio options', 'dreamslab' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header1' => [
					'title'  => esc_html__( 'Header', 'dreamslab' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						dreamslab_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						dreamslab_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'bg_section_color',
								'type'     => 'text',
								'title'    => esc_html__('Background color', 'dreamslab'),
								'default'  => '#f1efeb',
							),
							array(
								'id'       => 'header_display',
								'type'     => 'button_set',
								'title'    => esc_html__('Header display', 'dreamslab'),
								'options'  => array(
									'show' => esc_html__('show', 'dreamslab'),
									'hide'  => esc_html__('hide', 'dreamslab'),
								),
								'default'  => 'show',
							),
							array(
								'id'       => 'logo_m',
								'type'     => 'media',
								'title'    => esc_html__('Mobile logo', 'dreamslab'),
								'default'  => '',
								'url'      => false,
							),
							array(
								'id'       => 'p_menu',
								'type'     => 'select',
								'title'    => esc_html__( 'Menu', 'dreamslab' ),
								'options'  => dreamslab_get_nav_menu_slug(),
								'default' => '',
							),
						),
						array(
							array(
								'id'       => 'sticky_scroll',
								'type'     => 'button_set',
								'title'    => esc_html__('Sticky scroll', 'dreamslab'),
								'options'  => array(
									'-1' => esc_html__('inherit', 'dreamslab'),
									'pxl-sticky-stt' => esc_html__('scroll to top', 'dreamslab'),
									'pxl-sticky-stb'  => esc_html__('scroll to bottom', 'dreamslab'),
								),
								'default'  => '-1',
							),
							array(
								'id'       => 'header_margin',
								'type'     => 'spacing',
								'mode'     => 'margin',
								'title'    => esc_html__('margin', 'dreamslab'),
								'width'    => false,
								'unit'     => 'px',
								'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
							),
						)
					)

				],
				'page_title' => [
					'title'  => esc_html__( 'Page title', 'dreamslab' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
						dreamslab_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'sg_post_title',
								'type'     => 'button_set',
								'title'    => esc_html__('Page title type', 'dreamslab'),
								'options'  => array(
									'default' => esc_html__('default', 'dreamslab'),
									'custom_text' => esc_html__('custom text', 'dreamslab'),
								),
								'default'  => 'default',
							),
							array(
								'id'      => 'custom_main_title',
								'type'    => 'text',
								'title'   => esc_html__('Page title text', 'dreamslab'),								
								'required' => array( 0 => 'sg_post_title', 1 => 'equals', 2 => 'custom_text' ),
							),
							array(
								'id'      => 'custom_ptitle_desc',
								'type'    => 'textarea',
								'title'   => esc_html__('Description title text', 'dreamslab'),								
								'required' => array( 0 => 'sg_post_title', 1 => 'equals', 2 => 'custom_text' ),
							),
						),
					)
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'dreamslab' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						dreamslab_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing top/bottom', 'dreamslab' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
						),
						array(
							array(
								'id'=>'multi_text_country',
								'type' => 'multi_text',
								'title' => ('multi text option'),
								'title'    => esc_html('mutil text', 'dreamslab'),
							),
							array(
								'id'=>'multi_text_country_link',
								'type' => 'multi_text',
								'title' => ('multi text option'),
								'title'    => esc_html('mutil text link', 'dreamslab'),
							),
							array(
								'id'       => 'icon_multi_text',
								'type'     => 'pxl_iconpicker',
								'title'    => esc_html__('icon multi text', 'dreamslab'),
								'force_output' => true
							),
						),
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'dreamslab' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						dreamslab_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'footer_display',
								'type'     => 'button_set',
								'title'    => esc_html__('Footer display', 'dreamslab'),
								'options'  => array(
									'show' => esc_html__('show', 'dreamslab'),
									'hide'  => esc_html__('hide', 'dreamslab'),
								),
								'default'  => 'show',
							),
							array(
								'id'       => 'p_footer_fixed',
								'type'     => 'button_set',
								'title'    => esc_html__('Footer fixed', 'dreamslab'),
								'options'  => array(
									'inherit' => esc_html__('inherit', 'dreamslab'),
									'on' => esc_html__('on', 'dreamslab'),
									'off' => esc_html__('off', 'dreamslab'),
								),
								'default'  => 'inherit',
							),
							array(
								'id'       => 'back_top_top_style',
								'type'     => 'button_set',
								'title'    => esc_html__('Back to top style', 'dreamslab'),
								'options'  => array(
									'style-default' => esc_html__('default', 'dreamslab'),
									'style-round' => esc_html__('round', 'dreamslab'),
								),
								'default'  => 'style-default',
							),
						)
					)
				],
			]
		],
		'product' => [
			'opt_name'            => 'pxl_product_options',
			'display_name'        => esc_html__( 'Product options', 'dreamslab' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header1' => [
					'title'  => esc_html__( 'Header', 'dreamslab' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						dreamslab_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						dreamslab_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'header_display',
								'type'     => 'button_set',
								'title'    => esc_html__('Header display', 'dreamslab'),
								'options'  => array(
									'show' => esc_html__('show', 'dreamslab'),
									'hide'  => esc_html__('hide', 'dreamslab'),
								),
								'default'  => 'show',
							),
							array(
								'id'       => 'logo_m',
								'type'     => 'media',
								'title'    => esc_html__('Mobile logo', 'dreamslab'),
								'default'  => '',
								'url'      => false,
							),
							array(
								'id'       => 'p_menu',
								'type'     => 'select',
								'title'    => esc_html__( 'menu', 'dreamslab' ),
								'options'  => dreamslab_get_nav_menu_slug(),
								'default' => '',
							),
						),
						array(
							array(
								'id'       => 'sticky_scroll',
								'type'     => 'button_set',
								'title'    => esc_html__('Sticky scroll', 'dreamslab'),
								'options'  => array(
									'-1' => esc_html__('inherit', 'dreamslab'),
									'pxl-sticky-stt' => esc_html__('scroll to top', 'dreamslab'),
									'pxl-sticky-stb'  => esc_html__('scroll to bottom', 'dreamslab'),
								),
								'default'  => '-1',
							),
							array(
								'id'       => 'header_margin',
								'type'     => 'spacing',
								'mode'     => 'margin',
								'title'    => esc_html__('margin', 'dreamslab'),
								'width'    => false,
								'unit'     => 'px',
								'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
							),
						)
					)

				],
				'page_title' => [
					'title'  => esc_html__( 'Page title', 'dreamslab' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
						dreamslab_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
					)
				],
				'content' => [
					'title'  => esc_html__( 'content', 'dreamslab' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						dreamslab_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing top/bottom', 'dreamslab' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
						)
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'dreamslab' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						dreamslab_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
					)
				],
			]
		],
		'service' => [
			'opt_name'            => 'pxl_service_options',
			'display_name'        => esc_html__( 'Service options', 'dreamslab' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'dreamslab' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
								'id'=> 'service_external_link',
								'type' => 'text',
								'title' => esc_html__('External link', 'dreamslab'),
								'validate' => 'url',
								'default' => '',
							),
							array(
								'id'       => 'service_icon_type',
								'type'     => 'button_set',
								'title'    => esc_html__('icon type', 'dreamslab'),
								'options'  => array(
									'icon'  => esc_html__('icon', 'dreamslab'),
									'image'  => esc_html__('image', 'dreamslab'),
								),
								'default'  => 'icon'
							),
							array(
								'id'       => 'service_icon_font',
								'type'     => 'pxl_iconpicker',
								'title'    => esc_html__('icon', 'dreamslab'),
								'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'icon' ),
								'force_output' => true
							),
							array(
								'id'       => 'service_icon_img',
								'type'     => 'media',
								'title'    => esc_html__('icon image', 'dreamslab'),
								'default' => '',
								'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'image' ),
								'force_output' => true
							),
						)
					)
				],
				'header1' => [
					'title'  => esc_html__( 'Header', 'dreamslab' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						dreamslab_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						dreamslab_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'header_display',
								'type'     => 'button_set',
								'title'    => esc_html__('Header display', 'dreamslab'),
								'options'  => array(
									'show' => esc_html__('show', 'dreamslab'),
									'hide'  => esc_html__('hide', 'dreamslab'),
								),
								'default'  => 'show',
							),
							array(
								'id'       => 'logo_m',
								'type'     => 'media',
								'title'    => esc_html__('Mobile logo', 'dreamslab'),
								'default'  => '',
								'url'      => false,
							),
							array(
								'id'       => 'p_menu',
								'type'     => 'select',
								'title'    => esc_html__( 'menu', 'dreamslab' ),
								'options'  => dreamslab_get_nav_menu_slug(),
								'default' => '',
							),
						),
						array(
							array(
								'id'       => 'sticky_scroll',
								'type'     => 'button_set',
								'title'    => esc_html__('Sticky scroll', 'dreamslab'),
								'options'  => array(
									'-1' => esc_html__('inherit', 'dreamslab'),
									'pxl-sticky-stt' => esc_html__('scroll to top', 'dreamslab'),
									'pxl-sticky-stb'  => esc_html__('scroll to bottom', 'dreamslab'),
								),
								'default'  => '-1',
							),
							array(
								'id'       => 'header_margin',
								'type'     => 'spacing',
								'mode'     => 'margin',
								'title'    => esc_html__('margin', 'dreamslab'),
								'width'    => false,
								'unit'     => 'px',
								'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
							),
						)
					)

				],
				'page_title' => [
					'title'  => esc_html__( 'Page title', 'dreamslab' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
						dreamslab_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
					)
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'dreamslab' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						dreamslab_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing top/bottom', 'dreamslab' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
						),
						array(
							array(
								'id'=>'service_title',
								'type' => 'text',
								'title'    => esc_html('Service title', 'dreamslab'),
							),
						),
						array(
							array(
								'id'=>'multi_text_country',
								'type' => 'multi_text',
								'title' => ('Multi text option'),
								'title'    => esc_html('mutil text', 'dreamslab'),
							),
							array(
								'id'=>'multi_text_country_link',
								'type' => 'multi_text',
								'title' => ('multi text option'),
								'title'    => esc_html('mutil text link', 'dreamslab'),
							),
							array(
								'id'       => 'icon_multi_text',
								'type'     => 'pxl_iconpicker',
								'title'    => esc_html__('icon multi text', 'dreamslab'),
								'force_output' => true
							),
						),
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'dreamslab' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						dreamslab_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'footer_display',
								'type'     => 'button_set',
								'title'    => esc_html__('Footer display', 'dreamslab'),
								'options'  => array(
									'show' => esc_html__('show', 'dreamslab'),
									'hide'  => esc_html__('hide', 'dreamslab'),
								),
								'default'  => 'show',
							),
							array(
								'id'       => 'p_footer_fixed',
								'type'     => 'button_set',
								'title'    => esc_html__('Footer fixed', 'dreamslab'),
								'options'  => array(
									'inherit' => esc_html__('inherit', 'dreamslab'),
									'on' => esc_html__('on', 'dreamslab'),
									'off' => esc_html__('off', 'dreamslab'),
								),
								'default'  => 'inherit',
							),
							array(
								'id'       => 'back_top_top_style',
								'type'     => 'button_set',
								'title'    => esc_html__('Back to top style', 'dreamslab'),
								'options'  => array(
									'style-default' => esc_html__('default', 'dreamslab'),
									'style-round' => esc_html__('round', 'dreamslab'),
								),
								'default'  => 'style-default',
							),
						)
					)
				],
			]
		],

		'pxl-template' => [ //post_type
		'opt_name'            => 'pxl_hidden_template_options',
		'display_name'        => esc_html__( 'Template options', 'dreamslab' ),
		'show_options_object' => false,
		'context'  => 'advanced',
		'priority' => 'default',
		'sections'  => [
			'header' => [
				'title'  => esc_html__( 'General', 'dreamslab' ),
				'icon'   => 'el-icon-website',
				'fields' => array(
					array(
						'id'    => 'template_type',
						'type'  => 'select',
						'title' => esc_html__('Type', 'dreamslab'),
						'options' => [
							'df'       	   => esc_html__('Select type', 'dreamslab'), 
							'header'       => esc_html__('Header desktop', 'dreamslab'),
							'header-mobile'       => esc_html__('Header mobile', 'dreamslab'),
							'footer'       => esc_html__('Footer', 'dreamslab'), 
							'mega-menu'    => esc_html__('Mega menu', 'dreamslab'), 
							'page-title'   => esc_html__('Page title', 'dreamslab'), 
							'tab' => esc_html__('Tab', 'dreamslab'),
							'hidden-panel' => esc_html__('Hidden panel', 'dreamslab'),
							'popup' => esc_html__('Popup', 'dreamslab'),
							'widget' => esc_html__('Widget sidebar', 'dreamslab'),
							'page' => esc_html__('Page', 'dreamslab'),
							'slider' => esc_html__('Slider', 'dreamslab'),
						],
						'default' => 'df',
					),
					array(
						'id'       => 'close_popup_display',
						'type'     => 'button_set',
						'title'    => esc_html__('Close Popup Display', 'dreamslab'),
						'options'  => array(
							'show' => esc_html__('Show', 'dreamslab'),
							'hide'  => esc_html__('Hide', 'dreamslab'),
						),
						'default'  => 'show',
						'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'popup' ),
					),
					array(
						'id'    => 'header_type',
						'type'  => 'select',
						'title' => esc_html__('Header Type', 'dreamslab'),
						'options' => [
							'px-header--default'       	   => esc_html__('Default', 'dreamslab'), 
							'px-header--transparent'       => esc_html__('Transparent', 'dreamslab'),
							'px-header--left_sidebar'       => esc_html__('Left Sidebar', 'dreamslab'),
						],
						'default' => 'px-header--default',
						'indent' => true,
						'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header' ),
					),

					array(
						'id'    => 'header_mobile_type',
						'type'  => 'select',
						'title' => esc_html__('Header type', 'dreamslab'),
						'options' => [
							'px-header--default'       	   => esc_html__('Default', 'dreamslab'), 
							'px-header--transparent'       => esc_html__('Transparent', 'dreamslab'),
						],
						'default' => 'px-header--default',
						'indent' => true,
						'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header-mobile' ),
					),

					array(
						'id'    => 'hidden_panel_position',
						'type'  => 'select',
						'title' => esc_html__('Hidden Panel Position', 'dreamslab'),
						'options' => [
							'top'       	   => esc_html__('Top', 'dreamslab'),
							'right'       	   => esc_html__('Right', 'dreamslab'),
							'right-ab'       	   => esc_html__('Right Absolute', 'dreamslab'),
						],
						'default' => 'right',
						'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
					),
					array(
						'id'          => 'hidden_panel_top',
						'type'        => 'text',
						'title'       => esc_html__('Hidden Panel Top', 'dreamslab'),
						'subtitle'       => esc_html__('Enter number.', 'dreamslab'),
						'transparent' => false,
						'default'     => '',
						'force_output' => true,
						'required' => array( 0 => 'hidden_panel_position', 1 => 'equals', 2 => 'right' ),
					),
					array(
						'id'          => 'hidden_panel_top_ab',
						'type'        => 'text',
						'title'       => esc_html__('Hidden Panel Top', 'dreamslab'),
						'subtitle'       => esc_html__('Enter number.', 'dreamslab'),
						'transparent' => false,
						'default'     => '',
						'force_output' => true,
						'required' => array( 0 => 'hidden_panel_position', 1 => 'equals', 2 => 'right-ab' ),
					),
					array(
						'id'          => 'hidden_panel_height',
						'type'        => 'text',
						'title'       => esc_html__('Hidden Panel Height', 'dreamslab'),
						'subtitle'       => esc_html__('Enter number.', 'dreamslab'),
						'transparent' => false,
						'default'     => '',
						'force_output' => true,
						'required' => array( 0 => 'hidden_panel_position', 1 => 'equals', 2 => 'top' ),
					),
					array(
						'id'          => 'hidden_panel_boxcolor',
						'type'        => 'color',
						'title'       => esc_html__('Box Color', 'dreamslab'),
						'transparent' => false,
						'default'     => '',
						'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
					),

					array(
						'id'          => 'header_sidebar_width',
						'type'        => 'slider',
						'title'       => esc_html__('Header Sidebar Width', 'dreamslab'),
						"default"   => 300,
						"min"       => 50,
						"step"      => 1,
						"max"       => 900,
						'force_output' => true,
						'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'px-header--left_sidebar' ),
					),

					array(
						'id'          => 'header_sidebar_border',
						'type'        => 'border',
						'title'       => esc_html__('Header Sidebar Border', 'dreamslab'),
						'force_output' => true,
						'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'px-header--left_sidebar' ),
						'default' => '',
					),
				),

],
]
],
];

$metabox->add_meta_data( $panels );
}
