<?php
class Custom_Menu_Walker extends Walker_Nav_Menu {
    protected function get_child_count($parent_id, $menu_id) {
        $menu_items = wp_get_nav_menu_items($menu_id);
        $count = 0;
        foreach ($menu_items as $item) {
            if ((int) $item->menu_item_parent === (int) $parent_id) {
                $count++;
            }
        }
        return $count;
    }

    public function start_el(&$output, $item, $depth = 0, $args = [], $id = 0) {
        $classes = empty($item->classes) ? [] : (array) $item->classes;
        $has_children = in_array('menu-item-has-children', $classes);

        $title = $item->title;

        if ($has_children && $depth === 0 && isset($args->menu)) {
            $child_count = $this->get_child_count($item->ID, $args->menu->term_id);
            $title .= ' (' . $child_count . ')';
        }

        $output .= '<li class="' . esc_attr(implode(' ', $classes)) . '">';
        $output .= '<a href="' . esc_url($item->url) . '">';
        $output .= '<span class="pxl-menu-item-text">' . esc_html($title) . '</span>';
        $output .= '</a>';
    }
}
