<?php

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

require_once( 'functions.php' );

global $months;
global $status;

$prefix              = esc_attr( get_option( 'fslm_prefix', '' ) );
$chunks_number       = esc_attr( get_option( 'fslm_chunks_number', '4' ) );
$chunks_length       = esc_attr( get_option( 'fslm_chunks_length', '4' ) );
$suffix              = esc_attr( get_option( 'fslm_suffix', '' ) );
$max_instance_number = esc_attr( get_option( 'fslm_max_instance_number', '1' ) );
$valid               = esc_attr( get_option( 'fslm_valid', '0' ) );
$active              = esc_attr( get_option( 'fslm_active', '0' ) );

?>
<div class="wrap fslm">

	<h1><?php echo __( 'Add Generator Rule', 'fslm' ); ?></h1>

	<div class="postbox">
		<div class="inside">

			<form id="licenseForm" action="<?php echo admin_url( 'admin.php?action=add_rule' ) ?>" method="post">


				<div class="input-box">
					<div class="label">
						<span><?php echo __( 'Product or Variation', 'fslm' ); ?></span>
					</div>
					<div class="input">
						<select class="input-field" id="product_id_select">
							<?php

							global $wpdb;

							// Retrieve all products
							$products = $wpdb->get_results( $wpdb->prepare( "SELECT ID, post_title FROM {$wpdb->posts} WHERE post_type = %s AND post_status != 'auto-draft'", "product" ), ARRAY_A );

							// Retrieve all product variations
							$variations = $wpdb->get_results( $wpdb->prepare( "SELECT ID, post_title, post_parent FROM {$wpdb->posts} WHERE post_type = %s AND post_status != 'auto-draft'", "product_variation" ), ARRAY_A );

							// Create an array to track products with variations
							$products_with_variations = array_column( $variations, 'post_parent' );

							// Display products without variations
							foreach ( $products as $product ) {
								if ( ! in_array( $product['ID'], $products_with_variations ) ) {
									echo '<option value="product_' . $product['ID'] . '">' . $product['ID'] . ' - ' . $product['post_title'] . '</option>';
								}
							}

							// Display variations
							foreach ( $variations as $variation ) {
								if ( $variation['post_title'] != "" ) {
									echo '<option value="variation_' . $variation['ID'] . '_' . $variation['post_parent'] . '">' . $variation['ID'] . ' - ' . $variation['post_title'] . '</option>';
								}
							}

							?>
						</select>
					</div>
				</div>

				<!-- Hidden inputs to hold product and variation IDs -->
				<input type="hidden" id="product_id" name="product_id" value="">
				<input type="hidden" id="variation_id" name="variation_id" value="">

				<div class="input-box">
					<div class="label">
						<span><?php echo __( 'Prefix', 'fslm' ); ?></span>
					</div>
					<div class="input">
						<input class="input-field" name="prefix" id="prefix" type="text" value="<?php echo $prefix ?>">
					</div>
				</div>

				<div class="input-box">
					<div class="label">
						<span><?php echo __( 'Number of chunks', 'fslm' ); ?></span>
					</div>
					<div class="input">
						<input class="input-field" name="chunks_number" id="chunks_number" type="number" min="1"
						       value="<?php echo $chunks_number ?>">
					</div>
				</div>

				<div class="input-box">
					<div class="label">
						<span><?php echo __( 'Chunk length', 'fslm' ); ?></span>
					</div>
					<div class="input">
						<input class="input-field" name="chunks_length" id="chunks_length" type="number" min="1"
						       value="<?php echo $chunks_length ?>">
					</div>
				</div>

				<div class="input-box">
					<div class="label">
						<span><?php echo __( 'Suffix', 'fslm' ); ?></span>
					</div>
					<div class="input">
						<input class="input-field" name="suffix" id="suffix" type="text" value="<?php echo $suffix ?>">
					</div>
				</div>

				<div class="input-box">
					<div class="label">
						<span><?php echo __( 'Maximum Activations', 'fslm' ); ?></span>
					</div>
					<div class="input">
						<input class="input-field" name="max_instance_number" id="max_instance_number" type="number"
						       min="1" value="<?php echo $max_instance_number ?>">
						<div class="helper">?
							<div class="tip">
								<?php echo __( 'Requires the implementation for the Tracking API, Ignore this field if your product is untraceable(the Tracking API is designed for software products, themes... digital products in general)', 'fslm' ); ?>
							</div>
						</div>
					</div>

				</div>

				<div class="input-box">
					<div class="label">
						<span><?php echo __( 'Validity (Days)', 'fslm' ); ?></span>
					</div>
					<div class="input">
						<input class="input-field" name="valid" id="valid" type="number" min="0"
						       value="<?php echo $valid ?>">
						<div class="helper">?
							<div class="tip">
								<?php echo __( 'Number of <b>Days</b> before the license key expires<br>Expiration date will be calculated based on this value after purchase completed, keep <b>Expiration Date</b> fields empty if you want to use this option<br><b>Set to 0 if your product doesn\'t expire</b>', 'fslm' ); ?>
							</div>
						</div>
					</div>

				</div>


				<div class="input-box">
					<div class="label">
						<span><?php echo __( 'Active', 'fslm' ); ?></span>
					</div>
					<div class="input">
						<select class="input-field" name="active">
							<option
								value="0" <?php echo $active == 0 ? 'selected' : '' ?>><?php echo __( 'No', 'fslm' ); ?></option>
							<option
								value="1" <?php echo $active == 1 ? 'selected' : '' ?>><?php echo __( 'Yes', 'fslm' ); ?></option>
						</select>
						<div class="helper">?
							<div class="tip">
								<?php echo __( 'No license key will be generated if this option is set to <b>No</b>', 'fslm' ); ?>
							</div>
						</div>
					</div>

				</div>


				<p class="submit">
					<input name="save" id="save-license-key" class="button button-primary"
					       value="<?php echo __( 'Add Generator Rule', 'fslm' ); ?>" type="submit">
					<br class="clear">
				</p>

			</form>
		</div>
	</div>
</div>

<script>
    document.getElementById('licenseForm').addEventListener('submit', function (event) {
        var select = document.getElementById('product_id_select');
        var selectedValue = select.value;
        var productIdInput = document.getElementById('product_id');
        var variationIdInput = document.getElementById('variation_id');

        if (selectedValue.startsWith('product_')) {
            var productId = selectedValue.split('_')[1];
            productIdInput.value = productId;
            variationIdInput.value = '';
        } else if (selectedValue.startsWith('variation_')) {
            var parts = selectedValue.split('_');
            var variationId = parts[1];
            var productId = parts[2];
            variationIdInput.value = variationId;
            productIdInput.value = productId;
        }
    });
</script>