<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

global $wpdb;

$query = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}wc_fs_product_licenses_keys_generator_rules WHERE rule_id='" . (int) $_GET['rule_id'] . "'" );

if ( $query ) {

	$query = $query[0];


	$rule_id             = $query->rule_id;
	$product_id          = $query->product_id;
	$variation_id        = $query->variation_id;
	$prefix              = $query->prefix;
	$chunks_number       = $query->chunks_number;
	$chunks_length       = $query->chunks_length;
	$suffix              = $query->suffix;
	$max_instance_number = $query->max_instance_number;
	$valid               = $query->valid;


	$active = $query->active;


	?>
	<div class="wrap fslm">

		<h1><?php echo __( 'Edit Generator Rule', 'fslm' ); ?></h1>

		<div class="postbox">
			<div class="inside">

				<form id="licenseForm" action="<?php echo admin_url( 'admin.php?action=edit_rule' ) ?>" method="post">

					<input name="rule_id" type="hidden" value="<?php echo $rule_id ?>">

					<div class="input-box">
						<div class="label">
							<span><?php echo __('Product or Variation', 'fslm'); ?></span>
						</div>
						<div class="input">
							<select class="input-field" id="product_id_select">
								<?php

								global $wpdb;

								// Retrieve all products
								$products = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title FROM {$wpdb->posts} WHERE post_type = %s AND post_status != 'auto-draft'", "product"), ARRAY_A);

								// Retrieve all product variations
								$variations = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title, post_parent FROM {$wpdb->posts} WHERE post_type = %s AND post_status != 'auto-draft'", "product_variation"), ARRAY_A);

								// Create an array to track products with variations
								$products_with_variations = array_column($variations, 'post_parent');

								// Display products without variations
								foreach ($products as $product) {
									if (!in_array($product['ID'], $products_with_variations)) {
										$selected = ( $product['ID'] == $product_id ) ? 'selected' : '';
										echo '<option ' . $selected . ' value="product_' . $product['ID'] . '">' . $product['ID'] . ' - ' . $product['post_title'] . '</option>';
									}
								}

								// Display variations
								foreach ($variations as $variation) {
									if ($variation['post_title'] != "") {
										$selected = ( $variation['ID'] == $variation_id ) ? 'selected' : '';
										echo '<option ' . $selected . ' value="variation_' . $variation['ID'] . '_' . $variation['post_parent'] . '">' . $variation['ID'] . ' - ' . $variation['post_title'] . '</option>';
									}
								}

								?>
							</select>
						</div>
					</div>

					<!-- Hidden inputs to hold product and variation IDs -->
					<input type="hidden" id="product_id" name="product_id" value="">
					<input type="hidden" id="variation_id" name="variation_id" value="">

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Prefix', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="prefix" id="prefix" type="text"
							       value="<?php echo $prefix ?>">
						</div>
					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Number of chunks', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="chunks_number" id="chunks_number" type="text"
							       value="<?php echo $chunks_number ?>">
						</div>
					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Chunk length', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="chunks_length" id="chunks_length" type="text"
							       value="<?php echo $chunks_length ?>">
						</div>
					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Suffix', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="suffix" id="suffix" type="text"
							       value="<?php echo $suffix ?>">
						</div>
					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Activations', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="max_instance_number" id="max_instance_number" type="number"
							       value="<?php echo $max_instance_number ?>">
						</div>
					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Validity (Days)', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="valid" id="valid" type="number"
							       value="<?php echo $valid ?>">
						</div>
					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Active', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<select class="input-field" name="active">

								<?php

								$noSelected  = $active == '0' ? 'selected' : '';
								$yesSelected = $active == '1' ? 'selected' : '';

								?>

								<option value="0" <?php echo $noSelected ?>><?php echo __( 'No', 'fslm' ); ?></option>
								<option value="1" <?php echo $yesSelected ?>><?php echo __( 'Yes', 'fslm' ); ?></option>
							</select>
						</div>
					</div>


					<p class="submit">
						<input name="save" id="save-license-key" class="button button-primary"
						       value="<?php echo __( 'Edit Generator Rule', 'fslm' ); ?>" type="submit">
						<br class="clear">
					</p>

				</form>
			</div>
		</div>
	</div>

	<script>
        document.getElementById('licenseForm').addEventListener('submit', function (event) {
            var select = document.getElementById('product_id_select');
            var selectedValue = select.value;
            var productIdInput = document.getElementById('product_id');
            var variationIdInput = document.getElementById('variation_id');

            if (selectedValue.startsWith('product_')) {
                var productId = selectedValue.split('_')[1];
                productIdInput.value = productId;
                variationIdInput.value = '';
            } else if (selectedValue.startsWith('variation_')) {
                var parts = selectedValue.split('_');
                var variationId = parts[1];
                var productId = parts[2];
                variationIdInput.value = variationId;
                productIdInput.value = productId;
            }
        });
	</script>

<?php } ?>
                            
