<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

require_once( 'functions.php' );

global $months;
global $status;
?>

<div class="wrap fslm">

	<h1><?php echo __( 'Import License Manager Data & Settings', 'fslm' ); ?></h1>

	<div class="postbox">
		<div class="inside">
			<div id="wclm_bulk_add_from_textarea_form" class="elko">
				<h3><?php echo __( 'Bulk Add License Keys', 'fslm' ); ?></h3>
				<form method="post" action="<?php echo admin_url( 'admin-ajax.php' ) ?>">

					<input type="hidden" name="action" value="wclm_bulk_add_from_textarea">

					<div class="input-box">
						<p class="tip"><?php echo __( 'Each line will be added as a license key', 'fslm' ); ?></p>
						<div class="label">
							<span><?php echo __( 'License Keys', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<textarea class="input-field" name="license_keys"></textarea>
						</div>
					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Product or Variation', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<select class="input-field" id="wclm_baft_product_id_select">
								<?php

								global $wpdb;

								// Retrieve all products
								$products = $wpdb->get_results( $wpdb->prepare( "SELECT ID, post_title FROM {$wpdb->posts} WHERE post_type = %s AND post_status != 'auto-draft'", "product" ), ARRAY_A );

								// Retrieve all product variations
								$variations = $wpdb->get_results( $wpdb->prepare( "SELECT ID, post_title, post_parent FROM {$wpdb->posts} WHERE post_type = %s AND post_status != 'auto-draft'", "product_variation" ), ARRAY_A );

								// Create an array to track products with variations
								$products_with_variations = array_column( $variations, 'post_parent' );

								// Display products without variations
								foreach ( $products as $product ) {
									if ( ! in_array( $product['ID'], $products_with_variations ) ) {
										echo '<option value="product_' . $product['ID'] . '">' . $product['ID'] . ' - ' . $product['post_title'] . '</option>';
									}
								}

								// Display variations
								foreach ( $variations as $variation ) {
									if ( $variation['post_title'] != "" ) {
										echo '<option value="variation_' . $variation['ID'] . '_' . $variation['post_parent'] . '">' . $variation['ID'] . ' - ' . $variation['post_title'] . '</option>';
									}
								}

								?>
							</select>
						</div>
					</div>

					<!-- Hidden inputs to hold product and variation IDs -->
					<input type="hidden" id="wclm_baft_product_id" name="product_id" value="">
					<input type="hidden" id="wclm_baft_variation_id" name="variation_id" value="">


					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Number Of Times To Deliver This Key', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="deliver_x_times" id="deliver_x_times" type="number" min="1"
							       value="1">
							<div class="helper">?
								<div class="tip">
									<?php echo __( 'The status will only change to sold after the key is sold the number of times in the input above', 'fslm' ); ?>
								</div>
							</div>
						</div>

					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Maximum Activations', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="max_instance_number" id="max_instance_number" type="number"
							       min="0" value="0">
							<div class="helper">?
								<div class="tip">
									<?php echo __( 'Requires the implementation for the Tracking API, Ignore this field if your product is untraceable(the Tracking API is designed for software products, themes... digital products in general)', 'fslm' ); ?>
								</div>
							</div>
						</div>

					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Expiration Date', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<div class="timestamp-wrap">
								<select class="date" id="month" name="mm">
									<option value=""></option>
									<?php
									foreach ( $months as $month ) {
										echo '<option value="' . $month['number'] . '" data-text="' . __( $month['text'], 'fslm' ) . '">' . $month['number'] . '-' . __( $month['text'], 'fslm' ) . '</option>';
									}
									?>
								</select>

								<input class="date" id="day" name="dd" maxlength="2" type="number"
								       placeholder="<?php _e( 'Day', 'fslm' ); ?>" min="1" max="31">

								<input class="date" id="year" name="yy" size="4" maxlength="4" type="text"
								       placeholder="<?php _e( 'Year', 'fslm' ); ?>">
							</div>
							<div class="helper">?
								<div class="tip">
									<?php echo __( 'Keep Expiration Date fields empty if your product doesn\'t expire', 'fslm' ); ?>
								</div>
							</div>
						</div>

					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Validity (Days)', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="valid" id="valid" type="number" min="0" value="0">
							<div class="helper">?
								<div class="tip">
									<?php echo __( 'Number of <b>Days</b> before the license key expires<br>Expiration date will be calculated based on this value after purchase completed, keep <b>Expiration Date</b> fields empty if you want to use this option<br><b>Set to 0 if your product doesn\'t expire</b>', 'fslm' ); ?>
								</div>
							</div>
						</div>

					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Status', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<select class="input-field" name="license_status">
								<?php
								foreach ( $status as $key => $statu ) {
									echo '<option value="' . strtolower( $key ) . '">' . __( $statu, 'fslm' ) . '</option>';
								}
								?>
							</select>
						</div>
					</div>

					<p class="submit mb">
						<input name="save" class="button button-primary"
						       value="<?php echo __( 'Import License Keys', 'fslm' ); ?>" type="submit">
						<br class="clear">
					</p>
				</form>
			</div>


			<div class="elko">
				<h3><?php echo __( 'Import License Keys From .txt File', 'fslm' ); ?></h3>
				<form id="wclm_import_license_keys" method="post" action="<?php echo admin_url( 'admin-ajax.php' ) ?>" enctype="multipart/form-data">

					<input type="hidden" name="action" value="fslm_import_lko">

					<div class="input-box">
						<p class="tip"><?php echo __( 'A text file that contains license keys only one key in each line', 'fslm' ); ?></p>
						<div class="label">
							<span><?php echo __( 'CSV File', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="ilk_source_file" type="file" accept=".txt,.csv">
						</div>
					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Product or Variation', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<select class="input-field" id="wclm_ilk_product_id_select">
								<?php

								global $wpdb;

								// Retrieve all products
								$products = $wpdb->get_results( $wpdb->prepare( "SELECT ID, post_title FROM {$wpdb->posts} WHERE post_type = %s AND post_status != 'auto-draft'", "product" ), ARRAY_A );

								// Retrieve all product variations
								$variations = $wpdb->get_results( $wpdb->prepare( "SELECT ID, post_title, post_parent FROM {$wpdb->posts} WHERE post_type = %s AND post_status != 'auto-draft'", "product_variation" ), ARRAY_A );

								// Create an array to track products with variations
								$products_with_variations = array_column( $variations, 'post_parent' );

								// Display products without variations
								foreach ( $products as $product ) {
									if ( ! in_array( $product['ID'], $products_with_variations ) ) {
										echo '<option value="product_' . $product['ID'] . '">' . $product['ID'] . ' - ' . $product['post_title'] . '</option>';
									}
								}

								// Display variations
								foreach ( $variations as $variation ) {
									if ( $variation['post_title'] != "" ) {
										echo '<option value="variation_' . $variation['ID'] . '_' . $variation['post_parent'] . '">' . $variation['ID'] . ' - ' . $variation['post_title'] . '</option>';
									}
								}

								?>
							</select>
						</div>
					</div>

					<!-- Hidden inputs to hold product and variation IDs -->
					<input type="hidden" id="wclm_ilk_product_id" name="product_id" value="">
					<input type="hidden" id="wclm_ilk_variation_id" name="variation_id" value="">


					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Number Of Times To Deliver This Key', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="deliver_x_times" id="deliver_x_times" type="number" min="1"
							       value="1">
							<div class="helper">?
								<div class="tip">
									<?php echo __( 'The status will only change to sold after the key is sold the number of times in the input above', 'fslm' ); ?>
								</div>
							</div>
						</div>

					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Maximum Activations', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="max_instance_number" id="max_instance_number" type="number"
							       min="0" value="0">
							<div class="helper">?
								<div class="tip">
									<?php echo __( 'Requires the implementation for the Tracking API, Ignore this field if your product is untraceable(the Tracking API is designed for software products, themes... digital products in general)', 'fslm' ); ?>
								</div>
							</div>
						</div>

					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Expiration Date', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<div class="timestamp-wrap">
								<select class="date" id="month" name="mm">
									<option value=""></option>
									<?php
									foreach ( $months as $month ) {
										echo '<option value="' . $month['number'] . '" data-text="' . __( $month['text'], 'fslm' ) . '">' . $month['number'] . '-' . __( $month['text'], 'fslm' ) . '</option>';
									}
									?>
								</select>

								<input class="date" id="day" name="dd" maxlength="2" type="number"
								       placeholder="<?php _e( 'Day', 'fslm' ); ?>" min="1" max="31">

								<input class="date" id="year" name="yy" size="4" maxlength="4" type="text"
								       placeholder="<?php _e( 'Year', 'fslm' ); ?>">
							</div>
							<div class="helper">?
								<div class="tip">
									<?php echo __( 'Keep Expiration Date fields empty if your product doesn\'t expire', 'fslm' ); ?>
								</div>
							</div>
						</div>

					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Validity (Days)', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="valid" id="valid" type="number" min="0" value="0">
							<div class="helper">?
								<div class="tip">
									<?php echo __( 'Number of <b>Days</b> before the license key expires<br>Expiration date will be calculated based on this value after purchase completed, keep <b>Expiration Date</b> fields empty if you want to use this option<br><b>Set to 0 if your product doesn\'t expire</b>', 'fslm' ); ?>
								</div>
							</div>
						</div>

					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Status', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<select class="input-field" name="license_status">
								<?php
								foreach ( $status as $key => $statu ) {
									echo '<option value="' . strtolower( $key ) . '">' . __( $statu, 'fslm' ) . '</option>';
								}
								?>
							</select>
						</div>
					</div>

					<p class="submit mb">
						<input name="save" class="button button-primary"
						       value="<?php echo __( 'Import License Keys', 'fslm' ); ?>" type="submit">
						<br class="clear">
					</p>
				</form>
			</div>

			<div class="elko">
				<h3><?php echo __( 'Import Image License Keys From .zip File', 'fslm' ); ?></h3>
				<form id="fslm-bulk-image-import" method="post" action="<?php echo admin_url( 'admin-ajax.php' ) ?>"
				      enctype="multipart/form-data">

					<input type="hidden" name="action" value="fslm_import_ilko">

					<div class="input-box">
						<p class="tip"><?php echo __( 'A zip file that contains image license keys(No sub-folders)', 'fslm' ); ?></p>
						<div class="label">
							<span><?php echo __( 'Zip File', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="ilk_source_file" type="file" accept="application/zip">
						</div>
					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Product or Variation', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<select class="input-field" id="wclm_iilk_product_id_select">
								<?php

								global $wpdb;

								// Retrieve all products
								$products = $wpdb->get_results( $wpdb->prepare( "SELECT ID, post_title FROM {$wpdb->posts} WHERE post_type = %s AND post_status != 'auto-draft'", "product" ), ARRAY_A );

								// Retrieve all product variations
								$variations = $wpdb->get_results( $wpdb->prepare( "SELECT ID, post_title, post_parent FROM {$wpdb->posts} WHERE post_type = %s AND post_status != 'auto-draft'", "product_variation" ), ARRAY_A );

								// Create an array to track products with variations
								$products_with_variations = array_column( $variations, 'post_parent' );

								// Display products without variations
								foreach ( $products as $product ) {
									if ( ! in_array( $product['ID'], $products_with_variations ) ) {
										echo '<option value="product_' . $product['ID'] . '">' . $product['ID'] . ' - ' . $product['post_title'] . '</option>';
									}
								}

								// Display variations
								foreach ( $variations as $variation ) {
									if ( $variation['post_title'] != "" ) {
										echo '<option value="variation_' . $variation['ID'] . '_' . $variation['post_parent'] . '">' . $variation['ID'] . ' - ' . $variation['post_title'] . '</option>';
									}
								}

								?>
							</select>
						</div>
					</div>

					<!-- Hidden inputs to hold product and variation IDs -->
					<input type="hidden" id="wclm_iilk_product_id" name="product_id" value="">
					<input type="hidden" id="wclm_iilk_variation_id" name="variation_id" value="">


					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Number Of Times To Deliver This Key', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="deliver_x_times" id="deliver_x_times" type="number" min="1"
							       value="1">
							<div class="helper">?
								<div class="tip">
									<?php echo __( 'The status will only change to sold after the key is sold the number of times in the input above', 'fslm' ); ?>
								</div>
							</div>
						</div>

					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Maximum Activations', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="max_instance_number" id="max_instance_number" type="number"
							       min="0" value="0">
							<div class="helper">?
								<div class="tip">
									<?php echo __( 'Requires the implementation for the Tracking API, Ignore this field if your product is untraceable(the Tracking API is designed for software products, themes... digital products in general)', 'fslm' ); ?>
								</div>
							</div>
						</div>

					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Expiration Date', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<div class="timestamp-wrap">
								<select class="date" id="month" name="mm">
									<option value=""></option>
									<?php
									foreach ( $months as $month ) {
										echo '<option value="' . $month['number'] . '" data-text="' . __( $month['text'], 'fslm' ) . '">' . $month['number'] . '-' . __( $month['text'], 'fslm' ) . '</option>';
									}
									?>
								</select>

								<input class="date" id="day" name="dd" maxlength="2" type="number"
								       placeholder="<?php _e( 'Day', 'fslm' ); ?>" min="1" max="31">

								<input class="date" id="year" name="yy" size="4" maxlength="4" type="text"
								       placeholder="<?php _e( 'Year', 'fslm' ); ?>">
							</div>
							<div class="helper">?
								<div class="tip">
									<?php echo __( 'Keep Expiration Date fields empty if your product doesn\'t expire', 'fslm' ); ?>
								</div>
							</div>
						</div>

					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Validity (Days)', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="valid" id="valid" type="number" min="0" value="0">
							<div class="helper">?
								<div class="tip">
									<?php echo __( 'Number of <b>Days</b> before the license key expires<br>Expiration date will be calculated based on this value after purchase completed, keep <b>Expiration Date</b> fields empty if you want to use this option<br><b>Set to 0 if your product doesn\'t expire</b>', 'fslm' ); ?>
								</div>
							</div>
						</div>

					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'Status', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<select class="input-field" name="license_status">
								<?php
								foreach ( $status as $key => $statu ) {
									echo '<option value="' . strtolower( $key ) . '">' . __( $statu, 'fslm' ) . '</option>';
								}
								?>
							</select>
						</div>
					</div>

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'License Key', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<select class="input-field" name="license_source">
								<option value="1"><?php esc_html_e( 'Randomly generated', 'fslm' ); ?></option>
								<option value="2"><?php esc_html_e( 'Use file name', 'fslm' ); ?></option>
							</select>
						</div>
					</div>

					<p class="submit mb">
						<input id="fslm-bulk-image-import-btn" name="save" class="button button-primary"
						       value="<?php echo __( 'Import License Keys', 'fslm' ); ?>" type="submit">
						<span class="fslm-percent"><?php echo __( 'Upload progress:', 'fslm' ); ?> <span
								id="fslm-percent">0%</span></span>
						<br class="clear">
					</p>

				</form>
			</div>


			<div class="elk">
				<h3><?php echo __( 'Import License Keys', 'fslm' ); ?></h3>
				<form method="post" action="<?php echo admin_url( 'admin-ajax.php' ) ?>" enctype="multipart/form-data">

					<input type="hidden" name="action" value="fslm_import_csv_lk">

					<div class="input-box">
						<p class="tip"><?php echo __( 'CSV file generated by the plugin in the export page', 'fslm' ); ?></p>
						<div class="label">
							<span><?php echo __( 'CSV File', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="ilk_source_file" type="file" accept=".csv">
						</div>
					</div>

					<p class="submit mb">
						<input name="save" class="button button-primary"
						       value="<?php echo __( 'Import License Keys', 'fslm' ); ?>" type="submit">
						<br class="clear">
					</p>
				</form>
			</div>

			<div class="elk">
				<h3><?php echo __( 'Import License Keys (File modified in Excel or any other CSV file editor)', 'fslm' ); ?></h3>
				<p><?php echo __( 'Note: Only file exported using "Export License Keys (Editable Unencrypted License keys)" are supported by this option.', 'fslm' ); ?></p>
				<form method="post" action="<?php echo admin_url( 'admin-ajax.php' ) ?>" enctype="multipart/form-data">

					<input type="hidden" name="action" value="fslm_import_csv_lk_une_edit">

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'CSV File', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="ilk_source_file" type="file" accept=".csv">
						</div>
					</div>

					<p class="submit mb">
						<input name="save" class="button button-primary"
						       value="<?php echo __( 'Import License Keys', 'fslm' ); ?>" type="submit">
						<br class="clear">
					</p>
				</form>
			</div>

			<div class="elk">
				<h3><?php echo __( 'Import License Keys (Unencrypted License Keys)', 'fslm' ); ?></h3>
				<form method="post" action="<?php echo admin_url( 'admin-ajax.php' ) ?>" enctype="multipart/form-data">

					<input type="hidden" name="action" value="fslm_import_csv_lk_une">

					<div class="input-box">
						<p class="tip"><?php echo __( 'CSV file generated by the plugin in the export page', 'fslm' ); ?></p>
						<div class="label">
							<span><?php echo __( 'CSV File', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="ilk_source_file" type="file" accept=".csv">
						</div>
					</div>

					<p class="submit mb">
						<input name="save" class="button button-primary"
						       value="<?php echo __( 'Import License Keys', 'fslm' ); ?>" type="submit">
						<br class="clear">
					</p>
				</form>
			</div>


			<div class="elk">
				<h3><?php echo __( 'Import License Keys (Compatibility Mode)', 'fslm' ); ?></h3>
				<form method="post" action="<?php echo admin_url( 'admin-ajax.php' ) ?>" enctype="multipart/form-data">

					<input type="hidden" name="action" value="fslm_import_csv_cpm_lk">

					<div class="input-box">
						<p class="tip"><?php echo __( 'CSV file generated by the plugin in the export page', 'fslm' ); ?></p>
						<div class="label">
							<span><?php echo __( 'CSV File', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="ilk_source_file" type="file" accept=".csv">
						</div>
					</div>

					<p class="submit mb">
						<input name="save" class="button button-primary"
						       value="<?php echo __( 'Import License Keys', 'fslm' ); ?>" type="submit">
						<br class="clear">
					</p>
				</form>
			</div>

			<div class="egr">
				<h3><?php echo __( 'Import Generator Rules', 'fslm' ); ?></h3>
				<form method="post" action="<?php echo admin_url( 'admin-ajax.php' ) ?>" enctype="multipart/form-data">

					<input type="hidden" name="action" value="fslm_import_csv_gr">

					<div class="input-box">
						<div class="label">
							<span><?php echo __( 'CSV File', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="igr_source_file" type="file" accept=".csv">
						</div>
					</div>

					<p class="submit mb">
						<input name="save" class="button button-primary"
						       value="<?php echo __( 'Import Generator Rules', 'fslm' ); ?>" type="submit">
						<br class="clear">
					</p>
				</form>
			</div>

			<div class="epg">
				<h3><?php echo __( 'Import Plugin Settings', 'fslm' ); ?></h3>
				<form method="post" action="<?php echo admin_url( 'admin-ajax.php' ) ?>" enctype="multipart/form-data">

					<input type="hidden" name="action" value="fslm_import_ps">

					<div class="input-box">
						<div class="label">
							<span><?php echo __( '.fslmsettings File', 'fslm' ); ?></span>
						</div>
						<div class="input">
							<input class="input-field" name="ips_source_file" type="file" accept=".fslmsettings">
						</div>
					</div>

					<p class="submit mb">
						<input name="save" class="button button-primary"
						       value="<?php echo __( 'Import Plugin Settings', 'fslm' ); ?>" type="submit">
						<br class="clear">
					</p>
				</form>
			</div>

		</div>
	</div>

</div>

<script>
    document.getElementById('wclm_bulk_add_from_textarea_form').addEventListener('submit', function (event) {
        var select = document.getElementById('wclm_baft_product_id_select');
        var selectedValue = select.value;
        var productIdInput = document.getElementById('wclm_baft_product_id');
        var variationIdInput = document.getElementById('wclm_baft_variation_id');

        if (selectedValue.startsWith('product_')) {
            var productId = selectedValue.split('_')[1];
            productIdInput.value = productId;
            variationIdInput.value = '';
        } else if (selectedValue.startsWith('variation_')) {
            var parts = selectedValue.split('_');
            var variationId = parts[1];
            var productId = parts[2];
            variationIdInput.value = variationId;
            productIdInput.value = productId;
        }
    });


    document.getElementById('wclm_import_license_keys').addEventListener('submit', function (event) {
        var select = document.getElementById('wclm_ilk_product_id_select');
        var selectedValue = select.value;
        var productIdInput = document.getElementById('wclm_ilk_product_id');
        var variationIdInput = document.getElementById('wclm_ilk_variation_id');

        if (selectedValue.startsWith('product_')) {
            var productId = selectedValue.split('_')[1];
            productIdInput.value = productId;
            variationIdInput.value = '';
        } else if (selectedValue.startsWith('variation_')) {
            var parts = selectedValue.split('_');
            var variationId = parts[1];
            var productId = parts[2];
            variationIdInput.value = variationId;
            productIdInput.value = productId;
        }
    });

    document.getElementById('fslm-bulk-image-import').addEventListener('submit', function (event) {
        var select = document.getElementById('wclm_iilk_product_id_select');
        var selectedValue = select.value;
        var productIdInput = document.getElementById('wclm_iilk_product_id');
        var variationIdInput = document.getElementById('wclm_iilk_variation_id');

        if (selectedValue.startsWith('product_')) {
            var productId = selectedValue.split('_')[1];
            productIdInput.value = productId;
            variationIdInput.value = '';
        } else if (selectedValue.startsWith('variation_')) {
            var parts = selectedValue.split('_');
            var variationId = parts[1];
            var productId = parts[2];
            variationIdInput.value = variationId;
            productIdInput.value = productId;
        }
    });
</script>
        