<?php defined( 'ABSPATH' ) or die( 'No script kiddies please!' ); ?>
<form method="post" action="options.php">

	<?php
	settings_fields( 'fslm_extra_option_group' );
	do_settings_sections( 'fslm_extra_option_group' );
	?>

	<h3><?php echo esc_html__( 'Extra Settings', 'fslm' ); ?>:</h3>

	<div class="input-box">
		<div class="label">
			<span><?php echo esc_html__( 'Delete Plugins License Keys Tables Before Deactivating The Plugin', 'fslm' ); ?></span>
		</div>
		<div class="input">
			<input type="checkbox"
			       name="fslm_delete_lk_db_tables"
				<?php echo esc_attr( get_option( 'fslm_delete_lk_db_tables', '' ) ) == 'on' ? 'checked' : ''; ?>>
		</div>
	</div>

	<div class="input-box">
		<div class="label">
            <span><?php echo esc_html__( 'Delete Plugins Generator Rules Tables Before Deactivating The Plugin',
		            'fslm' ); ?></span>
		</div>
		<div class="input">
			<input type="checkbox"
			       name="fslm_delete_gr_db_tables"
				<?php echo esc_attr( get_option( 'fslm_delete_gr_db_tables', '' ) ) == 'on' ? 'checked' : ''; ?>>
		</div>
	</div>

	<div class="input-box">
		<div class="label">
            <span><?php echo esc_html__( 'Delete Plugins Licensed Products Tables Before Deactivating The Plugin',
		            'fslm' ); ?></span>
		</div>
		<div class="input">
			<input type="checkbox"
			       name="fslm_delete_lp_db_tables"
				<?php echo esc_attr( get_option( 'fslm_delete_lp_db_tables', '' ) ) == 'on' ? 'checked' : ''; ?>>
		</div>
	</div>

	<div class="input-box">
		<div class="label">
			<span><?php echo esc_html__( 'Enable Debug Logging', 'fslm' ); ?></span>
		</div>
		<div class="input">
			<input type="checkbox" name="fslm_debug_enabled"
				<?php echo esc_attr( get_option( 'fslm_debug_enabled', 'off' ) ) == 'on' ? 'checked' : ''; ?>>
		</div>
	</div>

	<div class="input-box">
		<div class="label">
			<span><?php echo esc_html__( 'Replace invisible characters in license keys with', 'fslm' ); ?></span>
		</div>

		<?php $wclm_replace_invisible_characters = get_option( 'wclm_replace_invisible_characters', 'asis' ); ?>

		<div class="input">
			<select name="wclm_replace_invisible_characters">
				<option <?php echo $wclm_replace_invisible_characters == 'asis' ? 'selected' : '' ?> value="asis"><?php esc_html_e( 'Keep As Is', 'fslm' ) ?></option>
				<option <?php echo $wclm_replace_invisible_characters == 'space' ? 'selected' : '' ?> value="space"><?php esc_html_e( 'Space', 'fslm' ) ?></option>
				<option <?php echo $wclm_replace_invisible_characters == 'nothing' ? 'selected' : '' ?> value="nothing"><?php esc_html_e( 'No thing', 'fslm' ) ?></option>
			</select>
		</div>

		<blockquote>
			<p class="description">
				<?php echo esc_html__( 'This only affects the display. License keys will be stored in the database exactly as you enter them. This option may not remove all invisible characters.', 'fslm' ) ?>
			</p>
		</blockquote>
	</div>

	<div class="input-box">
		<hr>
		<div class="label">
			<span><?php echo esc_html__( 'Use Alternative License Key Delivery Method', 'fslm' ); ?></span>
		</div>
		<div class="input">
			<input type="checkbox" name="fslm_alt_delivery_method"
				<?php echo esc_attr( get_option( 'fslm_alt_delivery_method', 'off' ) ) == 'on' ? 'checked' : ''; ?>>
		</div>

		<blockquote class="text-danger error">
			<?php esc_html_e( 'Do not use it if you sell license keys that can be delivered multiple times.', 'fslm' ); ?>
			<br>
			<?php esc_html_e( 'Do not use if you are using the license key generator feature.', 'fslm' ); ?><br>
		</blockquote>
		<hr>
	</div>

	<?php submit_button(); ?>

</form>

<form method="post" action="options.php">
	<?php
	settings_fields( 'fslm_update_option_group' );
	do_settings_sections( 'fslm_update_option_group' );
	?>

	<input type="hidden" name="fslm_db_version" value="0">

	<?php submit_button( esc_html__( 'Run database update script', 'fslm' ) ); ?>

</form>

<br>

<h3><?php echo esc_html__( 'Delete product license keys', 'fslm' ); ?>:</h3>

<form method="post" action="<?php echo admin_url( 'admin.php?action=delete_product_license_keys' ) ?> ">

	<div class="input-box">


		<?php if ( isset( $_GET['dc'] ) ) { ?>
			<div class="updated">
				<p><?php echo esc_html( $_GET['dc'] ) . ' ' . esc_html__( 'license keys got deleted.', 'fslm' ) ?></p>
			</div>
		<?php } ?>

		<div class="label">
			<span><?php echo esc_html__( 'Product', 'fslm' ); ?></span>
		</div>
		<div class="input">
			<select class="input-field elk_product_id" id="elk_product_id" name="product_id">
				<option value="0">Select Product</option>
				<?php

				global $wpdb;

				// A sql query to return all post titles
				$results = $wpdb->get_results( $wpdb->prepare( "SELECT 
                                                                    ID, 
                                                                    post_title 
                                                                FROM 
                                                                    {$wpdb->posts} 
                                                                WHERE 
                                                                    post_type = %s 
                                                                    AND post_status != 'auto-draft'",
					"product" ), ARRAY_A );


				foreach ( $results as $index => $post ) {
					echo '<option value="' . $post['ID'] . '">' . $post['ID'] . ' - ' . $post['post_title'] . '</option>';
				}

				?>

			</select>
		</div>
	</div>


	<input type="submit" name="submit" id="submit" class="button button-primary"
	       value="<?php echo esc_html__( 'Delete', 'fslm' ); ?>">
	<blockquote>
		<p class="description">
			<?php echo esc_html__( 'All the license keys assigned to that product will be deleted.', 'fslm' ) ?>
		</p>
	</blockquote>

</form>
