<?php
defined( 'ABSPATH' ) || die();

class WCLM_Admin_Menu {
	public function __construct() {
		add_action( 'admin_menu', [ $this, 'add_menu' ] );
	}

	public function add_menu() {
		$user_capability = fslm_vendors_permission() ? 'manage_product' : 'manage_woocommerce';

		if ( FS_WC_licenses_Manager::is_active() ) {
			add_menu_page(
				esc_html__( 'License Manager', 'fslm' ),
				esc_html__( 'License Manager', 'fslm' ),
				$user_capability,
				'license-manager',
				'',
				'dashicons-admin-network',
				25
			);
		}
	}
}

new WCLM_Admin_Menu();

