<?php
defined( 'ABSPATH' ) || die();

class WCLM_License_Keys_Dashboard {
	private $order_by;
	private $order;
	private $columns;
	private $per_page;
	private bool $allow_html_in_license_keys = true;

	private $entity = 'license_keys';

	public function __construct() {
		$this->columns = [
			'license_id'          => 'ID',
			'product_id'          => 'Product',
			'license_key'         => 'License Key',
			'image_license_key'   => 'Image',
			'owner_email_address' => 'Owner',
			'delivre_x_times'     => 'Sales Count',
			'max_instance_number' => 'Activation Limit',
			'order_id'            => 'Order',
			'creation_date'       => 'Creation Date',
			'sold_date'           => 'Sold Date',
			'activation_date'     => 'Activation Date',
			'expiration_date'     => 'Expiration Date',
			'license_status'      => 'Status',
		];

		$this->per_page = (int) get_option( 'fslm_nb_rows_by_page', 15 );

		add_action( 'admin_menu', array( $this, 'add_admin_page' ) );
		add_action( 'admin_init', array( $this, 'save_hidden_columns' ) );
		add_action( 'wp_ajax_fetch_products_variations', array( $this, 'fetch_products_variations_callback' ) );

		if ( isset( $_POST['wclm_bulk_actions'] ) == $this->entity ) {
			if ( $_POST['wclm_bulk_action'] == 'delete' ) {
				wclm_delete_license_keys( $_POST['wclm-bulk-license-keys-ids'] );
			} elseif ( in_array( $_POST['wclm_bulk_action'], [ "available", "expired", "active", "inactive", "sold", "returned", "redeemed", "unregistered" ] ) ) {
				wclm_set_license_keys_status( $_POST['wclm-bulk-license-keys-ids'], $_POST['wclm_bulk_action'] );
			}
		}
	}

	function fetch_products_variations_callback() {
		global $wpdb;

		// Get the search term from the AJAX request
		$search = isset( $_GET['search'] ) ? sanitize_text_field( $_GET['search'] ) : '';

		// Query to get products and variations based on search term
		$query = "
	        SELECT p.ID as product_id, p.post_title as product_name, v.ID as variation_id, v.post_title as variation_name
	        FROM {$wpdb->posts} p
	        LEFT JOIN {$wpdb->posts} v ON v.post_parent = p.ID AND v.post_type = 'product_variation'
	        WHERE p.post_type = 'product' AND p.post_status = 'publish' AND p.post_title LIKE %s
	        ORDER BY p.post_title
	        LIMIT 30
	    ";

		$results = $wpdb->get_results( $wpdb->prepare( $query, '%' . $wpdb->esc_like( $search ) . '%' ) );

		$data = array();
		foreach ( $results as $row ) {
			// Combine product and variation into one option
			$data[] = array(
				'id'   => $row->variation_id ? $row->variation_id : $row->product_id,
				'text' => $row->variation_id ? $row->product_name . ' - ' . $row->variation_name . ' (#' . $row->variation_id . ')' : $row->product_name . ' (#' . $row->product_id . ')'
			);
		}

		// Return the results
		wp_send_json( array(
			'results'     => $data,
			'total_count' => count( $data )
		) );
	}

	public function add_admin_page() {
		$user_capability = fslm_vendors_permission() ? 'manage_product' : 'manage_woocommerce';

		if ( FS_WC_licenses_Manager::is_active() ) {
			add_submenu_page(
				'license-manager',
				esc_html__( 'License Keys', 'fslm' ),
				esc_html__( 'License Keys', 'fslm' ),
				$user_capability,
				'license-manager',
				[ $this, 'render_page' ]
			);
		}
	}

	public function save_hidden_columns() {
		if ( isset( $_POST['wclm_screen_meta_group'] ) && $_POST['wclm_screen_meta_group'] == $this->entity ) {
			check_admin_referer( 'wclm_save_screen_options', 'wclm_save_screen_options_nonce' );

			$hidden = [];
			if ( isset( $_POST['wclm_hidden_columns'] ) ) {
				$hidden = array_diff( array_keys( $this->columns ), $_POST['wclm_hidden_columns'] );
			}

			update_user_meta( get_current_user_id(), 'wclm_license_keys_hidden_columns', $hidden );
		}
	}

	public function render_page() {
		require_once WCLM_PLUGIN_DIR . 'includes/functions.php';

		if ( ( isset( $_GET['function'] ) && $_GET['function'] == 'edit-license' ) && isset( $_GET['license_id'] ) ) {
			require WCLM_PLUGIN_DIR . 'includes/edit_license_key.php';

			die();
		}

		global $wpdb;
		$table_name = $wpdb->prefix . 'wc_fs_product_licenses_keys';

		$this->order_by = isset( $_GET['orderby'] ) ? sanitize_text_field( $_GET['orderby'] ) : 'license_id';
		$this->order    = isset( $_GET['order'] ) && strtolower( $_GET['order'] ) === 'asc' ? 'ASC' : 'DESC';

		// Pagination setup
		$paged  = isset( $_GET['paged'] ) ? (int) $_GET['paged'] : 1;
		$offset = ( $paged - 1 ) * $this->per_page;

		$hidden_columns = get_user_meta( get_current_user_id(), 'wclm_license_keys_hidden_columns', true );
		if ( ! is_array( $hidden_columns ) ) {
			$hidden_columns = [];
		}

		$sortable_columns = array_keys( $this->columns );
		if ( ! in_array( $this->order_by, $sortable_columns ) ) {
			$this->order_by = 'license_id';
		}

		// Filter inputs
		$plain_license_key = isset( $_GET['license_key'] ) ? sanitize_text_field( $_GET['license_key'] ) : '';
		$license_key       = isset( $_GET['license_key'] ) && $_GET['license_key'] != '' ? wclm_encrypt( sanitize_text_field( $_GET['license_key'] ) ) : '';
		$first_name        = isset( $_GET['first_name'] ) ? sanitize_text_field( $_GET['first_name'] ) : '';
		$last_name         = isset( $_GET['last_name'] ) ? sanitize_text_field( $_GET['last_name'] ) : '';
		$email             = isset( $_GET['email'] ) ? sanitize_text_field( $_GET['email'] ) : '';
		$product_variation = isset( $_GET['product_variation'] ) ? sanitize_text_field( $_GET['product_variation'] ) : '';
		$license_status    = isset( $_GET['license_status'] ) && $_GET['license_status'] != 'all' ? sanitize_text_field( $_GET['license_status'] ) : '';
		$created_from      = isset( $_GET['created_from'] ) ? sanitize_text_field( $_GET['created_from'] ) : '';
		$created_to        = isset( $_GET['created_to'] ) ? sanitize_text_field( $_GET['created_to'] ) : '';
		$sold_from         = isset( $_GET['sold_from'] ) ? sanitize_text_field( $_GET['sold_from'] ) : '';
		$sold_to           = isset( $_GET['sold_to'] ) ? sanitize_text_field( $_GET['sold_to'] ) : '';
		$activated_from    = isset( $_GET['activated_from'] ) ? sanitize_text_field( $_GET['activated_from'] ) : '';
		$activated_to      = isset( $_GET['activated_to'] ) ? sanitize_text_field( $_GET['activated_to'] ) : '';
		$expiated_from     = isset( $_GET['expiated_from'] ) ? sanitize_text_field( $_GET['expiated_from'] ) : '';
		$expiated_to       = isset( $_GET['expiated_to'] ) ? sanitize_text_field( $_GET['expiated_to'] ) : '';

		// Filter query
		$where = '1=1'; // Default condition

		if ( $license_key ) {
			$where .= $wpdb->prepare( " AND license_key LIKE %s", '%' . $wpdb->esc_like( $license_key ) . '%' );
		}
		if ( $first_name ) {
			$where .= $wpdb->prepare( " AND owner_first_name LIKE %s", '%' . $wpdb->esc_like( $first_name ) . '%' );
		}
		if ( $last_name ) {
			$where .= $wpdb->prepare( " AND owner_last_name LIKE %s", '%' . $wpdb->esc_like( $last_name ) . '%' );
		}
		if ( $email ) {
			$where .= $wpdb->prepare( " AND owner_email_address LIKE %s", '%' . $wpdb->esc_like( $email ) . '%' );
		}
		if ( $product_variation ) {
			$where .= $wpdb->prepare( " AND (product_id = %d OR variation_id = %d)", $wpdb->esc_like( $product_variation ), $wpdb->esc_like( $product_variation ) );
		}
		if ( $license_status ) {
			$where .= $wpdb->prepare( " AND license_status LIKE %s", '%' . $wpdb->esc_like( $license_status ) . '%' );
		}
		if ( $created_from ) {
			$where .= $wpdb->prepare( " AND creation_date >= %s", $created_from );
		}
		if ( $created_to ) {
			$where .= $wpdb->prepare( " AND creation_date <= %s", $created_to );
		}
		if ( $sold_from ) {
			$where .= $wpdb->prepare( " AND sold_date >= %s", $sold_from );
		}
		if ( $sold_to ) {
			$where .= $wpdb->prepare( " AND sold_date <= %s", $sold_to );
		}
		if ( $expiated_from ) {
			$where .= $wpdb->prepare( " AND expiration_date >= %s", $expiated_from );
		}
		if ( $expiated_to ) {
			$where .= $wpdb->prepare( " AND expiration_date <= %s", $expiated_to );
		}
		if ( $activated_from ) {
			$where .= $wpdb->prepare( " AND activation_date >= %s", $activated_from );
		}
		if ( $activated_to ) {
			$where .= $wpdb->prepare( " AND activation_date <= %s", $activated_to );
		}

		// Get total count for pagination
		$count_query = "SELECT COUNT(*) FROM $table_name WHERE $where";
		$total_count = $wpdb->get_var( $count_query );
		$total_pages = ceil( $total_count / $this->per_page );

		// Get the paginated results
		$query   = "SELECT * FROM $table_name WHERE $where ORDER BY {$this->order_by} {$this->order} LIMIT %d OFFSET %d";
		$results = $wpdb->get_results( $wpdb->prepare( $query, $this->per_page, $offset ) );

		include WCLM_PLUGIN_DIR . 'new-ui/app/includes/parts/screen-meta.php';

		echo '<div class="wrap fslm wclm">';
		echo '<h1 class="wp-heading-inline">' . esc_html__( 'License Keys', 'fslm' ) . '</h1>&nbsp;' . '<a class="page-title-action" href="' . admin_url( 'admin.php?page=license-manager-add-license-key' ) . '">' . esc_attr__( 'Add New License Key', 'fslm' ) . ' </a>' . '<hr class="wp-header-end">';

		include WCLM_PLUGIN_DIR . 'new-ui/app/includes/parts/table-nav.php';
		include WCLM_PLUGIN_DIR . 'new-ui/app/includes/parts/filter-form.php';

		echo '<div class="wclm-table-responsive">';
		echo '<table class="wp-list-table widefat fixed striped table-view-list wclm-license-keys">
            <thead>
                <tr>';

		echo "<th id='wclm-license-keys-table-checkbox'><input id='wclm-bulk-select-all' type='checkbox'></th>";

		foreach ( $this->columns as $key => $label ) {
			if ( ! in_array( $key, $hidden_columns ) ) {
				$order = ( $this->order_by === $key && $this->order === 'ASC' ) ? 'DESC' : 'ASC';
				$link  = "<a href='?page=license-manager&orderby={$key}&order={$order}'>{$label}</a>";
				echo "<th id='wclm-license-keys-table-{$key}'>{$link}</th>";
			}
		}

		$upload_directory = wp_upload_dir();

		echo '<th>' . esc_html__( 'Actions', 'fslm' ) . '</th>';

		echo '</tr></thead><tbody>';

		if ( ! empty( $results ) ) {
			foreach ( $results as $row ) {
				echo "<tr>";
				echo '<td><input class="wclm-bulk-select" id="wclm-bulk-select-' . $row->license_id . '" type="checkbox" value="' . $row->license_id . '"></td>';
				foreach ( $this->columns as $key => $label ) {
					if ( ! in_array( $key, $hidden_columns ) ) {
						if ( $key === 'license_id' ) {
							echo '<td>' . esc_html( $row->license_id ) . '</td>';
						} elseif ( $key === 'image_license_key' ) {
							if ( $row->image_license_key != '' ) {
								echo '<td><img src="' . esc_url( $upload_directory['baseurl'] . '/fslm_keys/' . $row->image_license_key ) . '" alt="License Key Image" style="max-width: 100px;"></td>';
							} else {
								echo '<td>-</td>';
							}
						} elseif ( $key === 'owner_email_address' ) {
							if ( $row->owner_email_address != '' ) {
								$owner = [ $row->owner_first_name, $row->owner_last_name, $row->owner_email_address ];

								echo '<td>' . esc_html( implode( ' ', $owner ) ) . '</td>';
							} else {
								echo '<td>-</td>';
							}
						} elseif ( $key === 'product_id' ) {
							echo '<td>';
							if ( $row->variation_id == 0 ) {
								$product_query = $wpdb->prepare(
									"SELECT p.post_title AS product_name
                                FROM {$wpdb->posts} AS p
                                WHERE p.ID = %d AND p.post_type = 'product'",
									$row->product_id
								);
								$result        = $wpdb->get_row( $product_query );

								if ( $result ) {
									echo '<a href="' . admin_url( 'post.php?post=' . $row->product_id . '&action=edit' ) . '" target="_blank">' . $result->product_name . ' (#' . $row->product_id . ')' . '</a>';
								} else {
									echo 'Product not found';
								}
							} else {
								$product_query = $wpdb->prepare(
									"SELECT p.post_title AS product_name
                                FROM {$wpdb->posts} AS p
                                WHERE p.ID = %d AND p.post_type = 'product_variation'",
									$row->variation_id
								);
								$result        = $wpdb->get_row( $product_query );

								if ( $result ) {
									echo '<a href="' . admin_url( 'post.php?post=' . $row->product_id . '&action=edit' ) . '" target="_blank">' . $result->product_name . ' (#' . $row->variation_id . ')' . '</a>';
								} else {
									echo 'Variation or Product not found';
								}
							}
							echo '</td>';

						} elseif ( $key === 'license_key' ) {
							if ( $this->allow_html_in_license_keys ) {
								echo '<td><span>' . wp_kses_post( wclm_decrypt( $row->license_key ) ) . '</span></td>';
							} else {
								echo '<td><span>' . esc_html( wclm_decrypt( $row->license_key ) ) . '</span></td>';
							}
						} elseif ( $key === 'license_status' ) {
							echo '<td>' . ucfirst( $row->license_status ) . '</td>';
						} elseif ( $key === 'valid' ) {
							if ( (int) $row->valid > 0 ) {
								echo '<td>' . $row->valid . esc_html__( 'Days', 'fslm' ) . '</td>';
							} else {
								echo '<td>-</td>';
							}
						} elseif ( $key === 'order_id' ) {
							if ( $row->order_id > 0 ) {
								echo '<td><a href="' . admin_url( 'post.php?post=' . $row->order_id . '&action=edit' ) . '">' . esc_html__( 'Order #', 'fslm' ) . $row->order_id . '</a></td>';
							} else {
								echo '<td>-</td>';
							}
						} elseif ( $key === 'max_instance_number' ) {
							echo '<td>' . ( (int) $row->max_instance_number - (int) $row->number_use_remaining ) . '/' . $row->max_instance_number . '</td>';
						} elseif ( $key === 'delivre_x_times' ) {
							echo '<td>' . ( (int) $row->delivre_x_times - (int) $row->remaining_delivre_x_times ) . '/' . $row->delivre_x_times . '</td>';
						} elseif ( $key === 'expiration_date' ) {
							if ( $row->expiration_date != '0000-00-00' && $row->expiration_date != null ) {
								echo '<td>' . wclm_format_date( $row->expiration_date ) . '</td>';
							} elseif ( $row->valid > 0 && $row->license_status == 'available' ) {
								echo '<td>' . sprintf( esc_html__( '%d Days After Purchase', 'fslm' ), $row->valid ) . '</td>';
							} else {
								echo '<td>-</td>';
							}
						} elseif ( $key === 'creation_date' ) {
							if ( $row->creation_date != '0000-00-00' && $row->creation_date != null ) {
								echo '<td>' . wclm_format_date( $row->creation_date ) . '</td>';
							} else {
								echo '<td>-</td>';
							}
						} elseif ( $key === 'sold_date' ) {
							if ( $row->sold_date != '0000-00-00' && $row->sold_date != null ) {
								echo '<td>' . wclm_format_date( $row->sold_date ) . '</td>';
							} else {
								echo '<td>-</td>';
							}
						} elseif ( $key === 'activation_date' ) {
							if ( $row->activation_date != '0000-00-00' && $row->activation_date != null ) {
								echo '<td>' . wclm_format_date( $row->activation_date ) . '</td>';
							} else {
								echo '<td>-</td>';
							}
						}
					}
				}

				include WCLM_PLUGIN_DIR . 'new-ui/app/includes/parts/license-key-actions.php';

				echo "</tr>";
			}
		} else {
			echo '<tr><td colspan="' . count( $this->columns ) . '">No licenses found.</td></tr>';
		}

		echo '</tbody></table></div>';

		echo '<div class="tablenav bottom">';
		include WCLM_PLUGIN_DIR . 'new-ui/app/includes/parts/pagination.php';
		echo '</div>';

		echo '</div>';
	}

}

new WCLM_License_Keys_Dashboard();
