<?php
defined( 'ABSPATH' ) || die();

function wclm_encrypt( $str ) {
	return encrypt_decrypt( 'encrypt', $str, ENCRYPTION_KEY, ENCRYPTION_VI );
}

function wclm_decrypt( $str ) {
	return encrypt_decrypt( 'decrypt', $str, ENCRYPTION_KEY, ENCRYPTION_VI );
}

function wclm_format_date( $date ) {
	return fslm_format_date( $date );
}

function wclm_delete_license_keys( $ids ) {
	global $wpdb;

	$wpdb->query( wclm_prepare_in( "DELETE FROM {$wpdb->prefix}wc_fs_product_licenses_keys WHERE license_id IN([IN])", $ids ) );
}

function wclm_set_license_keys_status( $ids, $status ) {
	global $wpdb;

	if ( $status == 'available' ) {
		$sql = "UPDATE {$wpdb->prefix}wc_fs_product_licenses_keys SET license_status = 'available', remaining_delivre_x_times = 1,  delivre_x_times = 1  WHERE license_id IN([IN])";
		$sql = wclm_prepare_in( $sql, $ids );

		$wpdb->query( $sql );

	} elseif ( $status == 'active' ) {
		$sql = "UPDATE {$wpdb->prefix}wc_fs_product_licenses_keys SET license_status = 'active' WHERE license_id IN([IN])";
		$sql = wclm_prepare_in( $sql, $ids );

		$wpdb->query( $sql );
	} else if ( $status == 'expired' ) {
		$sql = "UPDATE {$wpdb->prefix}wc_fs_product_licenses_keys SET license_status = 'expired' WHERE license_id IN([IN])";
		$sql = wclm_prepare_in( $sql, $ids );

		$wpdb->query( $sql );
	} else if ( $status == 'inactive' ) {
		$sql = "UPDATE {$wpdb->prefix}wc_fs_product_licenses_keys SET license_status = 'inactive' WHERE license_id IN([IN])";
		$sql = wclm_prepare_in( $sql, $ids );

		$wpdb->query( $sql );
	} else if ( $status == 'sold' ) {
		$sql = "UPDATE {$wpdb->prefix}wc_fs_product_licenses_keys SET license_status = 'sold' WHERE license_id IN([IN])";
		$sql = wclm_prepare_in( $sql, $ids );

		$wpdb->query( $sql );

	} else if ( $status == 'returned' ) {
		$sql = "UPDATE {$wpdb->prefix}wc_fs_product_licenses_keys SET license_status = 'returned' WHERE license_id IN([IN])";
		$sql = wclm_prepare_in( $sql, $ids );

		$wpdb->query( $sql );
	} else if ( $status == 'redeemed' ) {
		$sql = "UPDATE {$wpdb->prefix}wc_fs_product_licenses_keys SET license_status = 'redeemed' WHERE license_id IN([IN])";
		$sql = wclm_prepare_in( $sql, $ids );

		$wpdb->query( $sql );
	} else if ( $status == 'unregistered' ) {
		$sql = "UPDATE {$wpdb->prefix}wc_fs_product_licenses_keys SET license_status = 'unregistered' WHERE license_id IN([IN])";
		$sql = wclm_prepare_in( $sql, $ids );

		$wpdb->query( $sql );
	}
}

function wclm_delete_generator( $ids ) {
	global $wpdb;

	$wpdb->query( wclm_prepare_in( "DELETE FROM {$wpdb->prefix}wc_fs_product_licenses_keys_generator_rules WHERE rule_id IN([IN])", $ids ) );
}

function wclm_set_generator_status( $ids, $status ) {
	global $wpdb;

	if ( $status == 'activate' ) {
		$sql = "UPDATE {$wpdb->prefix}wc_fs_product_licenses_keys_generator_rules SET active = '1' WHERE rule_id IN([IN])";
		$sql = wclm_prepare_in( $sql, $ids );

		$wpdb->query( $sql );
	} else if ( $status == 'deactivate' ) {
		$sql = "UPDATE {$wpdb->prefix}wc_fs_product_licenses_keys_generator_rules SET active = '0' WHERE rule_id IN([IN])";
		$sql = wclm_prepare_in( $sql, $ids );

		$wpdb->query( $sql );
	}
}

function wclm_delete_image( $file ) {
	$upload_directory = wp_upload_dir();
	$target_file      = $upload_directory['basedir'] . '/fslm_keys/' . $file;
	if ( file_exists( $target_file ) ) {
		chmod( $target_file, 0777 );
		unlink( $target_file );
	}
}


function wclm_prepare_in( $sql, $vals ) {
	global $wpdb;

	if ( ! is_array( $vals ) ) {
		$vals = explode( ',', $vals );
	}

	$not_in_count = substr_count( $sql, '[IN]' );
	if ( $not_in_count > 0 ) {
		$args = array(
			str_replace( '[IN]', implode( ', ', array_fill( 0, count( $vals ), '%d' ) ), str_replace( '%', '%%', $sql ) )
		);
		// This will populate ALL the [IN]'s with the $vals, assuming you have more than one [IN] in the sql
		for ( $i = 0; $i < substr_count( $sql, '[IN]' ); $i ++ ) {
			$args = array_merge( $args, $vals );
		}
		$sql = call_user_func_array( array( $wpdb, 'prepare' ), array_merge( $args ) );
	}

	return $sql;
}