<?php defined( 'ABSPATH' ) || die(); ?>


<div class="tablenav-pages">
	<span class="displaying-num">(<?php echo $total_count; ?>&nbsp;<?php esc_html_e( 'items', 'fslm' ) ?>)&nbsp;<?php echo $paged; ?>&nbsp;<?php esc_html_e( 'out of', 'fslm' ) ?>&nbsp;<?php echo $total_pages; ?>&nbsp;<?php esc_html_e( 'pages', 'fslm' ) ?></span>
	<span class="pagination-links">

           <?php
           $params            = $_GET;
           $params['page']    = 'wclm-generators';
           $params['orderby'] = $this->order_by;
           $params['order']   = $this->order;

           // First page link
           if ( $paged > 1 ) {
	           $params['paged'] = 1;
	           $url             = '?' . http_build_query( $params );
	           ?>
	           <a class="first-page button" href="<?php echo $url; ?>">
		           <span class="screen-reader-text">«</span><span aria-hidden="true">«</span>
	           </a>
           <?php }
           echo "&nbsp;";

           // Page number links
           $range      = 2;
           $start_page = max( 1, $paged - $range );
           $end_page   = min( $total_pages, $paged + $range );

           if ( $paged <= $range ) {
	           $end_page = min( $total_pages, 5 );
           }

           if ( $paged + $range > $total_pages ) {
	           $start_page = max( 1, $total_pages - 4 );
           }

           for ( $i = $start_page; $i <= $end_page; $i ++ ) {
	           $params['paged'] = $i;
	           $url             = '?' . http_build_query( $params );

	           if ( $i == $paged ) { ?>
		           <span class="tablenav-pages-navspan button disabled" aria-hidden="true"><?php echo $i; ?></span>
	           <?php } else { ?>
		           <a class="page button" href="<?php echo $url; ?>">
                        <?php echo $i; ?>
                    </a>
	           <?php }
	           echo "&nbsp;";
           }

           // Last page link
           if ( $paged < $total_pages ) {
	           $params['paged'] = $total_pages;
	           $url             = '?' . http_build_query( $params );
	           ?>
	           <a class="last-page button" href="<?php echo $url; ?>">
		           <span class="screen-reader-text">»</span><span aria-hidden="true">»</span>
	           </a>
           <?php }
           ?>


        </span>
</div>


