<?php defined( 'ABSPATH' ) || die(); ?>

<div id="screen-meta" class="metabox-prefs">
	<div id="screen-options-wrap" class="" tabindex="-1" aria-label="Screen Options Tab">
		<form id="adv-settings" method="post">
			<?php wp_nonce_field( 'wclm_save_screen_options', 'wclm_save_screen_options_nonce' ) ?>

			<input type="hidden" name="wclm_screen_meta_group" value="<?php echo esc_attr($this->entity) ?>">

			<fieldset class="metabox-prefs">
				<legend>Columns</legend>

				<?php foreach ( $this->columns as $key => $value ) { ?>
					<label><input class="show-column-tog" name="wclm_hidden_columns[]" type="checkbox" value="<?php echo esc_attr( $key ) ?>" <?php echo ! in_array( $key, $hidden_columns ) ? 'checked="checked"' : '' ?>><?php echo esc_html( $value ) ?></label>
				<?php } ?>
			</fieldset>

			<p class="submit">
				<button type="submit" class="button button-primary"><?php esc_html_e( 'Apply', 'fslm' ) ?></button>
			</p>
		</form>
	</div>
</div>

<div id="screen-meta-links">
	<div id="screen-options-link-wrap" class="hide-if-no-js screen-meta-toggle">
		<button type="button" id="show-settings-link" class="button show-settings" aria-controls="screen-options-wrap" aria-expanded="false">Screen Options</button>
	</div>
</div>

