(function ($) {
    jQuery(document).ready(function ($) {
        $('.product-variation-select').select2({
            placeholder: 'Product/Variation',
            ajax: {
                url: ajaxurl,
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        action: 'fetch_products_variations', // Custom AJAX action
                        search: params.term, // Search term entered by user
                        page: params.page || 1
                    };
                },
                processResults: function (data, params) {
                    params.page = params.page || 1;
                    return {
                        results: data.results,
                        pagination: {
                            more: (params.page * 30) < data.total_count
                        }
                    };
                },
                cache: true
            },
            escapeMarkup: function (markup) {
                return markup;
            },
            minimumInputLength: 1
        });

        $(document).ready(function () {
            $("#wclm-bulk-select-all").change(function () {
                $(".wclm-bulk-select").prop("checked", this.checked);
            });

            $(".wclm-bulk-select").change(function () {
                $("#wclm-bulk-select-all").prop(
                    "checked",
                    $(".wclm-bulk-select").length === $(".wclm-bulk-select:checked").length
                );
            });
        });

        $('#wclm-license-keys-bulk-action-form').on('submit', function (e) {
            const selectedValues = $('.wclm-bulk-select:checked').map(function () {
                return this.value;
            }).get().join(',');

            $('#wclm-bulk-license-keys-ids').val(selectedValues);
        });

        $('#wclm-generator-bulk-action-form').on('submit', function (e) {
            const selectedValues = $('.wclm-bulk-select:checked').map(function () {
                return this.value;
            }).get().join(',');

            $('#wclm-bulk-generator-ids').val(selectedValues);
        });

        $(document).ready(function () {
            $("#wclm-show-filter-options").click(function () {
                $("#wclm-filter-options").toggle();
            });
        });

        jQuery(document).ready(function ($) {
            $('.wclm-delete-license-key').on('click', function (event) {
                event.preventDefault(); // Prevent the default link action

                let $this = $(this);

                if ($this.data('clicked')) {
                    window.location.href = $this.attr('href'); // Navigate to the link
                } else {
                    $this.text('Delete?').css('color', '#d63638').css('font-weight', '600').data('clicked', true);
                }
            });
        });

        jQuery(document).ready(function ($) {
            $('.wclm-delete-generator').on('click', function (event) {
                event.preventDefault(); // Prevent the default link action

                let $this = $(this);

                if ($this.data('clicked')) {
                    window.location.href = $this.attr('href'); // Navigate to the link
                } else {
                    $this.text('Delete?').css('color', '#d63638').css('font-weight', '600').data('clicked', true);
                }
            });
        });

    });
})(jQuery);