<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Medcity
 */
$post_tags_on = medcity_get_opt( 'post_tags_on', true );
$post_navigation_on = medcity_get_opt( 'post_navigation_on', false );
$post_author_info_on = medcity_get_opt( 'post_author_info_on', false );
$post_social_share_on = medcity_get_opt( 'post_social_share_on', false );
$post_feature_image_on = medcity_get_opt( 'post_feature_image_on', true );
$post_title_on = medcity_get_opt('post_title_on', false);
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('single-hentry'); ?>>
    <?php if (has_post_format('gallery')) : ?>
        <div class="entry-featured">
            <?php
            $light_box = medcity_get_post_format_value('post-gallery-lightbox', '0');
            $gallery_list = explode(',', medcity_get_post_format_value('post-gallery-images', ''));
            wp_enqueue_script( 'owl-carousel' );
            wp_enqueue_script( 'medcity-carousel' );
            ?>
            <div class="cms-carousel owl-carousel featured-active <?php if($light_box) {echo 'images-light-box';} ?>" data-item-xs="1" data-item-sm="1" data-item-md="1" data-item-lg="1" data-item-xl="1" data-item-xxl="1" data-margin="30" data-loop="true" data-autoplay="false" data-autoplaytimeout="5000" data-smartspeed="250" data-center="false" data-arrows="true" data-bullets="false" data-stagepadding="0" data-stagepaddingsm="0" data-rtl="false">
                <?php
                foreach ($gallery_list as $img_id):
                    ?>
                    <div class="cms-carousel-item">
                        <a class="light-box" href="<?php echo esc_url(wp_get_attachment_image_url($img_id, 'full'));?>"><img src="<?php echo esc_url(wp_get_attachment_image_url($img_id, 'large'));?>" alt="<?php echo esc_attr(get_post_meta( $img_id, '_wp_attachment_image_alt', true )) ?>"></a>
                    </div>
                    <?php
                endforeach;
                ?>
            </div>
            <h2 class="entry-title">
                <a href="<?php echo esc_url( get_permalink()); ?>">
                    <?php if(is_sticky()) { ?>
                        <i class="fa fa-thumb-tack"></i>
                    <?php } ?>
                    <?php the_title(); ?>
                </a>
            </h2>
        </div>
    <?php elseif (has_post_format('quote')) : ?>
        <div class="entry-featured">
            <?php
                $quote_text = medcity_get_post_format_value('post-quote-cite', '');
                echo esc_attr($quote_text);
            ?>
        </div>
    <?php elseif (has_post_format('link')) : ?>
        <div class="entry-featured">
            <?php
                $link_pf = medcity_get_post_format_value('post-link-url', '#');
                echo esc_url($link_pf);
            ?>
        </div>
    <?php elseif (has_post_format('video')) : ?>
        <div class="entry-featured">
            <div class="entry-video featured-active">
                <?php
                $video_url = medcity_get_post_format_value('post-video-url', '#');
                $video_file = medcity_get_post_format_value('post-video-file', '');
                $video_html = medcity_get_post_format_value('post-video-html', '');
                $video = '';
                if (!empty($video_url)) {
                    global $wp_embed;
                    echo esc_html($wp_embed->run_shortcode('[embed]' . $video_url . '[/embed]'));
                } elseif (!empty($video_file)) {
                    if (strpos('[embed', $video_file)) {
                        global $wp_embed;
                        echo esc_html($wp_embed->run_shortcode($video_file));
                    } else {
                        echo do_shortcode($video_file);
                    }
                } else {
                    if ('' != $video_html) {
                        echo esc_html($video_html);
                    }
                }
                ?>
            </div>
        </div>
    <?php elseif (has_post_format('audio')) : ?>
        <div class="entry-featured">
            <?php
            $audio_url = medcity_get_post_format_value('post-audio-url', '#');
            echo esc_url($audio_url);
            ?>
        </div>
    <?php else :
        if (has_post_thumbnail()) {
            $post_categories_on = medcity_get_opt( 'post_categories_on', true );
            ?>
            <div class="entry-featured">
                <div class="post-image">
                    <?php the_post_thumbnail('large'); ?>
                </div>
                <?php if($post_categories_on) : ?>
                    <div class="post-category"><?php the_terms( get_the_ID(), 'category', '', ', ' ); ?></div>
                <?php endif; ?>
            </div>
            <?php
        } ?>
    <?php endif; ?>
    <div class="entry-body">
        <div class="entry-content-top">
            <?php medcity_post_meta(); ?>
            <?php if($post_title_on){ ?>
                <div class="data">
                    <h2 class="entry-title">
                        <?php the_title(); ?>
                    </h2>
                </div>
            <?php } ?>
            <div class="entry-content clearfix">
                <?php
                the_content();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
                ?>
            </div><!-- .entry-content -->
        </div>
        <?php
        if ( get_the_tag_list() || $post_social_share_on ){
            ?>
            <div class="entry-content-bottom">
                <?php
                if($post_social_share_on) {
                    medcity_socials_share_default();
                }
                if($post_tags_on) :
                    medcity_entry_tagged_in();
                endif;
                ?>
            </div>
            <?php
        }
        ?>
        <?php if($post_navigation_on) : ?>
            <div class="entry-navigation">
                <?php medcity_post_nav_default(); ?>
            </div>
        <?php endif; ?>
        <?php if($post_author_info_on) : ?>
            <div class="entry-author-info">
                <div class="author-post">
                    <div class="author-avatar">
                            <?php echo get_avatar( get_the_author_meta( 'ID' ), 'full' ); ?>
                        </div>
                    <div class="author-description">
                        <div class="author-name">
                            <?php the_author_posts_link(); ?>
                        </div>
                        <p>
                            <?php the_author_meta( 'description' ); ?>
                        </p>
                        <?php medcity_get_user_social(); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</article><!-- #post -->